/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.dataretention.core.b.a;

import com.tplink.smb.omada.maintenance.dataretention.core.DataRetentionInformDTO;
import com.tplink.smb.omada.maintenance.dataretention.core.DataRetentionSettingDTO;
import com.tplink.smb.omada.maintenance.dataretention.core.MspDataRetentionInformDTO;
import com.tplink.smb.omada.maintenance.dataretention.core.OmadacDataRetentionInformDTO;
import com.tplink.smb.omada.maintenance.domain.model.f.b;
import com.tplink.smb.omada.maintenance.domain.model.f.e;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class a
implements com.tplink.smb.omada.maintenance.dataretention.core.b.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    private static final int b = 200;
    private static final int c = 180;
    private com.tplink.smb.omada.maintenance.dataretention.core.a d;

    @Override
    public void a(List<e> clearOmadacs) {
        this.c(clearOmadacs);
    }

    @Override
    public void b(List<com.tplink.smb.omada.maintenance.domain.model.d.a> clearMsps) {
        this.d(clearMsps);
    }

    private void c(List<e> clearOmadacs) {
        int pageSize = 200;
        int pageCount = this.a(clearOmadacs, pageSize);
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            List<e> subClearOmadacs = this.a(clearOmadacs, pageSize, pageIndex);
            List<OmadacDataRetentionInformDTO> omadacDataRetentionInformDTOS = subClearOmadacs.stream().map(setting -> {
                b dataRetentionSetting = setting.d();
                DataRetentionSettingDTO dto = new DataRetentionSettingDTO();
                dto.setFiveMin(dataRetentionSetting.i());
                dto.setTenMin(dataRetentionSetting.j());
                dto.setHourly(dataRetentionSetting.k());
                dto.setDaily(dataRetentionSetting.l());
                dto.setWeekly(dataRetentionSetting.m());
                dto.setKnownClient(dataRetentionSetting.n());
                dto.setPortalAuth(dataRetentionSetting.o());
                dto.setClientHistory(dataRetentionSetting.p());
                dto.setLog(dataRetentionSetting.q());
                dto.setRogueAp(dataRetentionSetting.r());
                dto.setWidsData(dataRetentionSetting.s());
                return OmadacDataRetentionInformDTO.builder().omadacId(setting.b()).retention(Optional.ofNullable(setting.c()).orElse(180)).dataRetentionSetting(dto).build();
            }).collect(Collectors.toList());
            this.d.a(new DataRetentionInformDTO().setClearOmadacs(omadacDataRetentionInformDTOS).setClearMsps(Collections.emptyList()));
        }
    }

    private void d(List<com.tplink.smb.omada.maintenance.domain.model.d.a> clearMsps) {
        int pageSize = 200;
        int pageCount = this.a(clearMsps, pageSize);
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            List<com.tplink.smb.omada.maintenance.domain.model.d.a> subClearMsps = this.a(clearMsps, pageSize, pageIndex);
            List<MspDataRetentionInformDTO> mspDataRetentionInformDTOS = subClearMsps.stream().map(setting -> {
                b dataRetentionSetting = setting.e();
                DataRetentionSettingDTO dto = new DataRetentionSettingDTO();
                dto.setFiveMin(dataRetentionSetting.i());
                dto.setHourly(dataRetentionSetting.k());
                dto.setDaily(dataRetentionSetting.l());
                dto.setWeekly(dataRetentionSetting.m());
                dto.setKnownClient(dataRetentionSetting.n());
                dto.setPortalAuth(dataRetentionSetting.o());
                dto.setClientHistory(dataRetentionSetting.p());
                dto.setLog(dataRetentionSetting.q());
                dto.setRogueAp(dataRetentionSetting.r());
                dto.setWidsData(dataRetentionSetting.s());
                return MspDataRetentionInformDTO.builder().mspId(setting.b()).dataRetentionSetting(dto).build();
            }).collect(Collectors.toList());
            this.d.a(new DataRetentionInformDTO().setClearMsps(mspDataRetentionInformDTOS).setClearOmadacs(Collections.emptyList()));
        }
    }

    @Override
    public void a() {
        this.a(180);
    }

    private void a(int retention) {
        if (retention == 0) {
            return;
        }
        long nowTime = System.currentTimeMillis();
        try {
            this.a(nowTime, retention);
        }
        catch (IOException e2) {
            a.info("Failed to delete log file. Will try next time execute.");
        }
        try {
            this.b(nowTime, retention);
        }
        catch (IOException e3) {
            a.info("Failed to delete database log file. Will try next time execute.");
        }
        this.c(nowTime, retention);
    }

    private void a(long nowTime, int retentionDays) throws IOException {
        a.debug("start to clear rolling log file.");
        String logFilePath = System.getProperty("eap.home", ".") + File.separator + "logs" + File.separator;
        File logFolder = new File(logFilePath);
        File[] filesInLogFolder = logFolder.listFiles();
        if (filesInLogFolder != null) {
            for (File file : filesInLogFolder) {
                SimpleDateFormat sdf;
                String dateString;
                if (!file.getName().startsWith("server_") && !file.getName().startsWith("server.log.")) continue;
                if (file.getName().startsWith("server_")) {
                    dateString = file.getName().replace("server_", "");
                    int endIndex = dateString.indexOf(95);
                    if (endIndex > 0) {
                        dateString = dateString.substring(0, endIndex);
                    }
                    sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
                    sdf.setLenient(false);
                } else {
                    dateString = file.getName().replace("server.log.", "");
                    sdf = new SimpleDateFormat("MM-dd-yyyy", Locale.ROOT);
                    sdf.setLenient(false);
                }
                try {
                    Date logDate = sdf.parse(dateString);
                    if (!this.a(nowTime, logDate.getTime(), retentionDays)) continue;
                    Files.delete(file.toPath());
                }
                catch (ParseException pe) {
                    a.warn("Failed to delete, Not a valid log file.");
                }
            }
        }
    }

    private void b(long nowTime, int retentionDays) throws IOException {
        a.debug("start to clear db log file.");
        String logFilePath = System.getProperty("eap.home", ".") + File.separator + "logs" + File.separator;
        File logFolder = new File(logFilePath);
        File[] filesInLogFolder = logFolder.listFiles();
        if (filesInLogFolder != null) {
            for (File file : filesInLogFolder) {
                if (!file.getName().startsWith("mongod.log.")) continue;
                String dateString = file.getName().replace("mongod.log.", "");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss", Locale.ROOT);
                sdf.setLenient(false);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                try {
                    Date logDate = sdf.parse(dateString);
                    if (!this.a(nowTime, logDate.getTime(), retentionDays)) continue;
                    Files.delete(file.toPath());
                }
                catch (ParseException pe) {
                    a.warn("Failed to delete, Not a valid database log file.");
                }
            }
        }
    }

    private void c(long nowTime, int retentionDays) {
        a.debug("start to clear dump file.");
        String dumpFilePath = System.getProperty("eap.home", ".") + File.separator + "logs" + File.separator + "java_heapdump.hprof";
        File dumpFile = new File(dumpFilePath);
        if (!dumpFile.exists()) {
            return;
        }
        try {
            long lastModified = dumpFile.lastModified();
            Date modifiedDate = new Date(lastModified);
            if (this.a(nowTime, modifiedDate.getTime(), retentionDays)) {
                Files.delete(dumpFile.toPath());
            }
        }
        catch (Exception e2) {
            a.info("Failed to delete the Dump File. cause {}. Will try next time execute.", (Object)e2.getMessage());
        }
    }

    private boolean a(long nowTime, long time, int retentionDays) {
        long diff = nowTime - time;
        long pastDays = diff / 86400000L - 1L;
        return pastDays > (long)retentionDays;
    }

    private <E> int a(List<E> data, int pageSize) {
        int size = data.size();
        return size % pageSize == 0 ? size / pageSize : size / pageSize + 1;
    }

    private <E> List<E> a(List<E> data, int pageSize, int currentPage) {
        int size = data.size();
        int pageStart = currentPage * pageSize;
        int pageEnd = (currentPage + 1) * pageSize;
        if (pageStart >= size) {
            return Collections.emptyList();
        }
        if (pageEnd > size) {
            pageEnd = size;
        }
        return data.subList(pageStart, pageEnd);
    }

    @Autowired
    @Generated
    public a(com.tplink.smb.omada.maintenance.dataretention.core.a dataRetentionInformSender) {
        this.d = dataRetentionInformSender;
    }
}

