/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wireless;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.ac;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.ppsk.PPSKProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.ppsk.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.ppsk.embed.PSKPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.PmkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.PmkProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.SsidOverridePO;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51424TOV51426)
@b(a=e.V1000009010TOV1000009012)
public class PpskCompatibleCommandV51424TOV51426
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PpskCompatibleCommandV51424TOV51426.class);
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.d apMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final a ppskProfileMaintMongoRepository = a.a();
    private final com.tplink.smb.omada.portal.port.mongo.omada.a.a getSequenceNumService = (com.tplink.smb.omada.portal.port.mongo.omada.a.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.portal.port.mongo.omada.a.a.class);
    private final DeviceMaintRepository deviceMaintRepository = DeviceMaintRepository.getInstance();
    private final com.tplink.smb.omada.maintenance.compatible.service.impl.b dbCompatibleCacheService = com.tplink.smb.omada.maintenance.compatible.service.impl.b.a();
    private static final String PPSKV3_COMPONENT_KEY = "ppskV3";
    private static final PpskCompatibleCommandV51424TOV51426 instance = new PpskCompatibleCommandV51424TOV51426();

    private PpskCompatibleCommandV51424TOV51426() {
    }

    public static PpskCompatibleCommandV51424TOV51426 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("Upgrading SsidPO from v5.14.24 to v5.14.26");
        List ssidList = this.ssidMaintMongoRepository.a(new c(omadacId));
        if (CollectionUtils.isEmpty((Collection)ssidList)) {
            return;
        }
        for (SsidPO ssid : ssidList) {
            String ppskProfileId;
            if (!Objects.equals(ssid.getSecurity(), 4) || Objects.isNull(ppskProfileId = ssid.getPpskSetting().getPpskProfileId())) continue;
            PPSKProfilePO ppskProfilePO = this.ppskProfileMaintMongoRepository.a(new c(ssid.getOmadacId()), new com.tplink.smb.omada.maintenance.common.b.a.a.d(ssid.getSiteId()), ppskProfileId);
            if (Objects.isNull(ppskProfilePO)) {
                log.warn("Faild to find ppsk profile, omadacId: {}, siteId: {}, profileId: {}", new Object[]{ssid.getOmadacId(), ssid.getSiteId(), ppskProfileId});
                continue;
            }
            List<PmkPO> pmkPOS = this.caculatePmk(omadacId, ssid.getSiteId(), ssid.getName(), ppskProfilePO);
            if (Objects.isNull(ppskProfilePO.getEntryId())) {
                ppskProfilePO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId, ssid.getSiteId(), this.ppskProfileMaintMongoRepository.b())));
                this.ppskProfileMaintMongoRepository.a(ppskProfilePO);
            }
            PmkProfilePO pmkProfilePO = new PmkProfilePO();
            pmkProfilePO.setEntryId(ppskProfilePO.getEntryId());
            pmkProfilePO.setPmks(pmkPOS);
            ssid.getPpskSetting().setPmkProfile(pmkProfilePO);
        }
        this.ssidMaintMongoRepository.a(ssidList);
        log.debug("Upgrading AP PO from v5.14.24 to v5.14.26 for omadacId {}", (Object)omadacId);
        List apPOList = this.apMaintMongoRepository.a(omadacId, DeviceTypeEnum.a.b());
        if (CollectionUtils.isEmpty((Collection)apPOList)) {
            return;
        }
        for (ApPO apPO : apPOList) {
            if (Objects.isNull(apPO) || CollectionUtils.isEmpty((Collection)apPO.getSsidOverrides())) continue;
            List ssidOverrides = apPO.getSsidOverrides();
            boolean modified = false;
            for (SsidOverridePO ssidOverride : ssidOverrides) {
                if (!Objects.equals(ssidOverride.getSecurity(), 4) || Objects.equals(ssidOverride.getGlobalSsid(), ssidOverride.getSsid())) continue;
                SsidPO ssidPO = this.ssidMaintMongoRepository.a(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(apPO.getSiteId()), ssidOverride.getIndex());
                String ppskProfileId = ssidPO.getPpskSetting().getPpskProfileId();
                PPSKProfilePO ppskProfilePO = this.ppskProfileMaintMongoRepository.a(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(apPO.getSiteId()), ppskProfileId);
                if (Objects.isNull(ppskProfilePO)) {
                    log.warn("Faild to find ppsk profile, omadacId: {}, siteId: {}, profileId: {}", new Object[]{omadacId, apPO.getSiteId(), ppskProfileId});
                    continue;
                }
                List<PmkPO> pmkPOS = this.caculatePmk(omadacId, apPO.getSiteId(), ssidOverride.getSsid(), ppskProfilePO);
                PmkProfilePO pmkProfilePO = new PmkProfilePO();
                pmkProfilePO.setEntryId(ppskProfilePO.getEntryId());
                pmkProfilePO.setPmks(pmkPOS);
                ssidOverride.setPmkProfile(pmkProfilePO);
                modified = true;
            }
            if (!modified) continue;
            apPO.setSsidOverrides(ssidOverrides);
            this.apMaintMongoRepository.a(apPO);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
        List ssidList = this.ssidMaintMongoRepository.a(new c(omadacId));
        if (CollectionUtils.isEmpty((Collection)ssidList)) {
            return;
        }
        List ppskWithoutRadiusList = ssidList.stream().filter(ssidPO -> Objects.equals(ssidPO.getSecurity(), 4)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ppskWithoutRadiusList)) {
            return;
        }
        List devicePOList = this.deviceMaintRepository.findByOmadacId(omadacId);
        if (CollectionUtils.isEmpty((Collection)devicePOList)) {
            return;
        }
        Set<String> deviceMacs = devicePOList.stream().filter(devicePO -> DeviceTypeEnum.a.b().equalsIgnoreCase(devicePO.getType())).map(DevicePO::getMac).collect(Collectors.toSet());
        this.dbCompatibleCacheService.a(omadacId, deviceMacs);
    }

    private List<PmkPO> caculatePmk(String omadacId, String siteId, String ssidOverrideName, PPSKProfilePO ppskProfilePO) {
        ArrayList<PmkPO> pmkPOS = new ArrayList<PmkPO>();
        for (PSKPO pskpo : ppskProfilePO.getPpsk()) {
            String pwd = pskpo.getPsk();
            try {
                byte[] pmkBytes = ac.a((char[])pwd.toCharArray(), (byte[])ssidOverrideName.getBytes(StandardCharsets.UTF_8), (int)4096, (int)32);
                pwd = T.a((byte[])pmkBytes);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e2) {
                log.warn("Failed to calculate pmk, omadacId: {}, siteId: {}, ssid name: {}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)ssidOverrideName)});
                continue;
            }
            PmkPO pmkPO = new PmkPO();
            pmkPO.setPsk(pskpo.getPsk());
            pmkPO.setPmk(pwd);
            pmkPO.setMac(pskpo.getMac());
            pmkPO.setVlan(pskpo.getVlan());
            pmkPOS.add(pmkPO);
        }
        return pmkPOS;
    }
}

