/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wireless;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.ApSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.ApSiteSettingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.BaseApSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.BaseIotAgingTimeSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.CommonSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.CommonSiteSettingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.IotAgingTimeSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.common.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.iot.IotBtIbeaconPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.iot.IotRadioSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.version.ConfigVersionPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApIotRadioSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V60000TOV60100)
@com.tplink.smb.omada.maintenance.compatible.a.b(a=e.V1200000000TOV1200001000)
public class IotConfigCompatibleCommandV60000TOV60100
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IotConfigCompatibleCommandV60000TOV60100.class);
    private static final IotConfigCompatibleCommandV60000TOV60100 instance = new IotConfigCompatibleCommandV60000TOV60100();
    private final a iotBtIbeaconMaintMongoRepository = a.a();
    private final g siteMaintMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b siteTemplateMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d apSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.d apMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.d.a();
    private final b commonSiteSettingMaintMongoRepository = b.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.b configVersionMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.b.a();
    private static final Integer BUILD_IN = 0;
    private static final Integer CONSOLE_MODE_DEFAULT = 0;
    private static final Integer TRANSMIT_POWER_DEFAULT = 0;
    private static final Integer AGING_TIME_DEFAULT = 30;
    private static final Integer AGING_TIME_FORMAT_DEFAULT = 0;
    private static final String IOT_CONFIG_COMPONENT = "iotConfig";
    private static final String IOT_RADIO_SETTING_COMPONENT_VER = "1.2";

    private IotConfigCompatibleCommandV60000TOV60100() {
    }

    public static IotConfigCompatibleCommandV60000TOV60100 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("IotConfig v6.0.0 to v6.1.0.");
        try {
            Map<String, ApSiteSettingTemplatePO> apSiteSettingTemplatePOMap = this.handleRadioSettingTemplate(omadacId);
            this.handleAPTransmitPowerConfigAndRadioSetting(omadacId, apSiteSettingTemplatePOMap);
        }
        catch (Exception e2) {
            log.warn("IotConfig v6.0.0 to v6.1.0 do db compatible error.", (Throwable)e2);
        }
    }

    private void handleAPTransmitPowerConfigAndRadioSetting(String omadacId, Map<String, ApSiteSettingTemplatePO> apSiteSettingTemplatePOMap) {
        List apSiteSettingPOList = this.apSiteSettingMaintMongoRepository.a(new c(omadacId));
        List commonSiteSettingPOList = this.commonSiteSettingMaintMongoRepository.a(new c(omadacId));
        Map apSiteSettingPOMap = apSiteSettingPOList.stream().collect(Collectors.toMap(ApSiteSettingPO::getSiteId, Function.identity()));
        Map commonSiteSettingPOMap = commonSiteSettingPOList.stream().collect(Collectors.toMap(CommonSiteSettingPO::getSiteId, Function.identity()));
        this.siteMaintMongoRepository.a(omadacId, sitePO -> {
            String siteId = sitePO.getId();
            String siteTemplateId = sitePO.getSiteTemplateId();
            List apPOList = this.apMaintMongoRepository.a(omadacId, siteId, DeviceTypeEnum.a.b());
            apPOList.removeIf(apPO -> !apPO.supportIotConfig());
            List iotBtIbeaconPOList = this.iotBtIbeaconMaintMongoRepository.a(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId));
            Map apPOMap = apPOList.stream().collect(Collectors.toMap(DevicePO::getMac, Function.identity()));
            List configVersionPOS = this.configVersionMaintMongoRepository.a(omadacId, apPOMap.keySet());
            Map configVersionPOMap = configVersionPOS.stream().collect(Collectors.toMap(ConfigVersionPO::getMac, Function.identity()));
            Integer buildInTransmitPower = 0;
            for (IotBtIbeaconPO iotBtIbeaconPO : iotBtIbeaconPOList) {
                if (Objects.equals(iotBtIbeaconPO.getBuildIn(), BUILD_IN)) {
                    buildInTransmitPower = iotBtIbeaconPO.getTransmitPower();
                    continue;
                }
                ArrayList macList = new ArrayList(iotBtIbeaconPO.getMacList());
                for (String mac : macList) {
                    ApPO apPO2 = (ApPO)apPOMap.get(mac);
                    if (Objects.isNull(apPO2)) {
                        iotBtIbeaconPO.getMacList().remove(mac);
                        continue;
                    }
                    apPO2.setApIotRadioSettingPO(new ApIotRadioSettingPO(Boolean.valueOf(true), iotBtIbeaconPO.getTransmitPower()));
                    Optional.ofNullable((ConfigVersionPO)configVersionPOMap.get(mac)).map(configVersionPO -> {
                        configVersionPO.addIncConfigFlag(IOT_CONFIG_COMPONENT, IOT_RADIO_SETTING_COMPONENT_VER);
                        return configVersionPO;
                    });
                    apPOMap.remove(mac);
                }
            }
            this.iotBtIbeaconMaintMongoRepository.a(iotBtIbeaconPOList);
            for (Map.Entry entry : apPOMap.entrySet()) {
                ApPO apPO3 = (ApPO)entry.getValue();
                apPO3.setApIotRadioSettingPO(new ApIotRadioSettingPO(Boolean.valueOf(false), buildInTransmitPower));
                Optional.ofNullable((ConfigVersionPO)configVersionPOMap.get(apPO3.getMac())).map(configVersionPO -> {
                    configVersionPO.addIncConfigFlag(IOT_CONFIG_COMPONENT, IOT_RADIO_SETTING_COMPONENT_VER);
                    return configVersionPO;
                });
            }
            this.apMaintMongoRepository.a(apPOList);
            this.configVersionMaintMongoRepository.a(configVersionPOMap.values());
            ApSiteSettingPO apSiteSettingPO = (ApSiteSettingPO)apSiteSettingPOMap.get(siteId);
            CommonSiteSettingPO commonSiteSettingPO = (CommonSiteSettingPO)commonSiteSettingPOMap.get(siteId);
            IotRadioSettingPO iotRadioSettingPO = this.buildDefaultInSite(buildInTransmitPower, commonSiteSettingPO, apSiteSettingPO, (ApSiteSettingTemplatePO)apSiteSettingTemplatePOMap.get(siteTemplateId));
            apSiteSettingPO.setIotRadioSettingPO(iotRadioSettingPO);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingPO);
        });
    }

    private Map<String, ApSiteSettingTemplatePO> handleRadioSettingTemplate(String omadacId) {
        Set siteTemplateIds = this.siteTemplateMaintMongoRepository.b(new c(omadacId));
        List apSiteSettingTemplatePOList = this.apSiteSettingMaintMongoRepository.b(new c(omadacId));
        List commonSiteSettingTemplatePOList = this.commonSiteSettingMaintMongoRepository.b(new c(omadacId));
        Map<String, ApSiteSettingTemplatePO> apSiteSettingTemplatePOMap = apSiteSettingTemplatePOList.stream().collect(Collectors.toMap(ApSiteSettingTemplatePO::getSiteTemplateId, Function.identity()));
        Map commonSiteSettingTemplatePOMap = commonSiteSettingTemplatePOList.stream().collect(Collectors.toMap(CommonSiteSettingTemplatePO::getSiteTemplateId, Function.identity()));
        for (String siteTemplateId : siteTemplateIds) {
            ApSiteSettingTemplatePO apSiteSettingTemplatePO = apSiteSettingTemplatePOMap.get(siteTemplateId);
            CommonSiteSettingTemplatePO commonSiteSettingTemplatePO = (CommonSiteSettingTemplatePO)commonSiteSettingTemplatePOMap.get(siteTemplateId);
            IotRadioSettingPO iotRadioSettingPO = this.buildDefaultInTemplateSite(commonSiteSettingTemplatePO);
            apSiteSettingTemplatePO.setIotRadioSettingPO(iotRadioSettingPO);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingTemplatePO);
        }
        return apSiteSettingTemplatePOMap;
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private IotRadioSettingPO buildDefaultInSite(Integer transmitPower, CommonSiteSettingPO commonSiteSettingPO, ApSiteSettingPO apSiteSettingPO, ApSiteSettingTemplatePO apSiteSettingTemplatePO) {
        IotRadioSettingPO iotRadioSettingPO = new IotRadioSettingPO();
        String templateId = apSiteSettingPO.getTemplateId();
        iotRadioSettingPO.setEnable(Boolean.valueOf(true));
        iotRadioSettingPO.setConsoleMode(CONSOLE_MODE_DEFAULT);
        iotRadioSettingPO.setTransmitPower(transmitPower);
        iotRadioSettingPO.setAgingTime(Optional.ofNullable(commonSiteSettingPO.getAgingTimeSetting()).map(BaseIotAgingTimeSettingPO::getAgingTime).orElse(AGING_TIME_DEFAULT));
        iotRadioSettingPO.setFormat(Optional.ofNullable(commonSiteSettingPO.getAgingTimeSetting()).map(BaseIotAgingTimeSettingPO::getUnit).orElse(AGING_TIME_FORMAT_DEFAULT));
        if (Objects.nonNull(templateId)) {
            Boolean agingTimeOverride = Optional.ofNullable(commonSiteSettingPO.getAgingTimeSetting()).map(IotAgingTimeSettingPO::getOverride).orElse(false);
            Boolean transmitPowerOverride = !Objects.equals(transmitPower, TRANSMIT_POWER_DEFAULT);
            iotRadioSettingPO.setOverride(Boolean.valueOf(agingTimeOverride != false || transmitPowerOverride != false));
        }
        if (Objects.isNull(apSiteSettingPO.getTemplateId()) || Objects.isNull(apSiteSettingTemplatePO) || Objects.isNull(apSiteSettingTemplatePO.getIotRadioSettingPO())) {
            iotRadioSettingPO.setPasscode(String.format("%06d", new Random(System.currentTimeMillis()).nextInt(0, 1000000)));
        } else {
            IotRadioSettingPO iotRadioSettingTemplatePO = apSiteSettingTemplatePO.getIotRadioSettingPO();
            iotRadioSettingPO.setPasscode(iotRadioSettingTemplatePO.getPasscode());
        }
        return iotRadioSettingPO;
    }

    private IotRadioSettingPO buildDefaultInTemplateSite(CommonSiteSettingTemplatePO commonSiteSettingPO) {
        IotRadioSettingPO iotRadioSettingPO = new IotRadioSettingPO();
        iotRadioSettingPO.setEnable(Boolean.valueOf(true));
        iotRadioSettingPO.setConsoleMode(CONSOLE_MODE_DEFAULT);
        iotRadioSettingPO.setPasscode(String.format("%06d", new Random(System.currentTimeMillis()).nextInt(0, 1000000)));
        iotRadioSettingPO.setTransmitPower(TRANSMIT_POWER_DEFAULT);
        iotRadioSettingPO.setAgingTime(Optional.ofNullable(commonSiteSettingPO.getAgingTimeSetting()).map(BaseIotAgingTimeSettingPO::getAgingTime).orElse(AGING_TIME_DEFAULT));
        iotRadioSettingPO.setFormat(Optional.ofNullable(commonSiteSettingPO.getAgingTimeSetting()).map(BaseIotAgingTimeSettingPO::getUnit).orElse(AGING_TIME_FORMAT_DEFAULT));
        return iotRadioSettingPO;
    }
}

