/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.common.concurrent.thread.CommonExecutorProperties;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.ComponentInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import com.tplink.smb.omada.manager.port.mongo.device.osw.BaseOswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.j;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51524TOV60000)
@b(a=e.V1000010024TOV1200000000)
public class WiredCompatibleCommandV51524TOV60000
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV51524TOV60000.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b siteTemplateMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b.a();
    private final g siteMaintMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final c osgMaintMongoRepository = c.a();
    private final com.tplink.smb.omada.judgement.a.e judgeService = (com.tplink.smb.omada.judgement.a.e)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.judgement.a.e.class);
    private final j oswNetworkMaintMongoRepository = j.a();
    private final ExecutorService commonExecutor = (ExecutorService)com.tplink.smb.omada.common.spring.a.a((String)"commThreadPool");
    private final CommonExecutorProperties commonExecutorProperties = (CommonExecutorProperties)com.tplink.smb.omada.common.spring.a.b(CommonExecutorProperties.class);
    private static final int MIN_THREAD_NUM = 1;
    private static final double THREAD_USAGE_RATE = 0.75;
    private static final int MIN_SITE_BATCH_SIZE = 1;
    private static final int DEVICE_TYPE_THIRD_PARTY = 0;
    private static final int DEVICE_TYPE_GATEWAY = 1;
    private static final int DEVICE_TYPE_SWITCH = 2;
    private static final WiredCompatibleCommandV51524TOV60000 instance = new WiredCompatibleCommandV51524TOV60000();

    private WiredCompatibleCommandV51524TOV60000() {
    }

    public static WiredCompatibleCommandV51524TOV60000 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.15.24 to v6.0.0");
        try {
            this.handleLanNetworkDeviceTypeCompatible(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
            this.handleLanNetworkTemplateDeviceTypeCompatible(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
            this.handlePinSettingAutoUnlockCard2Compatible(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.15.24 to v6.0.0 do db compatible error.", (Throwable)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleLanNetworkDeviceTypeCompatible(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        Set siteIds = this.siteMaintMongoRepository.b(omadacId);
        boolean supportEcspV1 = this.judgeService.a(omadacId.a(), "devices:common:compatible:ecsp_v1");
        Map siteIdOsgPOMap = this.osgMaintMongoRepository.e(omadacId).stream().collect(Collectors.toMap(DevicePO::getSiteId, Function.identity()));
        Map<String, Map<Integer, List<OswNetworkPO>>> siteIdVlanOswNetworkListMap = this.oswNetworkMaintMongoRepository.b(omadacId).stream().collect(Collectors.groupingBy(OswNetworkPO::getSite, Collectors.groupingBy(BaseOswNetworkPO::getVlan)));
        int threadNum = (int)Math.max((double)this.commonExecutorProperties.getCommCoreThreads() * 0.75, 1.0);
        int batchSize = Math.max(siteIds.size() / threadNum, 1);
        ArrayList<CompletableFuture<Void>> sendFutures = new ArrayList<CompletableFuture<Void>>();
        List siteIdBatches = Lists.partition(new ArrayList(siteIds), (int)batchSize);
        for (List siteIdBatch : siteIdBatches) {
            if (CollectionUtils.isEmpty((Collection)siteIdBatch)) continue;
            sendFutures.add(CompletableFuture.runAsync(() -> this.handleSites(omadacId, siteIdBatch, siteIdOsgPOMap, siteIdVlanOswNetworkListMap, supportEcspV1), this.commonExecutor));
        }
        sendFutures.forEach(CompletableFuture::join);
    }

    private void handleSites(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, List<String> siteIds, Map<String, OsgPO> siteIdOsgPOMap, Map<String, Map<Integer, List<OswNetworkPO>>> siteIdVlanOswNetworkListMap, boolean supportEcspV1) {
        for (String siteIdStr : siteIds) {
            com.tplink.smb.omada.maintenance.common.b.a.a.d siteId = new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteIdStr);
            Optional<OsgPO> osgPOOptional = Optional.ofNullable(siteIdOsgPOMap.get(siteIdStr));
            boolean bindOsg = osgPOOptional.isPresent() && (supportEcspV1 || !Objects.equals(EcspFirstVersionEnum.V1.getVersion(), osgPOOptional.map(DevicePO::getComponentInfo).map(ComponentInfoPO::getVersion).orElse(null)));
            List lanNetworkPOList = this.lanNetworkMaintMongoRepository.a(omadacId, siteId);
            Map vlanOswNetworkListMap = Optional.ofNullable(siteIdVlanOswNetworkListMap.get(siteIdStr)).orElse(new HashMap());
            for (LanNetworkPO lanNetworkPO : lanNetworkPOList) {
                if (Objects.equals(lanNetworkPO.getPurpose(), "interface")) {
                    lanNetworkPO.setDeviceType(Integer.valueOf(1));
                    if (!osgPOOptional.isPresent() || !bindOsg) continue;
                    lanNetworkPO.setDeviceMac(osgPOOptional.get().getMac());
                    continue;
                }
                if (Objects.equals(lanNetworkPO.getPurpose(), "vlan")) {
                    List enableServerOrRelayOswNetworkList = Optional.ofNullable((List)vlanOswNetworkListMap.get(lanNetworkPO.getVlan())).orElse(new ArrayList());
                    if (enableServerOrRelayOswNetworkList.size() == 1) {
                        OswNetworkPO oswNetworkPO = (OswNetworkPO)enableServerOrRelayOswNetworkList.get(0);
                        lanNetworkPO.setDeviceType(Integer.valueOf(2));
                        lanNetworkPO.setDeviceMac(oswNetworkPO.getMac());
                        lanNetworkPO.setStackId(oswNetworkPO.getStackId());
                        continue;
                    }
                    lanNetworkPO.setDeviceType(Integer.valueOf(0));
                    continue;
                }
                log.warn("unknown network purpose {} when handleLanNetworkDeviceTypeCompatible", (Object)lanNetworkPO.getPurpose());
            }
            this.lanNetworkMaintMongoRepository.a(lanNetworkPOList);
        }
    }

    private void handleLanNetworkTemplateDeviceTypeCompatible(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        Set siteTemplateIds = this.siteTemplateMaintMongoRepository.b(omadacId);
        boolean supportEcspV1 = this.judgeService.a(omadacId.a(), "devices:common:compatible:ecsp_v1");
        for (String siteTemplateIdStr : siteTemplateIds) {
            Optional osgPOOptional = this.osgMaintMongoRepository.c(omadacId, siteTemplateIdStr);
            boolean bindOsg = osgPOOptional.isPresent() && (supportEcspV1 || !Objects.equals(EcspFirstVersionEnum.V1.getVersion(), osgPOOptional.map(DevicePO::getComponentInfo).map(ComponentInfoPO::getVersion).orElse(null)));
            List lanNetworkPOList = this.lanNetworkMaintMongoRepository.d(omadacId, siteTemplateIdStr);
            for (LanNetworkTemplatePO lanNetworkPO : lanNetworkPOList) {
                if (Objects.equals(lanNetworkPO.getPurpose(), "interface")) {
                    lanNetworkPO.setDeviceType(Integer.valueOf(1));
                    if (!osgPOOptional.isPresent() || !bindOsg) continue;
                    lanNetworkPO.setDeviceMac(((OsgTemplatePO)osgPOOptional.get()).getId());
                    continue;
                }
                if (Objects.equals(lanNetworkPO.getPurpose(), "vlan")) {
                    lanNetworkPO.setDeviceType(Integer.valueOf(0));
                    continue;
                }
                log.warn("unknown network purpose {} when handleLanNetworkDeviceTypeCompatible", (Object)lanNetworkPO.getPurpose());
            }
            this.lanNetworkMaintMongoRepository.a(new ArrayList(lanNetworkPOList), n.b);
        }
    }

    private void handlePinSettingAutoUnlockCard2Compatible(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgPOS = this.osgMaintMongoRepository.e(omadacId);
        if (CollectionUtils.isEmpty((Collection)osgPOS)) {
            return;
        }
        osgPOS.forEach(a::b);
        this.osgMaintMongoRepository.a((Collection)osgPOS);
    }
}

