/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.common.constant.G;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.DialupSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.LteWanSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51518TOV51520)
@b(a=e.V1000010018TOV1000010020)
public class WiredCompatibleCommandV51518TOV51520
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV51518TOV51520.class);
    private final a internetRepository = a.a();
    private final c osgRepository = c.a();
    private static final WiredCompatibleCommandV51518TOV51520 instance = new WiredCompatibleCommandV51518TOV51520();

    private WiredCompatibleCommandV51518TOV51520() {
    }

    public static WiredCompatibleCommandV51518TOV51520 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.15.18 to v5.15.20");
        try {
            this.handleSimCardCompatible(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.15.18 to v5.15.20 do db compatible error.", (Throwable)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleSimCardCompatible(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List internetPOS = this.internetRepository.a(omadacId);
        if (CollectionUtils.isEmpty((Collection)internetPOS)) {
            return;
        }
        Map osgMap = this.osgRepository.e(omadacId).stream().collect(Collectors.toMap(DevicePO::getSiteId, Function.identity()));
        for (InternetPO internetPO : internetPOS) {
            if (CollectionUtils.isEmpty((Collection)internetPO.getLteWanSettings())) {
                this.internetRepository.a(internetPO);
                continue;
            }
            if (osgMap.get(internetPO.getSiteId()) != null && Objects.equals(1, this.supportDualSim((OsgPO)osgMap.get(internetPO.getSiteId())))) {
                this.dualSimUpgrade(internetPO);
                continue;
            }
            this.singleSimUpgrade(internetPO);
        }
    }

    private Integer supportDualSim(OsgPO osgPO) {
        if (Objects.isNull(osgPO.getDevCap()) || Objects.isNull(osgPO.getDevCap().getSupportDualSimCard())) {
            return 0;
        }
        return osgPO.getDevCap().getSupportDualSimCard();
    }

    private void dualSimUpgrade(InternetPO internetPO) {
        for (LteWanSettingPO lteWanSettingPO : internetPO.getLteWanSettings()) {
            ArrayList<DialupSettingPO> dialupSettingPOS = new ArrayList<DialupSettingPO>(2);
            DialupSettingPO dialupSettingPO = lteWanSettingPO.getDialupSetting();
            if (!CollectionUtils.isEmpty((Collection)lteWanSettingPO.getDialUpSettings())) {
                if (dialupSettingPO != null) {
                    log.error("Upgrade Dual-SIM LTE error, omadacId {}, siteId {}, old data is {}, new data is {}.", new Object[]{internetPO.getOmadacId(), internetPO.getSiteId(), lteWanSettingPO.getDialupSetting(), lteWanSettingPO.getDialUpSettings()});
                }
                if (lteWanSettingPO.getSingleDialupSettingPO(G.b).isEmpty()) {
                    lteWanSettingPO.getDialUpSettings().add(this.buildDefaultDualDialupSettingPO());
                }
            } else {
                if (dialupSettingPO == null) {
                    log.error("Upgrade Dual-SIM LTE error because of no data, omadacId {}, siteId {}\u3002", (Object)internetPO.getOmadacId(), (Object)internetPO.getSiteId());
                    dialupSettingPO = this.buildDefaultDualDialupSettingPO();
                } else {
                    dialupSettingPO.setDataRoaming(lteWanSettingPO.getDataRoaming());
                    dialupSettingPO.setNetworkMode(lteWanSettingPO.getNetworkMode());
                    dialupSettingPO.setBandMode(lteWanSettingPO.getBandMode());
                    dialupSettingPO.setBands(lteWanSettingPO.getBands());
                    dialupSettingPO.setFailoverTimeout(G.d);
                }
                dialupSettingPOS.add(dialupSettingPO);
                dialupSettingPOS.add(this.buildDefaultDualDialupSettingPO());
                lteWanSettingPO.setDialUpSettings(dialupSettingPOS);
            }
            lteWanSettingPO.setSimPriority(G.a);
        }
        this.internetRepository.a(internetPO);
    }

    private void singleSimUpgrade(InternetPO internetPO) {
        for (LteWanSettingPO lteWanSettingPO : internetPO.getLteWanSettings()) {
            DialupSettingPO dialupSettingPO = lteWanSettingPO.getDialupSetting();
            if (!CollectionUtils.isEmpty((Collection)lteWanSettingPO.getDialUpSettings())) {
                if (dialupSettingPO == null) continue;
                log.error("Upgrade Single-SIM LTE error, omadacId {}, siteId {}, old data is {}, new data is {}.", new Object[]{internetPO.getOmadacId(), internetPO.getSiteId(), lteWanSettingPO.getDialupSetting(), lteWanSettingPO.getDialUpSettings()});
                this.internetRepository.a(internetPO);
                continue;
            }
            if (dialupSettingPO == null) {
                log.error("Upgrade Single-SIM LTE error because of no data, omadacId {}, siteId {}.", (Object)internetPO.getOmadacId(), (Object)internetPO.getSiteId());
                dialupSettingPO = this.buildDefaultSingleDialupSettingPO();
            } else {
                dialupSettingPO.setDataRoaming(lteWanSettingPO.getDataRoaming());
                dialupSettingPO.setNetworkMode(lteWanSettingPO.getNetworkMode());
                dialupSettingPO.setBandMode(lteWanSettingPO.getBandMode());
                dialupSettingPO.setBands(lteWanSettingPO.getBands());
            }
            lteWanSettingPO.setDialUpSettings(Collections.singletonList(dialupSettingPO));
        }
        this.internetRepository.a(internetPO);
    }

    private DialupSettingPO buildDefaultSingleDialupSettingPO() {
        DialupSettingPO dialupSettingPO = new DialupSettingPO();
        dialupSettingPO.setDataRoaming(Boolean.valueOf(false));
        dialupSettingPO.setNetworkMode(Integer.valueOf(2));
        dialupSettingPO.setBandMode(Integer.valueOf(0));
        dialupSettingPO.setNetSearchMode(Integer.valueOf(0));
        dialupSettingPO.setApnMode(Integer.valueOf(0));
        return dialupSettingPO;
    }

    private DialupSettingPO buildDefaultDualDialupSettingPO() {
        DialupSettingPO dialupSettingPO = this.buildDefaultSingleDialupSettingPO();
        dialupSettingPO.setFailoverTimeout(G.d);
        return dialupSettingPO;
    }
}

