/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.SitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.BaseLanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.LanProfilePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51506TOV51508)
public class WiredCompatibleCommandV51506TOV51508
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV51506TOV51508.class);
    public static final Integer ES_ENABLE_ALL_PROFILE_TAG_VLAN_LIMIT = 31;
    public static final Integer BRIDGE_VLAN = 1;
    public static final String PURPOSE_INTERFACE = "interface";
    private final e lanProfileMaintMongoRepository = e.a();
    private final g siteMaintMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private static final WiredCompatibleCommandV51506TOV51508 instance = new WiredCompatibleCommandV51506TOV51508();

    private WiredCompatibleCommandV51506TOV51508() {
    }

    public static WiredCompatibleCommandV51506TOV51508 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.15.06 to v5.15.08");
        try {
            this.handleProfile(new c(omadacId));
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.15.06 to v5.15.08 do db compatible error.", (Throwable)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleProfile(c omadacId) {
        List sitePOS = this.siteMaintMongoRepository.a(omadacId);
        if (CollectionUtils.isEmpty((Collection)sitePOS)) {
            return;
        }
        for (SitePO sitePO : sitePOS) {
            com.tplink.smb.omada.maintenance.common.b.a.a.d siteId = new com.tplink.smb.omada.maintenance.common.b.a.a.d(sitePO.getId());
            LanProfilePO lanProfilePO = this.lanProfileMaintMongoRepository.a(omadacId.a(), siteId.a(), "All").orElse(null);
            if (lanProfilePO == null || CollectionUtils.isEmpty((Collection)lanProfilePO.getTagNetworkIds())) continue;
            List taggedNetworkIds = lanProfilePO.getTagNetworkIds();
            List lanNetworkPOS = this.lanNetworkMaintMongoRepository.a(omadacId, siteId, taggedNetworkIds);
            if (CollectionUtils.isEmpty((Collection)lanNetworkPOS)) {
                log.warn("Lan Profile compatible to 5.15.08 failed: Invalid Lan Network Ids. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
                continue;
            }
            lanNetworkPOS.sort(Comparator.comparing(BaseLanNetworkPO::getId, String::compareTo));
            ArrayList<String> esEnableTaggedNetworks = new ArrayList<String>();
            HashMap esEnableBridgeVlanMap = new HashMap();
            Integer needAddedNetworkNum = ES_ENABLE_ALL_PROFILE_TAG_VLAN_LIMIT;
            for (LanNetworkPO lanNetworkPO : lanNetworkPOS) {
                if (needAddedNetworkNum <= 0) {
                    Integer networkVlanNum = lanNetworkPO.getVlanList() != null ? lanNetworkPO.getVlanList().size() : 1;
                    needAddedNetworkNum = needAddedNetworkNum - networkVlanNum;
                    continue;
                }
                if (Objects.equals(lanNetworkPO.getVlanType(), BRIDGE_VLAN) && T.a((String)lanNetworkPO.getPurpose(), (String)PURPOSE_INTERFACE)) {
                    List bridgeVlans = lanNetworkPO.getVlanList().stream().sorted(Comparator.comparing(Function.identity(), Integer::compareTo)).collect(Collectors.toList());
                    esEnableTaggedNetworks.add(lanNetworkPO.getId());
                    if (needAddedNetworkNum <= bridgeVlans.size()) {
                        esEnableBridgeVlanMap.put(lanNetworkPO.getId(), new HashSet(bridgeVlans.subList(0, needAddedNetworkNum)));
                    } else {
                        esEnableBridgeVlanMap.put(lanNetworkPO.getId(), new HashSet(bridgeVlans));
                    }
                    needAddedNetworkNum = needAddedNetworkNum - bridgeVlans.size();
                    continue;
                }
                esEnableTaggedNetworks.add(lanNetworkPO.getId());
                needAddedNetworkNum = needAddedNetworkNum - 1;
            }
            lanProfilePO.setEsEnable(Boolean.valueOf(needAddedNetworkNum < 0));
            lanProfilePO.setEsEnableTaggedNetworkIds(esEnableTaggedNetworks);
            lanProfilePO.setEsEnableTagBridgeVlanMap(esEnableBridgeVlanMap);
            this.lanProfileMaintMongoRepository.a(lanProfilePO);
        }
    }
}

