/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.DslWanSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.Ipv4DhcpPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanLoadBalancePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanPortIpv4SettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanPortIpv6SettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanPortMacSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgPortPreInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.WanDefaultMacPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51434TOV51506)
public class WiredCompatibleCommandV51434TOV51506
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV51434TOV51506.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final c osgMaintMongoRepository = c.a();
    private final a internetMaintMongoRepository = a.a();
    private static final WiredCompatibleCommandV51434TOV51506 instance = new WiredCompatibleCommandV51434TOV51506();
    private final String USB_NAME_START_STRING = "U";
    private final String LTE_NAME_START_STRING = "LTE";
    private final String DSL_WAN_START_STRING = "DSL";
    private final int DR3650V_V1_DSL_PORT_ID = 6;
    private final String DSL_WAN_PORT_NAME = "DSL WAN";
    private final int DEFAULT_VLAN_ID = 0;
    private final int DEFAULT_VLAN_PRIORITY = 0;
    private final String DEFAULT_UNICAST = "off";
    private final int DEFAULT_MTU = 1500;
    private final String DEFAULT_IPV4_PROTO = "dhcp";
    private final boolean DEFAULT_QOS_TAG_EBABLE = false;
    private final String LOAD_BALANCE_WITH_USB_WAN = "1,10,10";
    private final String LOAD_BALANCE_WITHOUT_USB_WAN = "1,1";

    private WiredCompatibleCommandV51434TOV51506() {
    }

    public static WiredCompatibleCommandV51434TOV51506 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.14.32 to v5.15.6");
        try {
            this.handleOsgModel(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.14.32 to v5.15.6 do db compatible error.", (Throwable)e2);
        }
        try {
            this.handleInternet(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        }
        catch (Exception e3) {
            log.warn("WiredCompatible v5.14.30 to v5.15.10 do db compatible error.", (Throwable)e3);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleInternet(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgPOS = this.osgMaintMongoRepository.e(omadacId);
        if (CollectionUtils.isEmpty((Collection)osgPOS)) {
            return;
        }
        List dr3650vV1List = osgPOS.stream().filter(po -> b.a(po.getCompoundModel()) == b.A).collect(Collectors.toList());
        List dr3650vV1SiteIdList = dr3650vV1List.stream().map(DevicePO::getSiteId).collect(Collectors.toList());
        Map<String, OsgModelConfigPO> siteIdOsgModelConfigMap = this.osgModelConfigMainMongoRepository.a(omadacId, dr3650vV1SiteIdList).stream().collect(Collectors.toMap(OsgModelConfigPO::getSiteId, osgModelConfigPO -> osgModelConfigPO));
        List<InternetPO> internetPOList = this.internetMaintMongoRepository.a(omadacId).stream().filter(internetPO -> dr3650vV1SiteIdList.contains(internetPO.getSiteId())).collect(Collectors.toList());
        internetPOList.forEach(internetPO -> {
            OsgModelConfigPO osgModelConfigPO = (OsgModelConfigPO)siteIdOsgModelConfigMap.get(internetPO.getSiteId());
            Optional<OsgPO> optionalCorrespondingOsgPO = dr3650vV1List.stream().filter(osgPO -> Objects.equals(osgPO.getSiteId(), internetPO.getSiteId())).findFirst();
            if (!optionalCorrespondingOsgPO.isPresent() || osgModelConfigPO == null) {
                log.warn("Failed to update Internet from 5.14.32 to 5.15.06, lack of corresponding OsgPO or OsgModelConfigPO. omadacId: {}, siteId: {}", (Object)omadacId.a(), (Object)internetPO.getSiteId());
                return;
            }
            Optional<WanDefaultMacPO> dslWanDefaultMacPO = optionalCorrespondingOsgPO.get().getWanDefaultMacs().stream().filter(wanDefaultMacPO -> Objects.equals(wanDefaultMacPO.getPortId(), 6)).findFirst();
            Map<Integer, String> portIdPortUuidMap = osgModelConfigPO.getPortUuidPortIdMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            String dslWanPortUuid = portIdPortUuidMap.get(6);
            List wanPortUuids = internetPO.getWanPortUuids();
            int initialWanPortNum = wanPortUuids.size();
            if (initialWanPortNum == 1) {
                wanPortUuids.add(0, dslWanPortUuid);
                WanLoadBalancePO wanLoadBalancePO = new WanLoadBalancePO();
                wanLoadBalancePO.setWeight("1,1");
                wanLoadBalancePO.setAppOptRouting(Boolean.valueOf(true));
                wanLoadBalancePO.setLinkBackup(Boolean.valueOf(false));
                internetPO.setWanLoadBalance(wanLoadBalancePO);
            } else {
                wanPortUuids.add(1, dslWanPortUuid);
                WanLoadBalancePO newWanLoadBalancePO = new WanLoadBalancePO();
                newWanLoadBalancePO.setWeight("1,10,10");
                newWanLoadBalancePO.setAppOptRouting(Boolean.valueOf(true));
                newWanLoadBalancePO.setLinkBackup(Boolean.valueOf(false));
                internetPO.setWanLoadBalance(newWanLoadBalancePO);
                WanLoadBalancePO oldWanLoadBalance = internetPO.getWanLoadBalance();
                if (oldWanLoadBalance == null) {
                    internetPO.setWanLoadBalance(newWanLoadBalancePO);
                } else {
                    oldWanLoadBalance.setWeight("1,10,10");
                }
            }
            internetPO.setDslWanSettings(new ArrayList<DslWanSettingPO>(Collections.singleton(this.createDefaultDslWanSetting(dslWanPortUuid))));
            internetPO.getWanPortIpv4Settings().add(this.createWanPortIpv4Setting(dslWanPortUuid, dslWanDefaultMacPO.map(WanDefaultMacPO::getDefMac).orElse(null)));
            WanPortIpv6SettingPO dslWanPortIpv6SettingPO = new WanPortIpv6SettingPO();
            dslWanPortIpv6SettingPO.setPortUuid(dslWanPortUuid);
            dslWanPortIpv6SettingPO.setEnable(Integer.valueOf(0));
            internetPO.getWanPortIpv6Settings().add(dslWanPortIpv6SettingPO);
            this.internetMaintMongoRepository.a(internetPO);
        });
    }

    private DslWanSettingPO createDefaultDslWanSetting(String portUuid) {
        DslWanSettingPO dslWanSettingPO = new DslWanSettingPO();
        dslWanSettingPO.setPortUuid(portUuid);
        dslWanSettingPO.setLocation(com.tplink.smb.omada.common.region.b.dv.a());
        dslWanSettingPO.setModulation(Integer.valueOf(0));
        dslWanSettingPO.setIsp(Integer.valueOf(0));
        return dslWanSettingPO;
    }

    private WanPortIpv4SettingPO createWanPortIpv4Setting(String portUuid, String defaultMac) {
        WanPortIpv4SettingPO wanPortIpv4SettingPO = new WanPortIpv4SettingPO();
        wanPortIpv4SettingPO.setPortUuid(portUuid);
        wanPortIpv4SettingPO.setVlanId(Integer.valueOf(0));
        wanPortIpv4SettingPO.setQosTagEnable(Boolean.valueOf(false));
        wanPortIpv4SettingPO.setQosTag(Integer.valueOf(0));
        wanPortIpv4SettingPO.setProto("dhcp");
        Ipv4DhcpPO ipv4DhcpPO = new Ipv4DhcpPO();
        ipv4DhcpPO.setUnicast("off");
        ipv4DhcpPO.setMtu(Integer.valueOf(1500));
        wanPortIpv4SettingPO.setIpv4Dchp(ipv4DhcpPO);
        WanPortMacSettingPO wanPortMacSettingPO = new WanPortMacSettingPO();
        wanPortMacSettingPO.setMethod("recover");
        wanPortMacSettingPO.setMac(defaultMac);
        wanPortIpv4SettingPO.setWanPortMacSetting(wanPortMacSettingPO);
        return wanPortIpv4SettingPO;
    }

    private void handleOsgModel(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List er703WP4GOutdoorList;
        List er703WP4GSites;
        List er703WP4GConfigPOList;
        List osgPOS = this.osgMaintMongoRepository.e(omadacId);
        if (CollectionUtils.isEmpty((Collection)osgPOS)) {
            return;
        }
        List dr3650vV1List = osgPOS.stream().filter(po -> b.a(po.getCompoundModel()) == b.A).collect(Collectors.toList());
        List dr3650vV1SiteIdList = dr3650vV1List.stream().map(DevicePO::getSiteId).collect(Collectors.toList());
        List dr3650vV1ModelConfigPOList = this.osgModelConfigMainMongoRepository.a(omadacId, dr3650vV1SiteIdList);
        if (!CollectionUtils.isEmpty((Collection)dr3650vV1ModelConfigPOList)) {
            for (OsgModelConfigPO po2 : dr3650vV1ModelConfigPOList) {
                this.handleUniversalToDR3650vV1(po2);
            }
            this.osgModelConfigMainMongoRepository.a(dr3650vV1ModelConfigPOList);
        }
        if (!CollectionUtils.isEmpty((Collection)(er703WP4GConfigPOList = this.osgModelConfigMainMongoRepository.a(omadacId, er703WP4GSites = (er703WP4GOutdoorList = osgPOS.stream().filter(po -> b.a(po.getCompoundModel()) == b.z).collect(Collectors.toList())).stream().map(DevicePO::getSiteId).collect(Collectors.toList()))))) {
            for (OsgModelConfigPO po3 : er703WP4GConfigPOList) {
                this.handleUniversalToER703WP4G(po3);
            }
            this.osgModelConfigMainMongoRepository.a(er703WP4GConfigPOList);
        }
    }

    private void handleUniversalToDR3650vV1(OsgModelConfigPO osgModelConfigPO) {
        osgModelConfigPO.setOsgModel(Integer.valueOf(b.A.b()));
        List osgPortPreInfoPOS = osgModelConfigPO.getOsgPortInfos();
        Map portIdOsgPortPreInfoPOMap = osgPortPreInfoPOS.stream().collect(Collectors.toMap(OsgPortPreInfoPO::getPortId, Function.identity()));
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(1), "WAN/LAN1", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(2), "LAN2", o.f, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(3), "LAN3", o.f, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(4), "LAN4", o.f, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(5), "LAN5", o.f, true, 1000L);
        if (portIdOsgPortPreInfoPOMap.get(6) == null) {
            osgPortPreInfoPOS.add(this.getDslPortPreInfoPO(osgModelConfigPO));
        } else {
            this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(6), "DSL WAN", o.j, true, null);
        }
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(7), "USB Modem", o.h, false, null);
        this.sortPortByName(osgPortPreInfoPOS);
    }

    private OsgPortPreInfoPO getDslPortPreInfoPO(OsgModelConfigPO osgModelConfigPO) {
        OsgPortPreInfoPO dslPortPreInfoPO = new OsgPortPreInfoPO();
        Map<Integer, String> portIdPortUuidMap = osgModelConfigPO.getPortUuidPortIdMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        String dslPortUuid = portIdPortUuidMap.getOrDefault(6, "6_" + UUID.randomUUID());
        dslPortPreInfoPO.setPortId(Integer.valueOf(6));
        dslPortPreInfoPO.setPortUuid(dslPortUuid);
        dslPortPreInfoPO.setName("DSL WAN");
        dslPortPreInfoPO.setType(o.j);
        dslPortPreInfoPO.setMode(Integer.valueOf(0));
        dslPortPreInfoPO.setSupportIptv(Boolean.valueOf(true));
        dslPortPreInfoPO.setMaxBandwidth(null);
        return dslPortPreInfoPO;
    }

    private void handleUniversalToER703WP4G(OsgModelConfigPO osgModelConfigPO) {
        osgModelConfigPO.setOsgModel(Integer.valueOf(b.z.b()));
        List osgPortPreInfoPOS = osgModelConfigPO.getOsgPortInfos();
        Map portIdOsgPortPreInfoPOMap = osgPortPreInfoPOS.stream().collect(Collectors.toMap(OsgPortPreInfoPO::getPortId, Function.identity()));
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(1), "WAN/LAN1", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(2), "WAN/LAN2", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(3), "WAN/LAN3", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(4), "LTE", o.h, true, 1000L);
        this.sortPortByName(osgPortPreInfoPOS);
    }

    private void updatePortInfo(OsgPortPreInfoPO port, String name, Integer type, Boolean supportIptv, Long MaxBandwidth) {
        port.setType(type);
        port.setName(name);
        port.setSupportIptv(supportIptv);
        port.setMaxBandwidth(MaxBandwidth);
    }

    private void sortPortByName(List<OsgPortPreInfoPO> ports) {
        ports.sort((o1, o2) -> {
            if (o1.getName().startsWith("LTE") && o2.getName().startsWith("LTE")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("LTE")) {
                return -1;
            }
            if (o2.getName().startsWith("LTE")) {
                return 1;
            }
            if (o1.getName().startsWith("U") && o2.getName().startsWith("U")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("U")) {
                return -1;
            }
            if (o2.getName().startsWith("U")) {
                return 1;
            }
            if (o1.getName().startsWith("DSL")) {
                return -1;
            }
            if (o2.getName().startsWith("DSL")) {
                return 1;
            }
            return o1.getPortId() - o2.getPortId();
        });
    }
}

