/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgPortPreInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51430TOV51432)
public class WiredCompatibleCommandV51430TOV51432
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV51430TOV51432.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final c osgMaintMongoRepository = c.a();
    private final String USB_NAME_START_STRING = "U";
    private final String LTE_NAME_START_STRING = "LTE";
    private final String DSL_WAN_START_STRING = "DSL";
    private static final WiredCompatibleCommandV51430TOV51432 instance = new WiredCompatibleCommandV51430TOV51432();

    private WiredCompatibleCommandV51430TOV51432() {
    }

    public static WiredCompatibleCommandV51430TOV51432 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.14.30 to v5.14.32");
        try {
            this.handleOsgModel(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.14.30 to v5.14.32 do db compatible error.", (Throwable)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleOsgModel(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgPOS = this.osgMaintMongoRepository.e(omadacId);
        if (com.tplink.smb.ecsp.common.util.CollectionUtils.isEmpty((Collection)osgPOS)) {
            return;
        }
        List er703WP4GOutdoorList = osgPOS.stream().filter(po -> b.a(po.getCompoundModel()) == b.z).collect(Collectors.toList());
        List er703WP4GSites = er703WP4GOutdoorList.stream().map(DevicePO::getSiteId).collect(Collectors.toList());
        List er703WP4GConfigPOList = this.osgModelConfigMainMongoRepository.a(omadacId, er703WP4GSites);
        if (!CollectionUtils.isEmpty((Collection)er703WP4GConfigPOList)) {
            for (OsgModelConfigPO po2 : er703WP4GConfigPOList) {
                this.handleUniversalToER703WP4G(po2);
            }
            this.osgModelConfigMainMongoRepository.a(er703WP4GConfigPOList);
        }
    }

    private void handleUniversalToER703WP4G(OsgModelConfigPO osgModelConfigPO) {
        osgModelConfigPO.setOsgModel(Integer.valueOf(b.z.b()));
        List osgPortPreInfoPOS = osgModelConfigPO.getOsgPortInfos();
        Map portIdOsgPortPreInfoPOMap = osgPortPreInfoPOS.stream().collect(Collectors.toMap(OsgPortPreInfoPO::getPortId, Function.identity()));
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(1), "WAN/LAN1", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(2), "WAN/LAN2", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(3), "WAN/LAN3", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)portIdOsgPortPreInfoPOMap.get(4), "LTE", o.h, true, 1000L);
        this.sortPortByName(osgPortPreInfoPOS);
    }

    private void updatePortInfo(OsgPortPreInfoPO port, String name, Integer type, Boolean supportIptv, Long MaxBandwidth) {
        port.setType(type);
        port.setName(name);
        port.setSupportIptv(supportIptv);
        port.setMaxBandwidth(MaxBandwidth);
    }

    private void sortPortByName(List<OsgPortPreInfoPO> ports) {
        ports.sort((o1, o2) -> {
            if (o1.getName().startsWith("LTE") && o2.getName().startsWith("LTE")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("LTE")) {
                return -1;
            }
            if (o2.getName().startsWith("LTE")) {
                return 1;
            }
            if (o1.getName().startsWith("U") && o2.getName().startsWith("U")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("U")) {
                return -1;
            }
            if (o2.getName().startsWith("U")) {
                return 1;
            }
            if (o1.getName().startsWith("DSL")) {
                return -1;
            }
            if (o2.getName().startsWith("DSL")) {
                return 1;
            }
            return o1.getPortId() - o2.getPortId();
        });
    }
}

