/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.a;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgPortPreInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51400TOV51401)
@com.tplink.smb.omada.maintenance.compatible.a.b(a=e.V1000009020TOV1000009030)
public class WiredCompatibleCommandV5140030TOV51402
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV5140030TOV51402.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final c osgMaintMongoRepository = c.a();
    private final String USB_NAME_START_STRING = "U";
    private final String LTE_NAME_START_STRING = "LTE";
    private static final WiredCompatibleCommandV5140030TOV51402 instance = new WiredCompatibleCommandV5140030TOV51402();

    private WiredCompatibleCommandV5140030TOV51402() {
    }

    public static WiredCompatibleCommandV5140030TOV51402 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.14.0 to v5.14.2");
        try {
            this.handle706W4GV12OsgModel(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.14.0 to v5.14.2 do db compatible error.", (Throwable)e2);
        }
    }

    private void handle706W4GV12OsgModel(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgPOS = this.osgMaintMongoRepository.b(omadacId, b.m.c());
        if (CollectionUtils.isEmpty((Collection)osgPOS)) {
            return;
        }
        List sites = osgPOS.stream().map(DevicePO::getSiteId).collect(Collectors.toList());
        List osgModelConfigPOS = this.osgModelConfigMainMongoRepository.a(omadacId, sites);
        if (CollectionUtils.isEmpty((Collection)osgModelConfigPOS)) {
            return;
        }
        for (OsgModelConfigPO osgModelConfigPO : osgModelConfigPOS) {
            this.handleUniversalTo706W4GV12(osgModelConfigPO);
        }
        osgPOS.forEach(a::a);
        this.osgMaintMongoRepository.a((Collection)osgPOS);
        this.osgModelConfigMainMongoRepository.a(osgModelConfigPOS);
    }

    private void handleUniversalTo706W4GV12(OsgModelConfigPO osgModelConfigPO) {
        osgModelConfigPO.setOsgModel(Integer.valueOf(b.m.b()));
        List osgPortPreInfoPOS = osgModelConfigPO.getOsgPortInfos();
        osgPortPreInfoPOS.sort(Comparator.comparing(OsgPortPreInfoPO::getPortId));
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(0), "SFP WAN/LAN1", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(1), "WAN2", o.d, false, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(2), "WAN/LAN3", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(3), "WAN/LAN4", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(4), "WAN/LAN5", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(5), "WAN/LAN6", o.e, true, 1000L);
        OsgPortPreInfoPO ltePort = new OsgPortPreInfoPO();
        ltePort.setMode(o.m);
        ltePort.setType(o.i);
        ltePort.setName("LTE");
        ltePort.setPortId(Integer.valueOf(7));
        ltePort.setPortUuid(this.parseByPortUuidPortIdMap(osgModelConfigPO.getPortUuidPortIdMap()).get(7));
        ltePort.setSupportIptv(Boolean.valueOf(false));
        ltePort.setMaxBandwidth(Long.valueOf(1000L));
        osgModelConfigPO.getOsgPortInfos().add(ltePort);
        this.sortPortByName(osgPortPreInfoPOS);
    }

    private void updatePortInfo(OsgPortPreInfoPO port, String name, Integer type, Boolean supportIptv, Long MaxBandwidth) {
        port.setType(type);
        port.setName(name);
        port.setSupportIptv(supportIptv);
        port.setMaxBandwidth(MaxBandwidth);
    }

    private Map<Integer, String> parseByPortUuidPortIdMap(Map<String, Integer> portUuidPortIdMap) {
        if (CollectionUtils.isEmpty(portUuidPortIdMap)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, String> portIdPortUuidMap = new HashMap<Integer, String>(2);
        for (Map.Entry<String, Integer> e2 : portUuidPortIdMap.entrySet()) {
            portIdPortUuidMap.put(e2.getValue(), e2.getKey());
        }
        return portIdPortUuidMap;
    }

    private void sortPortByName(List<OsgPortPreInfoPO> ports) {
        ports.sort((o1, o2) -> {
            if (o1.getName().startsWith("LTE") && o2.getName().startsWith("LTE")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("LTE")) {
                return -1;
            }
            if (o2.getName().startsWith("LTE")) {
                return 1;
            }
            if (o1.getName().startsWith("U") && o2.getName().startsWith("U")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("U")) {
                return -1;
            }
            if (o2.getName().startsWith("U")) {
                return 1;
            }
            return o1.getPortId() - o2.getPortId();
        });
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }
}

