/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.dhcpreservation.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgPortPreInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import com.tplink.smb.omada.manager.port.mongo.device.osw.j;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51330TOV51400)
@com.tplink.smb.omada.maintenance.compatible.a.b(a=e.V1000008001TOV1000009000)
public class WiredCompatibleCommandV51330TOV51400
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV51330TOV51400.class);
    private static final String OLD_DEFAULT_LAN_NETWORK_NAME = "LAN";
    private static final String NEW_DEFAULT_LAN_NETWORK_NAME = "Default";
    private final c osgMaintMongoRepository = c.a();
    private final g osgModelConfigMainMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final j oswNetworkMaintMongoRepository = j.a();
    private final a dhcpReservationMaintMongoRepository = a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.a.c dpiRestrictionsMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.a.c.a();
    private final String USB_NAME_START_STRING = "U";
    private static final WiredCompatibleCommandV51330TOV51400 instance = new WiredCompatibleCommandV51330TOV51400();

    private WiredCompatibleCommandV51330TOV51400() {
    }

    public static WiredCompatibleCommandV51330TOV51400 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.13.30 to v5.14.0.");
        try {
            this.handleLanNetworkCompatible(omadacId);
            this.handleER7412OsgModel(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
            this.handleLanNameCompatible(omadacId);
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.13.30 to v5.14.0 do db compatible error.", (Throwable)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleER7412OsgModel(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgPOS = this.osgMaintMongoRepository.b(omadacId, b.j.c());
        if (CollectionUtils.isEmpty((Collection)osgPOS)) {
            return;
        }
        List sites = osgPOS.stream().map(DevicePO::getSiteId).collect(Collectors.toList());
        List osgModelConfigPOS = this.osgModelConfigMainMongoRepository.a(omadacId, sites);
        if (CollectionUtils.isEmpty((Collection)osgModelConfigPOS)) {
            return;
        }
        for (OsgModelConfigPO osgModelConfigPO : osgModelConfigPOS) {
            this.handleUniversalToER7412(osgModelConfigPO);
        }
        this.osgModelConfigMainMongoRepository.a(osgModelConfigPOS);
    }

    private void handleUniversalToER7412(OsgModelConfigPO osgModelConfigPO) {
        osgModelConfigPO.setOsgModel(Integer.valueOf(b.j.b()));
        List osgPortPreInfoPOS = osgModelConfigPO.getOsgPortInfos();
        osgPortPreInfoPOS.sort(Comparator.comparing(OsgPortPreInfoPO::getPortId));
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(0), "WAN/LAN1", o.e, true, 2500L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(1), "WAN/LAN2", o.e, true, 2500L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(2), "WAN/LAN3", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(3), "WAN/LAN4", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(4), "WAN/LAN5", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(5), "WAN/LAN6", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(6), "WAN/LAN7", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(7), "WAN/LAN8", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(8), "WAN/LAN9", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(9), "WAN/LAN10", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(10), "SFP WAN/LAN11", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(11), "SFP WAN/LAN12", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(12), "USB Modem", o.h, false, 1000L);
        this.sortPortByUsb(osgPortPreInfoPOS);
    }

    private void updatePortInfo(OsgPortPreInfoPO port, String name, Integer type, Boolean supportIptv, Long MaxBandwidth) {
        port.setType(type);
        port.setName(name);
        port.setSupportIptv(supportIptv);
        port.setMaxBandwidth(MaxBandwidth);
    }

    private void sortPortByUsb(List<OsgPortPreInfoPO> ports) {
        ports.sort((o1, o2) -> {
            if (o1.getName().startsWith("U") && o2.getName().startsWith("U")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("U")) {
                return -1;
            }
            if (o2.getName().startsWith("U")) {
                return 1;
            }
            return o1.getPortId() - o2.getPortId();
        });
    }

    private void handleLanNetworkCompatible(String omadacId) {
        List primaryLanNetworks = this.lanNetworkMaintMongoRepository.b(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        if (CollectionUtils.isEmpty((Collection)primaryLanNetworks)) {
            return;
        }
        ArrayList needUpdateLanNetworks = new ArrayList();
        primaryLanNetworks.forEach(lanNetworkPO -> {
            if (T.a((String)lanNetworkPO.getName(), (String)OLD_DEFAULT_LAN_NETWORK_NAME)) {
                lanNetworkPO.setName(NEW_DEFAULT_LAN_NETWORK_NAME);
                needUpdateLanNetworks.add(lanNetworkPO);
            }
        });
        this.lanNetworkMaintMongoRepository.a(needUpdateLanNetworks);
    }

    private void handleLanNameCompatible(String omadacId) {
        List primaryLanNetworks = this.lanNetworkMaintMongoRepository.b(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        if (CollectionUtils.isEmpty((Collection)primaryLanNetworks)) {
            return;
        }
        ArrayList oswNetworkPOListsToSave = new ArrayList();
        ArrayList dhcpReservationPOListToSave = new ArrayList();
        ArrayList dpiRestrictionPOList = new ArrayList();
        primaryLanNetworks.forEach(primaryLanNetworkPO -> {
            this.oswNetworkMaintMongoRepository.a(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(primaryLanNetworkPO.getSiteId()), primaryLanNetworkPO.getVlan()).forEach(oswNetworkPO -> {
                if (!Objects.equals(oswNetworkPO.getName(), primaryLanNetworkPO.getName())) {
                    log.info("update oswNetwork:{} to new name:{}", (Object)oswNetworkPO.getName(), (Object)primaryLanNetworkPO.getName());
                    oswNetworkPO.setName(primaryLanNetworkPO.getName());
                    oswNetworkPOListsToSave.add(oswNetworkPO);
                }
            });
            this.dhcpReservationMaintMongoRepository.a(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(primaryLanNetworkPO.getSiteId()), primaryLanNetworkPO.getId()).forEach(dhcpReservationPO -> {
                if (!Objects.equals(dhcpReservationPO.getLanNetworkName(), primaryLanNetworkPO.getName())) {
                    log.info("update dhcpReservation netName:{} to new name:{}", (Object)dhcpReservationPO.getLanNetworkName(), (Object)primaryLanNetworkPO.getName());
                    dhcpReservationPO.setLanNetworkName(primaryLanNetworkPO.getName());
                    dhcpReservationPOListToSave.add(dhcpReservationPO);
                }
            });
            this.dpiRestrictionsMaintMongoRepository.a(omadacId, primaryLanNetworkPO.getSiteId(), primaryLanNetworkPO.getId()).forEach(dpiRestrictionPO -> {
                if (!Objects.equals(dpiRestrictionPO.getNetwork(), primaryLanNetworkPO.getName())) {
                    log.info("update dpi netName:{} to new name:{}", (Object)dpiRestrictionPO.getNetwork(), (Object)primaryLanNetworkPO.getName());
                    dpiRestrictionPO.setNetwork(primaryLanNetworkPO.getName());
                    dpiRestrictionPOList.add(dpiRestrictionPO);
                }
            });
        });
        if (!CollectionUtils.isEmpty(oswNetworkPOListsToSave)) {
            this.oswNetworkMaintMongoRepository.a(oswNetworkPOListsToSave);
        }
        if (!CollectionUtils.isEmpty(dhcpReservationPOListToSave)) {
            this.dhcpReservationMaintMongoRepository.a(dhcpReservationPOListToSave);
        }
        if (!CollectionUtils.isEmpty(dpiRestrictionPOList)) {
            this.dpiRestrictionsMaintMongoRepository.a(dpiRestrictionPOList);
        }
    }
}

