/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.a;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanLoadBalancePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgPortPreInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51200TOV51300)
public class WiredCompatibleCommandV51200TOV51300
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV51200TOV51300.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final c osgMaintMongoRepository = c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a internetMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a.a();
    private final String USB_NAME_START_STRING = "U";
    private static final WiredCompatibleCommandV51200TOV51300 instance = new WiredCompatibleCommandV51200TOV51300();

    private WiredCompatibleCommandV51200TOV51300() {
    }

    public static WiredCompatibleCommandV51200TOV51300 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.12 to v5.13.");
        try {
            this.handle605WOsgModel(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
            this.hanldeLanNetworkCompatible(omadacId);
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.12 to v5.13 do db compatible error.", (Throwable)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleWanPortSetting(InternetPO internetPO) {
        List wanPortIpv4SettingPOS = Optional.ofNullable(internetPO.getWanPortIpv4Settings()).orElse(new ArrayList());
        List wanPortIpv6SettingPOS = Optional.ofNullable(internetPO.getWanPortIpv6Settings()).orElse(new ArrayList());
        Optional modelConfigPO = this.osgModelConfigMainMongoRepository.a(new com.tplink.smb.omada.maintenance.common.b.a.a.c(internetPO.getOmadacId()), new com.tplink.smb.omada.maintenance.common.b.a.a.d(internetPO.getSiteId()));
        modelConfigPO.ifPresent(osgModelConfigPO -> {
            AtomicBoolean needUpdateLoadBalance = new AtomicBoolean(false);
            osgModelConfigPO.getOsgPortInfos().forEach(osgPortPreInfoPO -> {
                if (this.isWanOrSfpWan(osgPortPreInfoPO.getType()) && !internetPO.getWanPortUuids().contains(osgPortPreInfoPO.getPortUuid())) {
                    internetPO.getWanPortUuids().add(osgPortPreInfoPO.getPortUuid());
                    wanPortIpv4SettingPOS.add(a.b(osgPortPreInfoPO.getPortUuid()));
                    internetPO.setWanPortIpv4Settings(wanPortIpv4SettingPOS);
                    wanPortIpv6SettingPOS.add(a.a(osgPortPreInfoPO.getPortUuid()));
                    internetPO.setWanPortIpv6Settings(wanPortIpv6SettingPOS);
                    needUpdateLoadBalance.set(true);
                }
            });
            if (Boolean.TRUE.equals(needUpdateLoadBalance.get())) {
                WanLoadBalancePO oldWanLoadBalance = internetPO.getWanLoadBalance();
                HashMap<String, Integer> osgPortTypeMap = new HashMap<String, Integer>();
                ((OsgModelConfigPO)modelConfigPO.get()).getOsgPortInfos().forEach(osgPortPreInfoPO -> osgPortTypeMap.put(osgPortPreInfoPO.getPortUuid(), osgPortPreInfoPO.getType()));
                internetPO.setWanLoadBalance(a.a(oldWanLoadBalance, (List<String>)internetPO.getWanPortUuids(), osgPortTypeMap));
            }
        });
        this.internetMaintMongoRepository.a(internetPO);
    }

    private boolean isWanOrSfpWan(int type) {
        return type == o.g || type == o.d;
    }

    private void handle605WOsgModel(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgPOS = this.osgMaintMongoRepository.b(omadacId, com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b.c.c());
        if (CollectionUtils.isEmpty((Collection)osgPOS)) {
            return;
        }
        List sites = osgPOS.stream().map(DevicePO::getSiteId).collect(Collectors.toList());
        List osgModelConfigPOS = this.osgModelConfigMainMongoRepository.a(omadacId, sites);
        if (CollectionUtils.isEmpty((Collection)osgModelConfigPOS)) {
            return;
        }
        for (OsgModelConfigPO osgModelConfigPO : osgModelConfigPOS) {
            this.handleUniversalTo605W(osgModelConfigPO);
        }
        this.osgModelConfigMainMongoRepository.a(osgModelConfigPOS);
    }

    private void handleUniversalTo605W(OsgModelConfigPO osgModelConfigPO) {
        osgModelConfigPO.setOsgModel(Integer.valueOf(com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b.c.b()));
        List osgPortPreInfoPOS = osgModelConfigPO.getOsgPortInfos();
        osgPortPreInfoPOS.sort(Comparator.comparing(OsgPortPreInfoPO::getPortId));
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(0), "WAN1", o.d, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(1), "WAN/LAN2", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(2), "WAN/LAN3", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(3), "LAN4", o.f, false, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(4), "LAN5", o.f, false, 1000L);
        this.sortPortByUsb(osgPortPreInfoPOS);
    }

    private void updatePortInfo(OsgPortPreInfoPO port, String name, Integer type, Boolean supportIptv, Long MaxBandwidth) {
        port.setType(type);
        port.setName(name);
        port.setSupportIptv(supportIptv);
        port.setMaxBandwidth(MaxBandwidth);
    }

    private void sortPortByUsb(List<OsgPortPreInfoPO> ports) {
        ports.sort((o1, o2) -> {
            if (o1.getName().startsWith("U") && o2.getName().startsWith("U")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("U")) {
                return -1;
            }
            if (o2.getName().startsWith("U")) {
                return 1;
            }
            return o1.getPortId() - o2.getPortId();
        });
    }

    private void hanldeLanNetworkCompatible(String omadacId) {
        List lanNetworks = this.lanNetworkMaintMongoRepository.c(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId), "interface");
        if (CollectionUtils.isEmpty((Collection)lanNetworks)) {
            return;
        }
        lanNetworks.forEach(po -> {
            if (po.getGatewaySubnet() != null) {
                po.setGatewaySubnetLong(b.a(po.getGatewaySubnet()));
                this.lanNetworkMaintMongoRepository.a(po);
            }
        });
    }
}

