/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.a;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanLoadBalancePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgPortPreInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51130TOV51200)
public class WiredCompatibleCommandV51100TOV51200
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV51100TOV51200.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final c osgMaintMongoRepository = c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a internetMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a.a();
    private static final WiredCompatibleCommandV51100TOV51200 instance = new WiredCompatibleCommandV51100TOV51200();
    private final String USB_NAME_START_STRING = "U";

    private WiredCompatibleCommandV51100TOV51200() {
    }

    public static WiredCompatibleCommandV51100TOV51200 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.11 to v5.12.");
        try {
            this.handle706WOsgModel(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.11 to v5.12 do db compatible error.", (Throwable)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handle706WOsgModel(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgPOS = this.osgMaintMongoRepository.b(omadacId, b.k.c());
        if (CollectionUtils.isEmpty((Collection)osgPOS)) {
            return;
        }
        List sites = osgPOS.stream().map(DevicePO::getSiteId).collect(Collectors.toList());
        List osgModelConfigPOS = this.osgModelConfigMainMongoRepository.a(omadacId, sites);
        if (CollectionUtils.isEmpty((Collection)osgModelConfigPOS)) {
            return;
        }
        for (OsgModelConfigPO osgModelConfigPO : osgModelConfigPOS) {
            this.handleUniversalTo706W(osgModelConfigPO);
        }
        this.osgModelConfigMainMongoRepository.a(osgModelConfigPOS);
    }

    private void handleUniversalTo706W(OsgModelConfigPO osgModelConfigPO) {
        osgModelConfigPO.setOsgModel(Integer.valueOf(b.k.b()));
        List osgPortPreInfoPOS = osgModelConfigPO.getOsgPortInfos();
        osgPortPreInfoPOS.sort(Comparator.comparing(OsgPortPreInfoPO::getPortId));
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(0), "SFP WAN/LAN1", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(1), "WAN2", o.d, false, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(2), "WAN/LAN3", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(3), "WAN/LAN4", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(4), "WAN/LAN5", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(5), "WAN/LAN6", o.e, true, 1000L);
        this.updatePortInfo((OsgPortPreInfoPO)osgPortPreInfoPOS.get(6), "USB Modem", o.h, false, 1000L);
        this.sortPortByUsb(osgPortPreInfoPOS);
    }

    private void updatePortInfo(OsgPortPreInfoPO port, String name, Integer type, Boolean supportIptv, Long MaxBandwidth) {
        port.setType(type);
        port.setName(name);
        port.setSupportIptv(supportIptv);
        port.setMaxBandwidth(MaxBandwidth);
    }

    private void sortPortByUsb(List<OsgPortPreInfoPO> ports) {
        ports.sort((o1, o2) -> {
            if (o1.getName().startsWith("U") && o2.getName().startsWith("U")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("U")) {
                return -1;
            }
            if (o2.getName().startsWith("U")) {
                return 1;
            }
            return o1.getPortId() - o2.getPortId();
        });
    }

    private void handleWanPortSetting(InternetPO internetPO) {
        List wanPortIpv4SettingPOS = Optional.ofNullable(internetPO.getWanPortIpv4Settings()).orElse(new ArrayList());
        List wanPortIpv6SettingPOS = Optional.ofNullable(internetPO.getWanPortIpv6Settings()).orElse(new ArrayList());
        Optional modelConfigPO = this.osgModelConfigMainMongoRepository.a(new com.tplink.smb.omada.maintenance.common.b.a.a.c(internetPO.getOmadacId()), new com.tplink.smb.omada.maintenance.common.b.a.a.d(internetPO.getSiteId()));
        modelConfigPO.ifPresent(osgModelConfigPO -> {
            AtomicBoolean needUpdateLoadBalance = new AtomicBoolean(false);
            osgModelConfigPO.getOsgPortInfos().forEach(osgPortPreInfoPO -> {
                if (this.isWanOrSfpWan(osgPortPreInfoPO.getType()) && !internetPO.getWanPortUuids().contains(osgPortPreInfoPO.getPortUuid())) {
                    internetPO.getWanPortUuids().add(osgPortPreInfoPO.getPortUuid());
                    wanPortIpv4SettingPOS.add(a.b(osgPortPreInfoPO.getPortUuid()));
                    internetPO.setWanPortIpv4Settings(wanPortIpv4SettingPOS);
                    wanPortIpv6SettingPOS.add(a.a(osgPortPreInfoPO.getPortUuid()));
                    internetPO.setWanPortIpv6Settings(wanPortIpv6SettingPOS);
                    needUpdateLoadBalance.set(true);
                }
            });
            if (Boolean.TRUE.equals(needUpdateLoadBalance.get())) {
                WanLoadBalancePO oldWanLoadBalance = internetPO.getWanLoadBalance();
                HashMap<String, Integer> osgPortTypeMap = new HashMap<String, Integer>();
                ((OsgModelConfigPO)modelConfigPO.get()).getOsgPortInfos().forEach(osgPortPreInfoPO -> osgPortTypeMap.put(osgPortPreInfoPO.getPortUuid(), osgPortPreInfoPO.getType()));
                internetPO.setWanLoadBalance(a.a(oldWanLoadBalance, (List<String>)internetPO.getWanPortUuids(), osgPortTypeMap));
            }
        });
        this.internetMaintMongoRepository.a(internetPO);
    }

    private boolean isWanOrSfpWan(int type) {
        return type == o.g || type == o.d;
    }
}

