/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.DhcpOptionPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.DhcpSettingsPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V50700TOV50800)
public class WiredCompatibleCommandV50700TOV50800
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV50700TOV50800.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final g osgModelConfigMainMongoRepository = g.a();
    private final a internetMaintMongoRepository = a.a();
    private final String OLD_USB_NAME = "USB LTE WAN";
    private static final WiredCompatibleCommandV50700TOV50800 instance = new WiredCompatibleCommandV50700TOV50800();

    private WiredCompatibleCommandV50700TOV50800() {
    }

    public static WiredCompatibleCommandV50700TOV50800 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("WiredCompatible v5.7 to v5.8.");
        try {
            this.handleInternetCompatible(omadacId);
            this.hanldeLanNetworkCompatible(omadacId);
            this.fixUsbPortError(omadacId);
        }
        catch (Exception e2) {
            log.warn("WiredCompatible v5.7 to v5.8 do db compatible error.", (Throwable)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleInternetCompatible(String omadacId) {
        this.internetMaintMongoRepository.a(new c(omadacId)).forEach(internet -> {
            internet.getWanPortIpv4Settings().forEach(wanPortIpv4Setting -> {
                if (wanPortIpv4Setting.getIpv4Pppoe() != null && wanPortIpv4Setting.getIpv4Pppoe().getMru() == null) {
                    wanPortIpv4Setting.getIpv4Pppoe().setMru(wanPortIpv4Setting.getIpv4Pppoe().getMtu());
                }
            });
            this.internetMaintMongoRepository.a(internet);
        });
    }

    private void hanldeLanNetworkCompatible(String omadacId) {
        List lanNetworks = this.lanNetworkMaintMongoRepository.a(omadacId);
        if (CollectionUtils.isEmpty((Collection)lanNetworks)) {
            return;
        }
        lanNetworks.forEach(lanNetwork -> {
            if (lanNetwork.getDhcpSettings() != null) {
                DhcpSettingsPO dhcpSettings = lanNetwork.getDhcpSettings();
                ArrayList<DhcpOptionPO> options = new ArrayList<DhcpOptionPO>();
                if (dhcpSettings.getOption60() != null) {
                    DhcpOptionPO option60 = new DhcpOptionPO().setCode(com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.a.h.a()).setType(com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.a.h.b()).setValue(dhcpSettings.getOption60());
                    options.add(option60);
                    dhcpSettings.setOptions(options);
                }
                if (dhcpSettings.getOption66() != null) {
                    DhcpOptionPO option66 = new DhcpOptionPO().setCode(com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.a.i.a()).setType(com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.a.i.b()).setValue(dhcpSettings.getOption60());
                    options.add(option66);
                    dhcpSettings.setOptions(options);
                }
                if (dhcpSettings.getOption138() != null) {
                    DhcpOptionPO option138 = new DhcpOptionPO().setCode(com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.a.k.a()).setType(com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.a.k.b()).setValue(dhcpSettings.getOption138());
                    options.add(option138);
                    dhcpSettings.setOptions(options);
                }
                this.lanNetworkMaintMongoRepository.a(lanNetwork);
            }
        });
    }

    private void fixUsbPortError(String omadacId) {
        List osgModelConfigPOS = this.osgModelConfigMainMongoRepository.a(new c(omadacId));
        if (CollectionUtils.isEmpty((Collection)osgModelConfigPOS)) {
            return;
        }
        for (OsgModelConfigPO osgModelConfigPO : osgModelConfigPOS) {
            if (b.b.b() != osgModelConfigPO.getOsgModel().intValue()) continue;
            osgModelConfigPO.getOsgPortInfos().removeIf(port -> "USB LTE WAN".equals(port.getName()));
            this.osgModelConfigMainMongoRepository.a(osgModelConfigPO);
        }
    }
}

