/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.OsgModelConfigDTO;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgPortPreInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V50300TOV50400)
public class WiredCompatibleCommandV50300TOV50400
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV50300TOV50400.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final c osgMaintMongoRepository = c.a();
    private final ScheduleCenter scheduleCenter = (ScheduleCenter)a.b(ScheduleCenter.class);
    private static final WiredCompatibleCommandV50300TOV50400 instance = new WiredCompatibleCommandV50300TOV50400();
    private final String USB_NAME_START_STRING = "U";
    private final String USB_NAME = "USB Modem";
    private final String SPEED_TEST_TASK_NAME = "manager_speed_test";
    private final long USB_MAX_BANDWIDTH = 100L;
    private final long NORMAL_WAN_MAX_BANDWIDTH = 1000L;
    private final long SFP_PLUS_MAX_BANDWIDTH = 10000L;

    private WiredCompatibleCommandV50300TOV50400() {
    }

    public static WiredCompatibleCommandV50300TOV50400 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        com.tplink.smb.omada.maintenance.common.b.a.a.c omadac = new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId);
        this.handleOsgModel(omadac);
        this.cancelSpeedTest();
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleOsgModel(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        this.handleOsgModelConfig(omadacId);
        this.handle8411(omadacId);
        this.handle605V2(omadacId);
    }

    private void cancelSpeedTest() {
        this.scheduleCenter.deleteTask(TaskKey.of((String)"manager_speed_test"));
    }

    private void handleOsgModelConfig(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgModelConfigPOS = this.osgModelConfigMainMongoRepository.a(omadacId);
        if (CollectionUtils.isEmpty((Collection)osgModelConfigPOS)) {
            return;
        }
        for (OsgModelConfigPO osgModelConfigPO : osgModelConfigPOS) {
            this.handlePortMap(osgModelConfigPO);
            this.handleBandWidth(osgModelConfigPO);
        }
        this.osgModelConfigMainMongoRepository.a(osgModelConfigPOS);
    }

    private void handle8411(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgPOS = this.osgMaintMongoRepository.e(omadacId).stream().filter(osgPO -> b.a(osgPO.getCompoundModel()) == b.o).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(osgPOS)) {
            return;
        }
        List sites = osgPOS.stream().map(DevicePO::getSiteId).collect(Collectors.toList());
        List osgModelConfigPOS = this.osgModelConfigMainMongoRepository.a(omadacId, sites);
        if (CollectionUtils.isEmpty((Collection)osgModelConfigPOS)) {
            return;
        }
        for (OsgModelConfigPO osgModelConfigPO : osgModelConfigPOS) {
            this.handleUniversalTo8411(osgModelConfigPO);
        }
        this.osgModelConfigMainMongoRepository.a(osgModelConfigPOS);
    }

    private void handleUniversalTo8411(OsgModelConfigPO osgModelConfigPO) {
        this.handlePortMap(osgModelConfigPO);
        osgModelConfigPO.setOsgModel(Integer.valueOf(b.o.b()));
        List osgPortPreInfoPOS = osgModelConfigPO.getOsgPortInfos();
        osgPortPreInfoPOS.sort(Comparator.comparing(OsgPortPreInfoPO::getPortId));
        OsgPortPreInfoPO wan = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(0);
        wan.setName("SFP+ WAN1");
        wan.setSupportIptv(Boolean.valueOf(false));
        OsgPortPreInfoPO wl2 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(1);
        wl2.setName("SFP+ WAN/LAN2");
        wl2.setType(o.e);
        wl2.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl3 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(2);
        wl3.setName("SFP WAN/LAN3");
        wl3.setType(o.e);
        wl3.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl4 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(3);
        wl4.setName("WAN/LAN4");
        wl4.setType(o.e);
        wl4.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl5 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(4);
        wl5.setName("WAN/LAN5");
        wl5.setType(o.e);
        wl5.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl6 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(5);
        wl6.setName("WAN/LAN6");
        wl6.setType(o.e);
        wl6.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl7 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(6);
        wl7.setType(o.e);
        wl7.setName("WAN/LAN7");
        wl7.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl8 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(7);
        wl8.setType(o.e);
        wl8.setName("WAN/LAN8");
        wl8.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl9 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(8);
        wl9.setType(o.e);
        wl9.setName("WAN/LAN9");
        wl9.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl10 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(9);
        wl10.setType(o.e);
        wl10.setName("WAN/LAN10");
        wl10.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl11 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(10);
        wl11.setType(o.e);
        wl11.setName("WAN/LAN11");
        wl11.setSupportIptv(Boolean.valueOf(true));
        OsgPortPreInfoPO wl12 = (OsgPortPreInfoPO)osgPortPreInfoPOS.get(11);
        wl12.setType(o.h);
        wl12.setName("USB Modem");
        wl12.setSupportIptv(Boolean.valueOf(false));
        this.sortPortByUsb(osgPortPreInfoPOS);
    }

    private void sortPortByUsb(List<OsgPortPreInfoPO> ports) {
        ports.sort((o1, o2) -> {
            if (o1.getName().startsWith("U") && o2.getName().startsWith("U")) {
                return o1.getPortId() - o2.getPortId();
            }
            if (o1.getName().startsWith("U")) {
                return -1;
            }
            if (o2.getName().startsWith("U")) {
                return 1;
            }
            return o1.getPortId() - o2.getPortId();
        });
    }

    private void handle605V2(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        List osgModelConfigPOS = this.osgModelConfigMainMongoRepository.a(omadacId);
        if (CollectionUtils.isEmpty((Collection)osgModelConfigPOS)) {
            return;
        }
        for (OsgModelConfigPO osgModelConfigPO : osgModelConfigPOS) {
            this.handle605V2UsbName(osgModelConfigPO);
        }
        this.osgModelConfigMainMongoRepository.a(osgModelConfigPOS);
    }

    private void handle605V2UsbName(OsgModelConfigPO osgModelConfigPO) {
        List osgPortPreInfoPOS = osgModelConfigPO.getOsgPortInfos();
        if (CollectionUtils.isEmpty((Collection)osgPortPreInfoPOS)) {
            return;
        }
        for (OsgPortPreInfoPO osgPortPreInfoPO : osgPortPreInfoPOS) {
            if (!osgPortPreInfoPO.getName().startsWith("U")) continue;
            osgPortPreInfoPO.setName("USB Modem");
            break;
        }
    }

    private void handlePortMap(OsgModelConfigPO osgModelConfigPO) {
        HashMap<String, Integer> oldMap = osgModelConfigPO.getPortUuidPortIdMap();
        if (oldMap == null) {
            oldMap = new HashMap<String, Integer>();
            for (int i2 = 1; i2 <= 12; ++i2) {
                oldMap.put(OsgModelConfigDTO.generatePortUuid(i2), i2);
            }
            return;
        }
        if (oldMap.size() >= 12) {
            return;
        }
        for (int i3 = 7; i3 <= 12; ++i3) {
            oldMap.put(OsgModelConfigDTO.generatePortUuid(i3), i3);
        }
    }

    private void handleBandWidth(@Nonnull OsgModelConfigPO osgModelConfig) {
        List osgPortInfos = osgModelConfig.getOsgPortInfos();
        if (CollectionUtils.isEmpty((Collection)osgPortInfos)) {
            return;
        }
        b preOsgModelEnum = b.a(osgModelConfig.getOsgModel());
        if (preOsgModelEnum == null) {
            return;
        }
        switch (preOsgModelEnum) {
            case o: {
                this.handle8411BandWidth(osgPortInfos);
                break;
            }
            case b: {
                this.handle605v2BandWidth(osgPortInfos);
                break;
            }
            case d: {
                this.handle7206BandWidth(osgPortInfos);
                break;
            }
            case a: {
                this.handle605BandWidth(osgPortInfos);
                break;
            }
            case n: {
                this.handleUniversalBandWidth(osgPortInfos);
                break;
            }
            default: {
                return;
            }
        }
        log.debug("fill bandwidth in modelConfig {} {}", (Object)osgModelConfig.getOmadacId(), (Object)osgModelConfig.getSiteId());
    }

    private void handle605v2BandWidth(List<OsgPortPreInfoPO> osgPortInfos) {
        for (OsgPortPreInfoPO osgPortPreInfoPO : osgPortInfos) {
            if (osgPortPreInfoPO.getPortId() == 6) {
                osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(100L));
                continue;
            }
            if (osgPortPreInfoPO.getPortId() < 1 || osgPortPreInfoPO.getPortId() > 3) continue;
            osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(1000L));
        }
    }

    private void handle8411BandWidth(List<OsgPortPreInfoPO> osgPortInfos) {
        for (OsgPortPreInfoPO osgPortPreInfoPO : osgPortInfos) {
            if (osgPortPreInfoPO.getPortId() == 12) {
                osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(100L));
                continue;
            }
            if (osgPortPreInfoPO.getPortId() >= 1 && osgPortPreInfoPO.getPortId() <= 2) {
                osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(10000L));
                continue;
            }
            if (osgPortPreInfoPO.getPortId() < 3 || osgPortPreInfoPO.getPortId() > 11) continue;
            osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(1000L));
        }
    }

    private void handle7206BandWidth(List<OsgPortPreInfoPO> osgPortInfos) {
        for (OsgPortPreInfoPO osgPortPreInfoPO : osgPortInfos) {
            if (osgPortPreInfoPO.getPortId() < 1 || osgPortPreInfoPO.getPortId() > 4) continue;
            osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(1000L));
        }
    }

    private void handle605BandWidth(List<OsgPortPreInfoPO> osgPortInfos) {
        for (OsgPortPreInfoPO osgPortPreInfoPO : osgPortInfos) {
            if (osgPortPreInfoPO.getPortId() < 1 || osgPortPreInfoPO.getPortId() > 4) continue;
            osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(1000L));
        }
    }

    private void handleUniversalBandWidth(List<OsgPortPreInfoPO> osgPortInfos) {
        for (OsgPortPreInfoPO osgPortPreInfoPO : osgPortInfos) {
            if (o.h.equals(osgPortPreInfoPO.getType())) {
                osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(100L));
                continue;
            }
            if (o.m.equals(osgPortPreInfoPO.getType())) {
                osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(1000L));
                continue;
            }
            if (o.e.equals(osgPortPreInfoPO.getType())) {
                osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(1000L));
                continue;
            }
            if (!o.g.equals(osgPortPreInfoPO.getType())) continue;
            osgPortPreInfoPO.setMaxBandwidth(Long.valueOf(10000L));
        }
    }
}

