/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork;

import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.LanProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.ManuallyConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.UsbLteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgPortPreInfoPO;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V50100TOV50200)
public class WiredCompatibleCommandV50100TOV50200
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredCompatibleCommandV50100TOV50200.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final a internetMaintMongoRepository = a.a();
    private final e lanProfileMaintMongoRepository = e.a();
    private static final WiredCompatibleCommandV50100TOV50200 instance = new WiredCompatibleCommandV50100TOV50200();

    private WiredCompatibleCommandV50100TOV50200() {
    }

    public static WiredCompatibleCommandV50100TOV50200 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        c omadac = new c(omadacId);
        this.handleUsbPropertyEncrypt(omadac);
        this.handleOsgModelPortCap(omadac);
        this.handleProfile(omadac);
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleProfile(c omadac) {
        List profiles = this.lanProfileMaintMongoRepository.a(omadac);
        if (CollectionUtils.isEmpty((Collection)profiles)) {
            return;
        }
        boolean saveFlag = false;
        for (LanProfilePO lanProfilePO : profiles) {
            List tagNetworkIds;
            List untagNetworkIds;
            String nativeNetworkId = lanProfilePO.getNativeNetworkId();
            if (T.a((String)nativeNetworkId, (String)lanProfilePO.getVoiceNetworkId())) {
                lanProfilePO.setVoiceNetworkId(null);
                saveFlag = true;
            }
            if (!CollectionUtils.isEmpty((Collection)(untagNetworkIds = lanProfilePO.getUntagNetworkIds()))) {
                boolean bl = saveFlag = untagNetworkIds.remove(nativeNetworkId) || saveFlag;
            }
            if (CollectionUtils.isEmpty((Collection)(tagNetworkIds = lanProfilePO.getTagNetworkIds()))) continue;
            saveFlag = tagNetworkIds.remove(nativeNetworkId) || saveFlag;
        }
        if (saveFlag) {
            this.lanProfileMaintMongoRepository.a(profiles);
        }
        log.debug("Handle lanProfile on omadac {} compatible done.", (Object)omadac);
    }

    public void handleUsbPropertyEncrypt(c omadacId) {
        List internetPOS = this.internetMaintMongoRepository.a(omadacId);
        if (CollectionUtils.isEmpty((Collection)internetPOS)) {
            return;
        }
        for (InternetPO internetPO : internetPOS) {
            List usbLteSettingPOS = internetPO.getUsbLteSettings();
            if (CollectionUtils.isEmpty((Collection)usbLteSettingPOS)) continue;
            for (UsbLteSettingPO usbLteSettingPO : usbLteSettingPOS) {
                if (usbLteSettingPO.getManuallyConfig() != null) {
                    ManuallyConfigPO manuallyConfigPO = usbLteSettingPO.getManuallyConfig();
                    manuallyConfigPO.setEncryptUsername(com.tplink.smb.omada.common.util.b.b.c((String)manuallyConfigPO.getUsername()));
                    manuallyConfigPO.setEncryptPassword(com.tplink.smb.omada.common.util.b.b.c((String)manuallyConfigPO.getPassword()));
                    if (!OmadacType.s()) {
                        manuallyConfigPO.setUsername(null);
                        manuallyConfigPO.setPassword(null);
                    }
                }
                usbLteSettingPO.setEncryptPin(com.tplink.smb.omada.common.util.b.b.c((String)usbLteSettingPO.getPin()));
                if (OmadacType.s()) continue;
                usbLteSettingPO.setPin(null);
            }
            this.internetMaintMongoRepository.a(internetPO);
        }
    }

    private void handleOsgModelPortCap(c omadacId) {
        List osgModelConfigPOS = this.osgModelConfigMainMongoRepository.a(omadacId);
        if (CollectionUtils.isEmpty((Collection)osgModelConfigPOS)) {
            return;
        }
        for (OsgModelConfigPO osgModelConfigPO : osgModelConfigPOS) {
            this.handleSupportIptv(osgModelConfigPO);
        }
        this.osgModelConfigMainMongoRepository.a(osgModelConfigPOS);
    }

    private void handleSupportIptv(@Nonnull OsgModelConfigPO osgModelConfig) {
        List osgPortInfos = osgModelConfig.getOsgPortInfos();
        if (CollectionUtils.isEmpty((Collection)osgPortInfos)) {
            return;
        }
        b preOsgModelEnum = b.a(osgModelConfig.getOsgModel());
        if (preOsgModelEnum == null) {
            log.error("omadacId={},siteId={} osgmodel error.", (Object)osgModelConfig.getOmadacId(), (Object)osgModelConfig.getSiteId());
            throw new com.tplink.smb.omada.backup.api.d.c("osgmodel error.");
        }
        switch (preOsgModelEnum) {
            case b: {
                this.handle605v2(osgPortInfos);
                break;
            }
            case d: {
                this.handle7206(osgPortInfos);
                break;
            }
            default: {
                this.handleUniversal(osgPortInfos);
            }
        }
    }

    private void handle605v2(List<OsgPortPreInfoPO> osgPortInfos) {
        for (OsgPortPreInfoPO osgPortPreInfoPO : osgPortInfos) {
            if (osgPortPreInfoPO.getPortId() == 6) {
                osgPortPreInfoPO.setSupportIptv(Boolean.valueOf(false));
                continue;
            }
            osgPortPreInfoPO.setSupportIptv(Boolean.valueOf(true));
        }
    }

    private void handle7206(List<OsgPortPreInfoPO> osgPortInfos) {
        for (OsgPortPreInfoPO osgPortPreInfoPO : osgPortInfos) {
            if (osgPortPreInfoPO.getPortId() == 1) {
                osgPortPreInfoPO.setSupportIptv(Boolean.valueOf(false));
                continue;
            }
            osgPortPreInfoPO.setSupportIptv(Boolean.valueOf(true));
        }
    }

    private void handleUniversal(List<OsgPortPreInfoPO> osgPortInfos) {
        for (OsgPortPreInfoPO osgPortPreInfoPO : osgPortInfos) {
            osgPortPreInfoPO.setSupportIptv(Boolean.valueOf(true));
        }
    }
}

