/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.vpn;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.policyrouting.BasePolicyRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.policyrouting.PolicyRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.vpn.BaseVpnPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.vpn.VpnPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.vpn.embed.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.vpnuser.VpnUserPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V50100TOV50200)
public class VpnCompatibleCommandV50100TOV50200
implements h {
    private static final VpnCompatibleCommandV50100TOV50200 instance = new VpnCompatibleCommandV50100TOV50200();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d vpnMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d.a();
    private final e vpnUserMaintMongoRepository = e.a();
    private final g policyRoutingMaintMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.d staticRoutingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.d.a();

    private VpnCompatibleCommandV50100TOV50200() {
    }

    public static VpnCompatibleCommandV50100TOV50200 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        c omadac = new c(omadacId);
        List vpns = this.vpnMaintMongoRepository.b(omadac);
        ArrayList<VpnPO> validVpns = new ArrayList<VpnPO>();
        if (CollectionUtils.isEmpty((Collection)vpns)) {
            return;
        }
        for (VpnPO vpnPO : vpns) {
            if (!this.isValid(vpnPO)) {
                this.vpnMaintMongoRepository.a(new c(vpnPO.getOmadacId()), new com.tplink.smb.omada.maintenance.common.b.a.a.d(vpnPO.getSiteId()), vpnPO.getId());
                continue;
            }
            validVpns.add(vpnPO);
        }
        this.handleVpnUser(omadac, validVpns);
        List<String> validVpnIds = validVpns.stream().map(BaseVpnPO::getId).collect(Collectors.toList());
        this.handlePolicyRouting(omadac, validVpnIds);
        this.handleStaticRouting(omadac, validVpnIds);
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleVpnUser(c omadacId, List<VpnPO> validVpns) {
        List users = this.vpnUserMaintMongoRepository.a(omadacId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return;
        }
        for (VpnUserPO userPO : users) {
            this.modifyInvalidVpnUser(userPO, validVpns);
        }
        this.vpnUserMaintMongoRepository.b(users);
    }

    private void modifyInvalidVpnUser(VpnUserPO user, List<VpnPO> validVpns) {
        List vpnServers = user.getServers();
        if (CollectionUtils.isEmpty((Collection)vpnServers)) {
            return;
        }
        List validVpnIds = validVpns.stream().map(BaseVpnPO::getId).collect(Collectors.toList());
        vpnServers.removeIf(server -> !validVpnIds.contains(server));
        this.updateServerNames(user, validVpns);
    }

    private void handlePolicyRouting(c omadacId, List<String> validVpnIds) {
        this.policyRoutingMaintMongoRepository.a(omadacId, validVpnIds);
        List allPolicyRoutingPOPOS = this.policyRoutingMaintMongoRepository.a(omadacId);
        Map<String, List<PolicyRoutingPO>> policyRoutingPOSiteMap = allPolicyRoutingPOPOS.stream().sorted(Comparator.comparing(BasePolicyRoutingPO::getIndex)).collect(Collectors.groupingBy(PolicyRoutingPO::getSiteId));
        for (Map.Entry<String, List<PolicyRoutingPO>> entry : policyRoutingPOSiteMap.entrySet()) {
            int index = 1;
            List<PolicyRoutingPO> sitePolicyList = entry.getValue();
            if (CollectionUtils.isEmpty(sitePolicyList)) continue;
            for (PolicyRoutingPO policyRoutingPO : sitePolicyList) {
                policyRoutingPO.setIndex(Integer.valueOf(index));
                ++index;
            }
        }
        this.policyRoutingMaintMongoRepository.a(new ArrayList(allPolicyRoutingPOPOS));
    }

    private void handleStaticRouting(c omadacId, List<String> validVpnIds) {
        this.staticRoutingMaintMongoRepository.b(omadacId, validVpnIds);
    }

    private boolean isValid(VpnPO vpnPO) {
        if (Objects.equals(vpnPO.getSiteVpnType(), b.c)) {
            return true;
        }
        return !CollectionUtils.isEmpty((Collection)vpnPO.getNetworkList()) && !CollectionUtils.isEmpty((Collection)vpnPO.getWans());
    }

    public void updateServerNames(VpnUserPO user, List<VpnPO> vpnPOS) {
        List vpnNames = vpnPOS.stream().filter(vpn -> user.getServers().contains(vpn.getId())).map(BaseVpnPO::getName).collect(Collectors.toList());
        if (org.springframework.util.CollectionUtils.isEmpty(vpnNames)) {
            user.setServerNames(null);
            return;
        }
        user.setServerNames(T.a(vpnNames, (String)","));
    }
}

