/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.voucher;

import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.BaseSitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.portal.port.mongo.omada.hotspot.HotspotSiteSettingMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.hotspot.HotspotSiteSettingPO;
import com.tplink.smb.omada.portal.port.mongo.omada.hotspot.VoucherSummaryPO;
import com.tplink.smb.omada.portal.port.mongo.omada.voucher.VoucherGroupPO;
import com.tplink.smb.omada.portal.port.mongo.omada.voucher.VoucherPO;
import com.tplink.smb.omada.portal.port.mongo.omada.vouchergroup.VoucherGroupMaintRepository;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51000TOV51100)
@b(a=e.V1000002000TOV1000003000)
public class VoucherCompatibleCommandV51000TOV51100
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherCompatibleCommandV51000TOV51100.class);
    private static final VoucherCompatibleCommandV51000TOV51100 instance = new VoucherCompatibleCommandV51000TOV51100();
    public static final int BATCH_SIZE = 1000;
    private static final String UPDATE_VOUCHER_GROUP_NAME_PREFIX = "VoucherGroup_";
    private static final String UPDATE_CREATOR_ID = "";
    private static final String UPDATE_CREATOR_NAME = "";
    private static final String UPDATE_CREATOR_ROLE = "";
    private final com.tplink.smb.omada.portal.port.mongo.omada.voucher.c voucherRepository = com.tplink.smb.omada.portal.port.mongo.omada.voucher.c.a();
    private final VoucherGroupMaintRepository voucherGroupRepository = VoucherGroupMaintRepository.getInstance();
    private final HotspotSiteSettingMaintRepository hotspotSiteSettingMaintRepository = HotspotSiteSettingMaintRepository.getInstance();
    private final g siteRepository = g.a();

    public static VoucherCompatibleCommandV51000TOV51100 getInstance() {
        return instance;
    }

    private VoucherCompatibleCommandV51000TOV51100() {
    }

    @Override
    public void dbCompatible(String omadacIdStr, d operationType) {
        log.info("Upgrading Voucher from v5.10.0 to v5.11.0");
        c omadacId = new c(omadacIdStr);
        this.siteRepository.a(omadacId).stream().map(BaseSitePO::getId).map(com.tplink.smb.omada.maintenance.common.b.a.a.d::new).forEach(siteId -> {
            log.debug("Upgrading Vouchers of omadac: {}, site: {}", (Object)omadacId, siteId);
            this.dbCompatible(omadacId, (com.tplink.smb.omada.maintenance.common.b.a.a.d)siteId);
        });
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void dbCompatible(c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId) {
        HashMap updateGroupMap = new HashMap();
        AtomicInteger voucherGroupCount = new AtomicInteger(1);
        AtomicLong currentCreatedTime = new AtomicLong(-1L);
        AtomicLong siteVoucherCount = new AtomicLong(0L);
        AtomicLong siteVoucherDuration = new AtomicLong(0L);
        AtomicReference<BigDecimal> siteVoucherAmount = new AtomicReference<BigDecimal>(new BigDecimal("0"));
        this.voucherRepository.a(omadacId, siteId, voucher -> {
            Long createdTime;
            VoucherGroupPO po;
            siteVoucherCount.addAndGet(1L);
            siteVoucherDuration.addAndGet(voucher.getDuration());
            if (voucher.getUnitPrice() != null) {
                siteVoucherAmount.updateAndGet(amount -> amount.add(new BigDecimal(voucher.getUnitPrice())));
            }
            if ((po = (VoucherGroupPO)updateGroupMap.get(createdTime = voucher.getCreatedTime())) == null) {
                po = this.buildVoucherGroupFromVoucher((VoucherPO)voucher, voucherGroupCount);
            }
            this.updateGroupCounts(po, (VoucherPO)voucher);
            long previousCreatedTime = currentCreatedTime.getAndSet(createdTime);
            if (previousCreatedTime != -1L && previousCreatedTime != createdTime) {
                VoucherGroupPO lastGroup = (VoucherGroupPO)updateGroupMap.get(previousCreatedTime);
                log.info("Grouping {} vouchers with same create time to VoucherGroup: {}", (Object)lastGroup.getTotalCount(), (Object)lastGroup.getName());
                this.voucherRepository.a(lastGroup);
                if (updateGroupMap.size() > 1000) {
                    this.voucherGroupRepository.insertAll(new ArrayList(updateGroupMap.values()));
                    updateGroupMap.clear();
                }
            }
            updateGroupMap.put(createdTime, po);
        });
        VoucherGroupPO lastGroup = (VoucherGroupPO)updateGroupMap.get(currentCreatedTime.get());
        if (lastGroup != null) {
            log.info("Grouping {} vouchers with same create time to VoucherGroup: {}", (Object)lastGroup.getTotalCount(), (Object)lastGroup.getName());
            this.voucherRepository.a(lastGroup);
        }
        if (updateGroupMap.size() > 0) {
            this.voucherGroupRepository.insertAll(new ArrayList(updateGroupMap.values()));
        }
        HotspotSiteSettingPO setting = this.hotspotSiteSettingMaintRepository.findByOmadacIdAndSiteId(omadacId, siteId).orElseGet(() -> new HotspotSiteSettingPO().setOmadacId(omadacId.a()).setSiteId(siteId.a()));
        setting.setCreatedVoucherSummary(new VoucherSummaryPO().setAmount(siteVoucherAmount.get().stripTrailingZeros().toPlainString()).setCount(Long.valueOf(siteVoucherCount.get())).setDuration(Long.valueOf(siteVoucherDuration.get())));
        this.hotspotSiteSettingMaintRepository.save(setting);
    }

    private void updateGroupCounts(VoucherGroupPO po, VoucherPO voucher) {
        if (voucher.getUsed() == null || voucher.getUsed() == 0 || voucher.getEndTime() == null) {
            po.setUnusedCount(Integer.valueOf(po.getUnusedCount() + 1));
        } else if (voucher.getEndTime() >= System.currentTimeMillis()) {
            po.setInUseCount(Integer.valueOf(po.getInUseCount() + 1));
            po.setUsedCount(Integer.valueOf(po.getUsedCount() + 1));
        } else if (voucher.getEndTime() < System.currentTimeMillis()) {
            po.setExpiredCount(Integer.valueOf(po.getExpiredCount() + 1));
            po.setUsedCount(Integer.valueOf(po.getUsedCount() + 1));
        }
        po.setTotalCount(Integer.valueOf(po.getTotalCount() + 1)).setTotalDuration(Long.valueOf(po.getTotalDuration() + voucher.getDuration())).setCreateCount(Integer.valueOf(po.getCreateCount() + 1));
    }

    private VoucherGroupPO buildVoucherGroupFromVoucher(VoucherPO voucher, AtomicInteger count) {
        return new VoucherGroupPO().setId(this.voucherGroupRepository.nextId()).setOmadacId(voucher.getOmadacId()).setSiteId(voucher.getSiteId()).setName(UPDATE_VOUCHER_GROUP_NAME_PREFIX + count.getAndIncrement()).setCreatedTime(voucher.getCreatedTime()).setType(voucher.getType()).setMaxUsers(voucher.getMaxUsers()).setDuration(voucher.getDuration()).setDurationType(Optional.ofNullable(voucher.getDurationType()).orElse(1)).setDescription(voucher.getNote()).setUpTimeLimitEnable(voucher.getUpTimeLimitEnable()).setExpirationTime(voucher.getExpirationTime()).setDownLimitEnable(voucher.getDownLimitEnable()).setDownLimit(voucher.getDownLimit()).setUpLimitEnable(voucher.getUpLimitEnable()).setUpLimit(voucher.getUpLimit()).setRateLimitId(voucher.getRateLimitId()).setTrafficLimitEnable(voucher.getTrafficLimitEnable()).setTrafficLimit(voucher.getTrafficLimit()).setTrafficLimitFrequency(voucher.getTrafficLimitFrequency()).setApplyToAllPortals(Boolean.valueOf(Boolean.TRUE.equals(voucher.getApplyToAllPortals()))).setPortals(voucher.getPortals()).setUsedCount(Integer.valueOf(0)).setInUseCount(Integer.valueOf(0)).setExpiredCount(Integer.valueOf(0)).setUnusedCount(Integer.valueOf(0)).setCreateCount(Integer.valueOf(0)).setTotalCount(Integer.valueOf(0)).setUnitPrice(voucher.getUnitPrice()).setCreatorRole("").setCreatorId("").setCreatorName("").setTotalAmount(null).setTotalDuration(Long.valueOf(0L));
    }
}

