/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.switchqos;

import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.BaseOswSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.QueueSchedulerConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.x;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.q;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V60000TOV60100)
@b(a=e.V1200000000TOV1200001000)
public class SwitchQosCompatibleCommandV60000TOV60100
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchQosCompatibleCommandV60000TOV60100.class);
    private static final SwitchQosCompatibleCommandV60000TOV60100 instance = new SwitchQosCompatibleCommandV60000TOV60100();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.g dscpDot1pMappingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.d dot1pQueueMappingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.d.a();
    private final x queueSchedulerMaintMongoRepository = x.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e lanProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e.a();
    private final q oswPortMaintMongoRepository = q.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.a oswLagMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.a.a();
    private final g siteMaintMongoRepository = g.a();
    private final a oswSiteSettingMaintMongoRepository = a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private static final Integer UN_TRUST = 0;
    private static final Integer DEFAULT_PRIORITY = 0;
    private static final Integer OSW_QOS_OLD_MODE = 0;
    private static final Integer OSW_QOS_MODE_UNCOMPLETED = 0;
    private static final Integer OSW_QOS_NEW_MODE = 1;
    private static final Integer OSW_QOS_MODE_COMPLETED = 1;
    public static final Integer PROFILE_TYPE_WRR = 2;

    private SwitchQosCompatibleCommandV60000TOV60100() {
    }

    public static SwitchQosCompatibleCommandV60000TOV60100 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        try {
            Set siteIds = this.siteMaintMongoRepository.b(new c(omadacId));
            if (CollectionUtils.isEmpty((Collection)siteIds)) {
                return;
            }
            Map<String, List<LanNetworkPO>> siteIdLannetworkMap = this.lanNetworkMaintMongoRepository.a(omadacId).stream().collect(Collectors.groupingBy(LanNetworkPO::getSiteId));
            boolean qosConfigOverride = siteIds.stream().anyMatch(siteId -> this.checkOswQosConfig(omadacId, (String)siteId, siteIdLannetworkMap));
            siteIds.forEach(siteId -> {
                this.oswSiteSettingMaintMongoRepository.a(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId)).ifPresent(oswSiteSettingPO -> {
                    if (qosConfigOverride) {
                        oswSiteSettingPO.setQosMode(OSW_QOS_OLD_MODE);
                        oswSiteSettingPO.setQosModeCompleted(OSW_QOS_MODE_UNCOMPLETED);
                    } else {
                        oswSiteSettingPO.setQosMode(OSW_QOS_NEW_MODE);
                        oswSiteSettingPO.setQosModeCompleted(OSW_QOS_MODE_COMPLETED);
                    }
                    this.oswSiteSettingMaintMongoRepository.a((BaseOswSiteSettingPO)oswSiteSettingPO);
                });
                if (qosConfigOverride) {
                    return;
                }
                this.handleQueueScheduleMapping(omadacId, (String)siteId);
            });
        }
        catch (Exception e2) {
            log.error("SwitchQosCompatibleCommandV60000TOV60100 exception", (Throwable)e2);
        }
    }

    private void handleQueueScheduleMapping(String omadacId, String siteId) {
        ArrayList<QueueSchedulerConfigPO> mapping = new ArrayList<QueueSchedulerConfigPO>();
        for (int index = 0; index <= 7; ++index) {
            QueueSchedulerConfigPO queueScheduleConfig = new QueueSchedulerConfigPO();
            queueScheduleConfig.setQueue(Integer.valueOf(index));
            queueScheduleConfig.setType(PROFILE_TYPE_WRR);
            SwitchQosCompatibleCommandV60000TOV60100.handleDefaultWRRWeight(index, queueScheduleConfig);
            mapping.add(queueScheduleConfig);
        }
        this.queueSchedulerMaintMongoRepository.b(omadacId, siteId).ifPresent(mappingPO -> {
            mappingPO.setMapping(mapping);
            this.queueSchedulerMaintMongoRepository.a(mappingPO);
        });
    }

    private static void handleDefaultWRRWeight(int index, QueueSchedulerConfigPO queueScheduleConfig) {
        if (index < 5) {
            queueScheduleConfig.setWeight(Integer.valueOf(index + 1));
            return;
        }
        switch (index) {
            case 5: {
                queueScheduleConfig.setWeight(Integer.valueOf(9));
                break;
            }
            case 6: {
                queueScheduleConfig.setWeight(Integer.valueOf(13));
                break;
            }
            case 7: {
                queueScheduleConfig.setWeight(Integer.valueOf(15));
                break;
            }
        }
    }

    private boolean checkOswQosConfig(String omadacId, String siteId, Map<String, List<LanNetworkPO>> siteIdLannetworkMap) {
        List dscpDot1pMappingPOS = this.dscpDot1pMappingMaintMongoRepository.b(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId));
        List dot1pQueueMappingPOS = this.dot1pQueueMappingMaintMongoRepository.b(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId));
        List queueSchedulerMappingPOS = this.queueSchedulerMaintMongoRepository.b(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId));
        if (dscpDot1pMappingPOS.size() > 1 || dot1pQueueMappingPOS.size() > 1 || queueSchedulerMappingPOS.size() > 1) {
            log.info("omadacId:{}, siteId:{} exist custom mapping profile.", (Object)omadacId, (Object)siteId);
            return true;
        }
        boolean lanProfileQosConfigOverride = this.lanProfileMaintMongoRepository.a(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId)).stream().anyMatch(lanProfilePO -> lanProfilePO.getTrustMode() != null && !Objects.equals(UN_TRUST, lanProfilePO.getTrustMode()) || lanProfilePO.getDot1pPriority() != null && !Objects.equals(DEFAULT_PRIORITY, lanProfilePO.getDot1pPriority()));
        if (lanProfileQosConfigOverride) {
            log.info("omadacId:{}, siteId:{} lanProfile qosConfig override.", (Object)omadacId, (Object)siteId);
            return true;
        }
        List oswPortPOS = this.oswPortMaintMongoRepository.d(omadacId, siteId);
        boolean portQosConfigOverride = oswPortPOS.stream().anyMatch(oswPortPO -> oswPortPO.getTrustMode() != null && !Objects.equals(oswPortPO.getTrustMode(), UN_TRUST) || oswPortPO.getDot1pPriority() != null && !Objects.equals(oswPortPO.getDot1pPriority(), DEFAULT_PRIORITY));
        if (portQosConfigOverride) {
            log.info("omadacId:{}, siteId:{} port qosConfig override.", (Object)omadacId, (Object)siteId);
            return true;
        }
        List oswLagPOS = this.oswLagMaintMongoRepository.e(omadacId, siteId);
        boolean lagQosConfigOverride = oswLagPOS.stream().anyMatch(oswLagPO -> oswLagPO.getTrustMode() != null && !Objects.equals(oswLagPO.getTrustMode(), UN_TRUST) || oswLagPO.getDot1pPriority() != null && !Objects.equals(oswLagPO.getDot1pPriority(), DEFAULT_PRIORITY));
        if (lagQosConfigOverride) {
            log.info("omadacId:{}, siteId:{} lag qosConfig override.", (Object)omadacId, (Object)siteId);
            return true;
        }
        List<LanNetworkPO> qosEnableLanNetworks = ((List)Optional.ofNullable(siteIdLannetworkMap).map(map -> (List)map.get(siteId)).orElse(new ArrayList())).stream().filter(lanNetworkPO -> Boolean.TRUE.equals(lanNetworkPO.getQosQueueEnable()) && lanNetworkPO.getQueueId() != null).filter(Objects::nonNull).toList();
        if (!CollectionUtils.isEmpty(qosEnableLanNetworks)) {
            log.info("omadacId:{}, siteId:{} lanNetwork qosConfig override.", (Object)omadacId, (Object)siteId);
            return true;
        }
        return false;
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }
}

