/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.switchqos;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.SitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.CosBasicSettingDevicePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.CosBasicSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.Dot1pQueueMappingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.DscpDot1pMappingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.DscpPriorityConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.PortPriorityConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.PriorityQueuePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.QueueMappingAndSchedulerProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.QueueSchedulerConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.QueueSchedulerMappingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.SchedulerConfigPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.u;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.x;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswQosConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.a;
import com.tplink.smb.omada.manager.port.mongo.device.osw.e;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.BaseOswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.BaseOswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.q;
import com.tplink.smb.omada.manager.port.mongo.device.osw.s;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.OswStackMemberPO;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.OswStackPO;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.StackSettingPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51520TOV51522)
public class SwitchQosCompatibleCommandV51520TOV51522
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchQosCompatibleCommandV51520TOV51522.class);
    private static final String DEFAULT = "default";
    public static final Integer PROFILE_TYPE_WRR = 2;
    public static final Integer UNTRUST = 0;
    public static final Integer DOT1P_PRIORITY = 0;
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.g dscpDot1pMappingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.d dot1pQueueMappingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.d.a();
    private final x queueSchedulerMaintMongoRepository = x.a();
    private final e oswMaintMongoRepository = e.a();
    private final q oswPortMaintMongoRepository = q.a();
    private final a oswLagMaintMongoRepository = a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.a cosBasicSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.transmission.oswqos.a.a();
    private final u queueMappingAndSchedulerProfileMaintMongoRepository = u.a();
    private final s oswStackMaintMongoRepository = s.a();
    private final g siteMaintMongoRepository = g.a();
    private static final SwitchQosCompatibleCommandV51520TOV51522 instance = new SwitchQosCompatibleCommandV51520TOV51522();

    private SwitchQosCompatibleCommandV51520TOV51522() {
    }

    public static SwitchQosCompatibleCommandV51520TOV51522 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        List sitePOS = this.siteMaintMongoRepository.a(new c(omadacId));
        if (CollectionUtils.isEmpty((Collection)sitePOS)) {
            return;
        }
        for (SitePO sitePO : sitePOS) {
            String siteId = sitePO.getId();
            this.handleDefaultProfile(omadacId, siteId);
            List cosBasicSettingPOS = this.cosBasicSettingMaintMongoRepository.a(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId));
            if (!CollectionUtils.isEmpty((Collection)cosBasicSettingPOS)) {
                List macList = cosBasicSettingPOS.stream().map(CosBasicSettingPO::getMac).filter(Objects::nonNull).collect(Collectors.toList());
                List stackList = cosBasicSettingPOS.stream().map(CosBasicSettingPO::getStackId).filter(Objects::nonNull).collect(Collectors.toList());
                List oswPOList = this.oswMaintMongoRepository.a(omadacId, siteId, macList);
                List stackPOList = this.oswStackMaintMongoRepository.a(omadacId, siteId, stackList);
                Map<String, OswPO> macOswMap = oswPOList.stream().collect(Collectors.toMap(DevicePO::getMac, o2 -> o2, (a2, b2) -> a2));
                Map<String, OswStackPO> idStackMap = stackPOList.stream().collect(Collectors.toMap(OswStackPO::getStackId, o2 -> o2, (a2, b2) -> a2));
                this.handleOswPortAndLag(omadacId, siteId, macOswMap, idStackMap, cosBasicSettingPOS);
                Map<String, List<String>> profileIdTransMap = this.handleOldProfile(omadacId, siteId, cosBasicSettingPOS);
                this.handleDeviceSelfConfig(omadacId, siteId, macOswMap, idStackMap, profileIdTransMap, cosBasicSettingPOS);
            } else {
                this.handleDeviceWithDefaultConfig(omadacId, siteId);
            }
            this.cosBasicSettingMaintMongoRepository.b(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId));
            this.queueMappingAndSchedulerProfileMaintMongoRepository.b(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId));
        }
    }

    private void handleDeviceWithDefaultConfig(String omadacId, String siteId) {
        Optional dscpDot1pOpt = this.dscpDot1pMappingMaintMongoRepository.b(omadacId, siteId);
        Optional dot1pQueueOpt = this.dot1pQueueMappingMaintMongoRepository.b(omadacId, siteId);
        Optional queueSchedulerOpt = this.queueSchedulerMaintMongoRepository.b(omadacId, siteId);
        List oswPOS = this.oswMaintMongoRepository.a(omadacId, siteId, DeviceTypeEnum.c.b());
        List oswStackPOS = this.oswStackMaintMongoRepository.a(omadacId, siteId);
        this.updateOswSwitchQosConfig(omadacId, siteId, oswPOS, dscpDot1pOpt, dot1pQueueOpt, queueSchedulerOpt);
        this.updateStackSwitchQosConfig(omadacId, siteId, oswStackPOS, oswPOS, dscpDot1pOpt, dot1pQueueOpt, queueSchedulerOpt);
    }

    private void updateStackSwitchQosConfig(String omadacId, String siteId, List<OswStackPO> oswStackPOS, List<OswPO> oswPOS, Optional<DscpDot1pMappingPO> dscpDot1pOpt, Optional<Dot1pQueueMappingPO> dot1pQueueOpt, Optional<QueueSchedulerMappingPO> queueSchedulerOpt) {
        if (CollectionUtils.isEmpty(oswStackPOS)) {
            return;
        }
        Map<String, OswPO> macOswPOMap = oswPOS.stream().collect(Collectors.toMap(DevicePO::getMac, Function.identity()));
        for (OswStackPO oswStackPO : oswStackPOS) {
            boolean supportQos = this.checkOswStackSupportQos(oswStackPO, macOswPOMap);
            if (!supportQos || oswStackPO.getStackSetting() != null && oswStackPO.getStackSetting().getQosConfig() != null && oswStackPO.getStackSetting().getQosConfig().getDscpDot1pMappingId() != null && oswStackPO.getStackSetting().getQosConfig().getDot1pQueueMappingId() != null && oswStackPO.getStackSetting().getQosConfig().getQueueSchedulerMappingId() != null) continue;
            if (oswStackPO.getStackSetting() == null) {
                StackSettingPO stackSettingPO = new StackSettingPO();
                stackSettingPO.setQosConfig(new OswQosConfigPO());
                oswStackPO.setStackSetting(stackSettingPO);
            } else if (oswStackPO.getStackSetting().getQosConfig() == null) {
                oswStackPO.getStackSetting().setQosConfig(new OswQosConfigPO());
            }
            OswQosConfigPO oswQosConfigPO = oswStackPO.getStackSetting().getQosConfig();
            if (oswQosConfigPO.getDot1pQueueMappingId() == null) {
                oswQosConfigPO.setDot1pQueueMappingId((String)dot1pQueueOpt.map(Dot1pQueueMappingPO::getId).orElse(null));
            }
            if (oswQosConfigPO.getQueueSchedulerMappingId() == null) {
                oswQosConfigPO.setQueueSchedulerMappingId((String)queueSchedulerOpt.map(QueueSchedulerMappingPO::getId).orElse(null));
            }
            if (oswQosConfigPO.getDscpDot1pMappingId() == null) {
                oswQosConfigPO.setDscpDot1pMappingId((String)dscpDot1pOpt.map(DscpDot1pMappingPO::getId).orElse(null));
            }
            this.oswStackMaintMongoRepository.a(oswStackPO);
        }
    }

    private boolean checkOswStackSupportQos(OswStackPO oswStackPO, Map<String, OswPO> macOswPOMap) {
        List members = oswStackPO.getMembers();
        if (CollectionUtils.isEmpty((Collection)members)) {
            return false;
        }
        boolean supportQos = true;
        for (OswStackMemberPO member : members) {
            OswPO memberOswPO;
            if (macOswPOMap.containsKey(member.getMac()) && !Boolean.TRUE.equals((memberOswPO = macOswPOMap.get(member.getMac())).getDevCap().getQosSupport())) {
                supportQos = false;
            }
            if (supportQos) continue;
            break;
        }
        return supportQos;
    }

    private void updateOswSwitchQosConfig(String omadacId, String siteId, List<OswPO> oswPOS, Optional<DscpDot1pMappingPO> dscpDot1pOpt, Optional<Dot1pQueueMappingPO> dot1pQueueOpt, Optional<QueueSchedulerMappingPO> queueSchedulerOpt) {
        if (CollectionUtils.isEmpty(oswPOS)) {
            return;
        }
        ArrayList<OswPO> updateOswList = new ArrayList<OswPO>();
        for (OswPO oswPO : oswPOS) {
            OswQosConfigPO oswQosConfigPO;
            if (!Boolean.TRUE.equals(oswPO.getDevCap().getQosSupport()) || oswPO.getQosConfig() != null && oswPO.getQosConfig().getDot1pQueueMappingId() != null && oswPO.getQosConfig().getDscpDot1pMappingId() != null && oswPO.getQosConfig().getQueueSchedulerMappingId() != null) continue;
            if (oswPO.getQosConfig() == null) {
                oswPO.setQosConfig(new OswQosConfigPO());
            }
            if ((oswQosConfigPO = oswPO.getQosConfig()).getDot1pQueueMappingId() == null) {
                oswQosConfigPO.setDot1pQueueMappingId((String)dot1pQueueOpt.map(Dot1pQueueMappingPO::getId).orElse(null));
            }
            if (oswQosConfigPO.getQueueSchedulerMappingId() == null) {
                oswQosConfigPO.setQueueSchedulerMappingId((String)queueSchedulerOpt.map(QueueSchedulerMappingPO::getId).orElse(null));
            }
            if (oswQosConfigPO.getDscpDot1pMappingId() == null) {
                oswQosConfigPO.setDscpDot1pMappingId((String)dscpDot1pOpt.map(DscpDot1pMappingPO::getId).orElse(null));
            }
            updateOswList.add(oswPO);
        }
        if (!CollectionUtils.isEmpty(updateOswList)) {
            this.oswMaintMongoRepository.a(updateOswList);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private Map<String, List<String>> handleOldProfile(String omadacId, String siteId, List<CosBasicSettingPO> cosBasicSettingPOS) {
        List profileList = this.queueMappingAndSchedulerProfileMaintMongoRepository.a(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId));
        if (CollectionUtils.isEmpty((Collection)profileList)) {
            return new HashMap<String, List<String>>();
        }
        Set usedProfileList = cosBasicSettingPOS.stream().map(qosConfig -> qosConfig.getProfileId()).collect(Collectors.toSet());
        HashMap<String, List<String>> profileIdTransMap = new HashMap<String, List<String>>(profileList.size());
        for (QueueMappingAndSchedulerProfilePO profilePO : profileList) {
            if (Objects.equals(1, profilePO.getProfileType()) && !usedProfileList.contains(profilePO.getId()) || profileIdTransMap.containsKey(profilePO.getId())) continue;
            String dot1pQueueId = this.buildAndSaveDot1pQueue(omadacId, siteId, profilePO);
            String queueSchedulerId = this.buildAndSaveQueueScheduler(omadacId, siteId, profilePO);
            List<String> idList = Arrays.asList(dot1pQueueId, queueSchedulerId);
            profileIdTransMap.put(profilePO.getId(), idList);
        }
        return profileIdTransMap;
    }

    private String buildAndSaveQueueScheduler(String omadacId, String siteId, QueueMappingAndSchedulerProfilePO profilePO) {
        if (Objects.isNull(profilePO)) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)profilePO.getSchedulerConfig())) {
            return null;
        }
        QueueSchedulerMappingPO queueSchedulerMappingPO = new QueueSchedulerMappingPO();
        queueSchedulerMappingPO.setBuildIn(false);
        queueSchedulerMappingPO.setOmadacId(omadacId);
        queueSchedulerMappingPO.setSiteId(siteId);
        queueSchedulerMappingPO.setName(profilePO.getName() + "_2Scheduler");
        queueSchedulerMappingPO.setId(this.queueSchedulerMaintMongoRepository.b());
        ArrayList<QueueSchedulerConfigPO> mapping = new ArrayList<QueueSchedulerConfigPO>();
        for (SchedulerConfigPO schedulerConfigPO : profilePO.getSchedulerConfig()) {
            QueueSchedulerConfigPO queueSchedulerConfigPO = new QueueSchedulerConfigPO();
            queueSchedulerConfigPO.setQueue(schedulerConfigPO.getQueue());
            queueSchedulerConfigPO.setType(schedulerConfigPO.getType());
            queueSchedulerConfigPO.setWeight(schedulerConfigPO.getWeight());
            mapping.add(queueSchedulerConfigPO);
        }
        queueSchedulerMappingPO.setMapping(mapping);
        return this.queueSchedulerMaintMongoRepository.a(queueSchedulerMappingPO);
    }

    private String buildAndSaveDot1pQueue(String omadacId, String siteId, QueueMappingAndSchedulerProfilePO profilePO) {
        if (Objects.isNull(profilePO)) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)profilePO.getPriorityQueue())) {
            return null;
        }
        Dot1pQueueMappingPO dot1pQueueMappingPO = new Dot1pQueueMappingPO();
        dot1pQueueMappingPO.setBuildIn(false);
        dot1pQueueMappingPO.setOmadacId(omadacId);
        dot1pQueueMappingPO.setSiteId(siteId);
        dot1pQueueMappingPO.setId(this.dot1pQueueMappingMaintMongoRepository.b());
        dot1pQueueMappingPO.setName(profilePO.getName() + "_2Dot1p");
        dot1pQueueMappingPO.setMapping(profilePO.getPriorityQueue());
        return this.dot1pQueueMappingMaintMongoRepository.a(dot1pQueueMappingPO);
    }

    private String buildAndSaveDscpDot1p(String omadacId, String siteId, CosBasicSettingPO qosConfig) {
        DscpDot1pMappingPO dscpDot1pMappingPO = new DscpDot1pMappingPO();
        dscpDot1pMappingPO.setOmadacId(omadacId);
        dscpDot1pMappingPO.setSiteId(siteId);
        dscpDot1pMappingPO.setBuildIn(false);
        dscpDot1pMappingPO.setName(qosConfig.getName() + "_2dscp");
        dscpDot1pMappingPO.setMapping(qosConfig.getDscpPriority());
        dscpDot1pMappingPO.setId(this.dscpDot1pMappingMaintMongoRepository.b());
        if (!CollectionUtils.isEmpty((Collection)dscpDot1pMappingPO.getMapping())) {
            return this.dscpDot1pMappingMaintMongoRepository.a(dscpDot1pMappingPO);
        }
        return this.dscpDot1pMappingMaintMongoRepository.b(omadacId, siteId).map(DscpDot1pMappingPO::getId).orElse(null);
    }

    private void handleDeviceSelfConfig(String omadacId, String siteId, Map<String, OswPO> macOswMap, Map<String, OswStackPO> idStackMap, Map<String, List<String>> profileIdTransMap, List<CosBasicSettingPO> cosBasicSettingPOS) {
        Map<String, CosBasicSettingPO> macQosConfigMap = cosBasicSettingPOS.stream().filter(qosConfig -> !Boolean.TRUE.equals(qosConfig.getStack())).collect(Collectors.toMap(CosBasicSettingPO::getMac, o2 -> o2, (a2, b2) -> a2));
        Map<String, CosBasicSettingPO> stackIdQosConfigMap = cosBasicSettingPOS.stream().filter(qosConfig -> Boolean.TRUE.equals(qosConfig.getStack()) && Objects.nonNull(qosConfig.getStackId())).collect(Collectors.toMap(CosBasicSettingPO::getStackId, o2 -> o2, (a2, b2) -> a2));
        List oswPOList = this.oswMaintMongoRepository.a(omadacId, siteId, DeviceTypeEnum.c.b());
        if (CollectionUtils.isEmpty((Collection)oswPOList)) {
            return;
        }
        oswPOList.removeIf(oswPO -> oswPO.getDevCap() == null || !Boolean.TRUE.equals(oswPO.getDevCap().getQosSupport()));
        Optional dscpDot1pMappingOpt = this.dscpDot1pMappingMaintMongoRepository.b(omadacId, siteId);
        Optional dot1pQueueMappingOpt = this.dot1pQueueMappingMaintMongoRepository.b(omadacId, siteId);
        Optional queueSchedulerMappingOpt = this.queueSchedulerMaintMongoRepository.b(omadacId, siteId);
        for (OswPO osw : oswPOList) {
            OswStackPO oswStackPO;
            OswQosConfigPO qosConfig2;
            OswQosConfigPO defaultQosConfig = new OswQosConfigPO();
            dscpDot1pMappingOpt.ifPresent(dscpDot1pMappingPO -> defaultQosConfig.setDscpDot1pMappingId(dscpDot1pMappingPO.getId()));
            dot1pQueueMappingOpt.ifPresent(dot1pQueueMappingPO -> defaultQosConfig.setDot1pQueueMappingId(dot1pQueueMappingPO.getId()));
            queueSchedulerMappingOpt.ifPresent(queueSchedulerMappingPO -> defaultQosConfig.setQueueSchedulerMappingId(queueSchedulerMappingPO.getId()));
            if (!macQosConfigMap.containsKey(osw.getMac()) && Objects.isNull(osw.getStackId())) {
                osw.setQosConfig(defaultQosConfig);
                this.oswMaintMongoRepository.a(osw);
                continue;
            }
            if (macQosConfigMap.containsKey(osw.getMac()) && Objects.isNull(osw.getStackId())) {
                qosConfig2 = new OswQosConfigPO();
                if (macQosConfigMap.containsKey(osw.getMac()) && profileIdTransMap.containsKey(macQosConfigMap.get(osw.getMac()).getProfileId())) {
                    qosConfig2.setDot1pQueueMappingId(profileIdTransMap.get(macQosConfigMap.get(osw.getMac()).getProfileId()).get(0));
                    qosConfig2.setQueueSchedulerMappingId(profileIdTransMap.get(macQosConfigMap.get(osw.getMac()).getProfileId()).get(1));
                }
                String dscpDot1pId = this.buildAndSaveDscpDot1p(omadacId, siteId, macQosConfigMap.get(osw.getMac()));
                qosConfig2.setDscpDot1pMappingId(dscpDot1pId);
                osw.setQosConfig(qosConfig2);
                this.oswMaintMongoRepository.a(osw);
                continue;
            }
            if (Objects.nonNull(osw.getStackId()) && !stackIdQosConfigMap.containsKey(osw.getStackId()) && Objects.nonNull(oswStackPO = this.oswStackMaintMongoRepository.c(omadacId, osw.getStackId())) && Objects.isNull(oswStackPO.getStackSetting().getQosConfig())) {
                oswStackPO.getStackSetting().setQosConfig(defaultQosConfig);
                this.oswStackMaintMongoRepository.a(oswStackPO);
            }
            if (Objects.nonNull(osw.getStackId()) && stackIdQosConfigMap.containsKey(osw.getStackId())) {
                qosConfig2 = new OswQosConfigPO();
                OswStackPO oswStackPO2 = idStackMap.get(osw.getStackId());
                if (oswStackPO2 == null) continue;
                if (Objects.isNull(oswStackPO2.getStackSetting().getQosConfig())) {
                    if (stackIdQosConfigMap.containsKey(osw.getStackId()) && profileIdTransMap.containsKey(stackIdQosConfigMap.get(osw.getStackId()).getProfileId())) {
                        qosConfig2.setDot1pQueueMappingId(profileIdTransMap.get(stackIdQosConfigMap.get(osw.getStackId()).getProfileId()).get(0));
                        qosConfig2.setQueueSchedulerMappingId(profileIdTransMap.get(stackIdQosConfigMap.get(osw.getStackId()).getProfileId()).get(1));
                    }
                    String dscpDot1pId = this.buildAndSaveDscpDot1p(omadacId, siteId, stackIdQosConfigMap.get(osw.getStackId()));
                    qosConfig2.setDscpDot1pMappingId(dscpDot1pId);
                    oswStackPO2.getStackSetting().setQosConfig(qosConfig2);
                    this.oswStackMaintMongoRepository.a(oswStackPO2);
                }
            }
            osw.setQosConfig(defaultQosConfig);
            this.oswMaintMongoRepository.a(osw);
        }
    }

    private void handleDefaultProfile(String omadacId, String siteId) {
        boolean queueSchedulerExisted;
        boolean dot1pQueueExisted;
        boolean dscpDot1pExisted = this.dscpDot1pMappingMaintMongoRepository.a(omadacId, siteId);
        if (!dscpDot1pExisted) {
            this.buildAndSaveDefaultDscpDot1p(omadacId, siteId);
        }
        if (!(dot1pQueueExisted = this.dot1pQueueMappingMaintMongoRepository.a(omadacId, siteId))) {
            this.buildAndSaveDefaultDot1pQueue(omadacId, siteId);
        }
        if (!(queueSchedulerExisted = this.queueSchedulerMaintMongoRepository.a(omadacId, siteId))) {
            this.buildAndSaveDefaultQueueScheduler(omadacId, siteId);
        }
    }

    private void handleOswPortAndLag(String omadacId, String siteId, Map<String, OswPO> macOswMap, Map<String, OswStackPO> idStackMap, List<CosBasicSettingPO> cosBasicSettingPOS) {
        for (CosBasicSettingPO cosBasicSettingPO : cosBasicSettingPOS) {
            HashMap<String, List<OswPortPO>> macPortMap = new HashMap<String, List<OswPortPO>>();
            HashMap<String, List<OswLagPO>> macLagMap = new HashMap<String, List<OswLagPO>>();
            HashMap<String, List<OswLagPO>> stackIdLagMap = new HashMap<String, List<OswLagPO>>();
            this.fillPortLagMap(omadacId, siteId, macPortMap, macLagMap, stackIdLagMap, cosBasicSettingPO, idStackMap);
            if (!CollectionUtils.isEmpty(macOswMap.keySet())) {
                ArrayList oswPorts = new ArrayList();
                for (Map.Entry entry : macPortMap.entrySet()) {
                    oswPorts.addAll((Collection)entry.getValue());
                }
                this.oswPortMaintMongoRepository.a(oswPorts);
            }
            ArrayList oswLags = new ArrayList();
            if (!CollectionUtils.isEmpty(macLagMap.keySet())) {
                for (Map.Entry entry : macLagMap.entrySet()) {
                    oswLags.addAll((Collection)entry.getValue());
                }
            }
            if (!CollectionUtils.isEmpty(stackIdLagMap.keySet())) {
                for (Map.Entry entry : stackIdLagMap.entrySet()) {
                    oswLags.addAll((Collection)entry.getValue());
                }
            }
            if (CollectionUtils.isEmpty(oswLags)) continue;
            this.oswLagMaintMongoRepository.a(oswLags);
        }
    }

    private void fillPortLagMap(String omadacId, String siteId, Map<String, List<OswPortPO>> macPortMap, Map<String, List<OswLagPO>> macLagMap, Map<String, List<OswLagPO>> stackIdLagMap, CosBasicSettingPO cosBasicSettingPO, Map<String, OswStackPO> idStackMap) {
        if (Objects.isNull(cosBasicSettingPO.getStackId())) {
            List portPriority;
            List oswPortPOList = this.oswPortMaintMongoRepository.b(omadacId, cosBasicSettingPO.getMac()).stream().sorted(Comparator.comparing(BaseOswPortPO::getPort)).collect(Collectors.toList());
            List oswLagPOList = this.oswLagMaintMongoRepository.b(omadacId, cosBasicSettingPO.getMac()).stream().sorted(Comparator.comparing(BaseOswLagPO::getLag)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)cosBasicSettingPO.getMembers()) && Objects.equals(cosBasicSettingPO.getMac(), ((CosBasicSettingDevicePO)cosBasicSettingPO.getMembers().get(0)).getMac()) && !CollectionUtils.isEmpty((Collection)(portPriority = ((CosBasicSettingDevicePO)cosBasicSettingPO.getMembers().get(0)).getPortPriority()))) {
                for (PortPriorityConfigPO portConfigPO : portPriority) {
                    OswLagPO oswLagPO;
                    OswPortPO oswPortPO;
                    OswPortPO oswPortPO2 = oswPortPO = portConfigPO.getPort() - 1 > oswPortPOList.size() ? null : (OswPortPO)oswPortPOList.get(portConfigPO.getPort() - 1);
                    if (!(!Objects.nonNull(oswPortPO) || Objects.equals(portConfigPO.getMode(), UNTRUST) && Objects.equals(portConfigPO.getPriority(), DOT1P_PRIORITY))) {
                        oswPortPO.setTrustMode(portConfigPO.getMode());
                        oswPortPO.setDot1pPriority(portConfigPO.getPriority());
                        oswPortPO.setProfileOverrideEnable(Boolean.valueOf(true));
                    }
                    if (!Boolean.TRUE.equals(portConfigPO.getLag()) || !Objects.nonNull(oswLagPO = (OswLagPO)oswLagPOList.get(portConfigPO.getLagId() - 1)) || Objects.equals(portConfigPO.getMode(), UNTRUST) && Objects.equals(portConfigPO.getPriority(), DOT1P_PRIORITY)) continue;
                    oswLagPO.setTrustMode(portConfigPO.getMode());
                    oswLagPO.setDot1pPriority(portConfigPO.getPriority());
                    oswLagPO.setProfileOverrideEnable(Boolean.valueOf(true));
                }
            }
            oswLagPOList.removeIf(oswLag -> CollectionUtils.isEmpty((Collection)oswLag.getPorts()));
            macPortMap.put(cosBasicSettingPO.getMac(), oswPortPOList);
            macLagMap.put(cosBasicSettingPO.getMac(), oswLagPOList);
        } else {
            OswStackPO oswStackPO = idStackMap.get(cosBasicSettingPO.getStackId());
            if (Objects.isNull(oswStackPO)) {
                return;
            }
            List members = oswStackPO.getMembers().stream().map(OswStackMemberPO::getMac).collect(Collectors.toList());
            Map<String, CosBasicSettingDevicePO> macQosConfigMap = cosBasicSettingPO.getMembers().stream().collect(Collectors.toMap(CosBasicSettingDevicePO::getMac, o2 -> o2, (a2, b2) -> a2));
            if (members.size() != macQosConfigMap.size()) {
                log.warn("find invalid stack switch qos config when db is upgrading. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
                return;
            }
            List oswPortPOList = this.oswPortMaintMongoRepository.a(omadacId, members);
            List oswLagPOList = this.oswLagMaintMongoRepository.d(omadacId, oswStackPO.getStackId()).stream().sorted(Comparator.comparing(BaseOswLagPO::getLag)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)oswPortPOList)) {
                for (OswPortPO oswPortPO : oswPortPOList) {
                    OswLagPO oswLagPO;
                    String mac = oswPortPO.getOswMac();
                    if (!macQosConfigMap.containsKey(mac)) {
                        log.warn("find invalid stack switch qos config when db is upgrading. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
                        return;
                    }
                    CosBasicSettingDevicePO cosBasicSettingDevicePO = macQosConfigMap.get(mac);
                    PortPriorityConfigPO portPriorityConfigPO = (PortPriorityConfigPO)cosBasicSettingDevicePO.getPortPriority().get(oswPortPO.getPort() - 1);
                    if (!Objects.equals(portPriorityConfigPO.getPriority(), DOT1P_PRIORITY) || !Objects.equals(portPriorityConfigPO.getMode(), UNTRUST)) {
                        oswPortPO.setDot1pPriority(portPriorityConfigPO.getPriority());
                        oswPortPO.setTrustMode(portPriorityConfigPO.getMode());
                        oswPortPO.setProfileOverrideEnable(Boolean.valueOf(true));
                    }
                    if (macPortMap.containsKey(oswPortPO.getOswMac())) {
                        macPortMap.get(oswPortPO.getOswMac()).add(oswPortPO);
                    } else {
                        ArrayList<OswPortPO> tempList = new ArrayList<OswPortPO>();
                        tempList.add(oswPortPO);
                        macPortMap.put(oswPortPO.getOswMac(), tempList);
                    }
                    if (!Boolean.TRUE.equals(portPriorityConfigPO.getLag()) || CollectionUtils.isEmpty((Collection)(oswLagPO = (OswLagPO)oswLagPOList.get(portPriorityConfigPO.getLagId() - 1)).getStandardOswPortIndexes())) continue;
                    if (!Objects.equals(portPriorityConfigPO.getMode(), UNTRUST) || !Objects.equals(portPriorityConfigPO.getPriority(), DOT1P_PRIORITY)) {
                        oswLagPO.setTrustMode(portPriorityConfigPO.getMode());
                        oswLagPO.setDot1pPriority(portPriorityConfigPO.getPriority());
                        oswLagPO.setProfileOverrideEnable(Boolean.valueOf(true));
                    }
                    if (stackIdLagMap.containsKey(oswLagPO.getStackId())) {
                        stackIdLagMap.get(oswLagPO.getStackId()).add(oswLagPO);
                        continue;
                    }
                    ArrayList<OswLagPO> tempList = new ArrayList<OswLagPO>();
                    tempList.add(oswLagPO);
                    stackIdLagMap.put(oswLagPO.getStackId(), tempList);
                }
            }
        }
    }

    private void buildAndSaveDefaultQueueScheduler(String omadacId, String siteId) {
        QueueSchedulerMappingPO queueSchedulerMapping = new QueueSchedulerMappingPO();
        queueSchedulerMapping.setId(this.queueSchedulerMaintMongoRepository.b());
        queueSchedulerMapping.setOmadacId(omadacId);
        queueSchedulerMapping.setSiteId(siteId);
        queueSchedulerMapping.setName(DEFAULT);
        queueSchedulerMapping.setBuildIn(true);
        ArrayList<QueueSchedulerConfigPO> mapping = new ArrayList<QueueSchedulerConfigPO>();
        for (int index = 0; index <= 7; ++index) {
            QueueSchedulerConfigPO queueScheduleConfig = new QueueSchedulerConfigPO();
            queueScheduleConfig.setQueue(Integer.valueOf(index));
            queueScheduleConfig.setType(PROFILE_TYPE_WRR);
            queueScheduleConfig.setWeight(Integer.valueOf(1));
            mapping.add(queueScheduleConfig);
        }
        queueSchedulerMapping.setMapping(mapping);
        this.queueSchedulerMaintMongoRepository.a(queueSchedulerMapping);
    }

    private void buildAndSaveDefaultDot1pQueue(String omadacId, String siteId) {
        Dot1pQueueMappingPO dot1pQueueMapping = new Dot1pQueueMappingPO();
        dot1pQueueMapping.setId(this.dot1pQueueMappingMaintMongoRepository.b());
        dot1pQueueMapping.setOmadacId(omadacId);
        dot1pQueueMapping.setSiteId(siteId);
        dot1pQueueMapping.setName(DEFAULT);
        dot1pQueueMapping.setBuildIn(true);
        ArrayList<PriorityQueuePO> mapping = new ArrayList<PriorityQueuePO>();
        for (int index = 0; index <= 7; ++index) {
            PriorityQueuePO priorityQueue = new PriorityQueuePO();
            priorityQueue.setPriority(Integer.valueOf(index));
            priorityQueue.setQueue(Integer.valueOf(index));
            priorityQueue.setRemap(Integer.valueOf(index));
            mapping.add(priorityQueue);
        }
        ((PriorityQueuePO)mapping.get(0)).setQueue(Integer.valueOf(1));
        ((PriorityQueuePO)mapping.get(1)).setQueue(Integer.valueOf(0));
        dot1pQueueMapping.setMapping(mapping);
        this.dot1pQueueMappingMaintMongoRepository.a(dot1pQueueMapping);
    }

    private void buildAndSaveDefaultDscpDot1p(String omadacId, String siteId) {
        DscpDot1pMappingPO dscpDot1pMapping = new DscpDot1pMappingPO();
        dscpDot1pMapping.setId(this.dscpDot1pMappingMaintMongoRepository.b());
        dscpDot1pMapping.setOmadacId(omadacId);
        dscpDot1pMapping.setSiteId(siteId);
        dscpDot1pMapping.setName(DEFAULT);
        dscpDot1pMapping.setBuildIn(true);
        ArrayList<DscpPriorityConfigPO> mapping = new ArrayList<DscpPriorityConfigPO>();
        for (int index = 0; index < 64; ++index) {
            DscpPriorityConfigPO tempConfig = new DscpPriorityConfigPO();
            tempConfig.setDscpPriority(Integer.valueOf(index));
            tempConfig.setPriority(Integer.valueOf(index / 8));
            tempConfig.setRemap(Integer.valueOf(index));
            mapping.add(tempConfig);
        }
        dscpDot1pMapping.setMapping(mapping);
        this.dscpDot1pMappingMaintMongoRepository.a(dscpDot1pMapping);
    }
}

