/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.sim;

import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.SimSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.SimSettingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.quota.SimQuotaSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.sms.setting.SimSmsSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.sms.setting.routercommand.AccessItemPO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51522TOV51524)
@b(a=e.V1000010022TOV1000010024)
public class CallingCodeCompatible51522TO51524
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallingCodeCompatible51522TO51524.class);
    private final a simSettingMaintMongoRepository = a.a();
    private final g siteMaintMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b siteTemplateMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b.a();
    private static final CallingCodeCompatible51522TO51524 instance = new CallingCodeCompatible51522TO51524();
    private static final String BEFORE_COUNTRY_CODE_GL = "GL";
    private static final String AFTER_COUNTRY_CODE_DK = "DK";
    private static final String BEFORE_COUNTRY_CODE_UK = "UK";
    private static final String AFTER_COUNTRY_CODE_GB = "GB";

    private CallingCodeCompatible51522TO51524() {
    }

    public static CallingCodeCompatible51522TO51524 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("CallingCodeCompatible v5.15.22 to 5.15.24.");
        try {
            this.handleSimSettingCompatible(omadacId);
            this.handleSimSettingTemplateCompatible(omadacId);
        }
        catch (Exception e2) {
            log.warn("CallingCodeCompatible v5.15.22 to 5.15.24 do db compatible error.", (Throwable)e2);
        }
    }

    private void handleSimSettingCompatible(String omadacIdStr) {
        c omadacId = new c(omadacIdStr);
        Set siteIds = this.siteMaintMongoRepository.b(omadacId);
        for (String site : siteIds) {
            SimSettingPO simSettingPO = this.simSettingMaintMongoRepository.a(omadacId, new com.tplink.smb.omada.maintenance.common.b.a.a.d(site));
            if (simSettingPO == null) continue;
            boolean accessItem = this.handleAccessItemCompatible(simSettingPO.getSmsSetting());
            boolean dataSim1 = this.handleQuotaDataCompatible(simSettingPO.getQuotaSetting());
            boolean dataSim2 = this.handleQuotaDataCompatible(simSettingPO.getSim2QuotaSetting());
            boolean messageSim1 = this.handleQuotaMessageCompatible(simSettingPO.getQuotaSetting());
            boolean messageSim2 = this.handleQuotaMessageCompatible(simSettingPO.getSim2QuotaSetting());
            if (!accessItem && !dataSim1 && !dataSim2 && !messageSim1 && !messageSim2) continue;
            this.simSettingMaintMongoRepository.b(simSettingPO);
        }
    }

    private boolean handleAccessItemCompatible(SimSmsSettingPO simSmsSettingPO) {
        boolean change = false;
        if (simSmsSettingPO != null && simSmsSettingPO.getRouterCommand() != null && simSmsSettingPO.getRouterCommand().getAccess() != null && !CollectionUtils.isEmpty((Collection)simSmsSettingPO.getRouterCommand().getAccess().getAccesses())) {
            List accesses = simSmsSettingPO.getRouterCommand().getAccess().getAccesses();
            for (AccessItemPO access : accesses) {
                if (Objects.equals(BEFORE_COUNTRY_CODE_GL, access.getCountryCode())) {
                    change = true;
                    access.setCountryCode(AFTER_COUNTRY_CODE_DK);
                    continue;
                }
                if (!Objects.equals(BEFORE_COUNTRY_CODE_UK, access.getCountryCode())) continue;
                change = true;
                access.setCountryCode(AFTER_COUNTRY_CODE_GB);
            }
        }
        return change;
    }

    private boolean handleQuotaDataCompatible(SimQuotaSettingPO simQuotaSettingPO) {
        if (simQuotaSettingPO != null && simQuotaSettingPO.getDataSetting() != null) {
            if (Objects.equals(BEFORE_COUNTRY_CODE_GL, simQuotaSettingPO.getDataSetting().getCountryCode())) {
                simQuotaSettingPO.getDataSetting().setCountryCode(AFTER_COUNTRY_CODE_DK);
                return true;
            }
            if (Objects.equals(BEFORE_COUNTRY_CODE_UK, simQuotaSettingPO.getDataSetting().getCountryCode())) {
                simQuotaSettingPO.getDataSetting().setCountryCode(AFTER_COUNTRY_CODE_GB);
                return true;
            }
        }
        return false;
    }

    private boolean handleQuotaMessageCompatible(SimQuotaSettingPO simQuotaSettingPO) {
        if (simQuotaSettingPO != null && simQuotaSettingPO.getSmsSetting() != null) {
            if (Objects.equals(BEFORE_COUNTRY_CODE_GL, simQuotaSettingPO.getSmsSetting().getCountryCode())) {
                simQuotaSettingPO.getSmsSetting().setCountryCode(AFTER_COUNTRY_CODE_DK);
                return true;
            }
            if (Objects.equals(BEFORE_COUNTRY_CODE_UK, simQuotaSettingPO.getSmsSetting().getCountryCode())) {
                simQuotaSettingPO.getSmsSetting().setCountryCode(AFTER_COUNTRY_CODE_GB);
                return true;
            }
        }
        return false;
    }

    private void handleSimSettingTemplateCompatible(String omadacIdStr) {
        c omadacId = new c(omadacIdStr);
        Set siteIds = this.siteTemplateMaintMongoRepository.b(omadacId);
        for (String site : siteIds) {
            SimSettingTemplatePO simSettingPO = this.simSettingMaintMongoRepository.c(omadacId, new com.tplink.smb.omada.maintenance.common.b.a.a.d(site));
            if (simSettingPO == null) continue;
            boolean accessItem = this.handleAccessItemCompatible(simSettingPO.getSmsSetting());
            boolean dataSim1 = this.handleQuotaDataCompatible(simSettingPO.getQuotaSetting());
            boolean dataSim2 = this.handleQuotaDataCompatible(simSettingPO.getSim2QuotaSetting());
            boolean messageSim1 = this.handleQuotaMessageCompatible(simSettingPO.getQuotaSetting());
            boolean messageSim2 = this.handleQuotaMessageCompatible(simSettingPO.getSim2QuotaSetting());
            if (!accessItem && !dataSim1 && !dataSim2 && !messageSim1 && !messageSim2) continue;
            this.simSettingMaintMongoRepository.a(simSettingPO);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }
}

