/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.schedule;

import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.P;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.config.SchedulerCustomProperties;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.BaseSiteSchedulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.poeschedule.PortPoeSchedulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.rebootschedule.RebootSchedulePO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51330TOV51400)
@b(a=e.V1000008001TOV1000009000)
public class ServiceScheduleTaskV51300ToV51400
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceScheduleTaskV51300ToV51400.class);
    public static final String REBOOT_TASK_NAME = "manager_reboot";
    public static final String PORT_TASK_NAME = "manager_port";
    public static final String POE_TASK_NAME = "manager_poe";
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a serviceScheduleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a.a();
    private final ScheduleCenter scheduleCenter = (ScheduleCenter)a.b(ScheduleCenter.class);
    private final com.tplink.smb.omada.manager.configuration.api.internal.a dstInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.a)a.b(com.tplink.smb.omada.manager.configuration.api.internal.a.class);
    private final SchedulerCustomProperties schedulerCustomProperties = (SchedulerCustomProperties)a.b(SchedulerCustomProperties.class);
    private static final ServiceScheduleTaskV51300ToV51400 instance = new ServiceScheduleTaskV51300ToV51400();

    private ServiceScheduleTaskV51300ToV51400() {
    }

    public static ServiceScheduleTaskV51300ToV51400 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        try {
            List rebootSchedulePOS = this.serviceScheduleMaintMongoRepository.d(new c(omadacId));
            Map<String, List<RebootSchedulePO>> rebootScheSiteMap = rebootSchedulePOS.stream().collect(Collectors.groupingBy(BaseSiteSchedulePO::getSiteId));
            rebootScheSiteMap.forEach((siteId, rebootSchedulesInSite) -> {
                QuerySiteDTO querySiteDTO = new QuerySiteDTO();
                querySiteDTO.setOmadacId(omadacId);
                querySiteDTO.setSiteId(siteId);
                OperationResponse dstInfoDTOResp = this.dstInternalApiService.a(querySiteDTO);
                if (!dstInfoDTOResp.success()) {
                    log.warn("Failed to get dst info, omadacId: {}, siteId: {}", (Object)omadacId, siteId);
                    return;
                }
                DstInfoDTO dstInfoDTO = (DstInfoDTO)dstInfoDTOResp.getResult();
                rebootSchedulesInSite.forEach(rebootSchedulePO -> this.setParamAndRefreshScheduleTask((RebootSchedulePO)rebootSchedulePO, dstInfoDTO));
            });
            this.serviceScheduleMaintMongoRepository.a(rebootSchedulePOS);
            List portPoeSchedulePOS = this.serviceScheduleMaintMongoRepository.b(new c(omadacId));
            portPoeSchedulePOS.forEach(this::cancelOldPortPoeScheduleTask);
            this.handlePortStatusSchedule(omadacId);
        }
        catch (Exception e2) {
            log.error("ServiceScheduleTaskV51300ToV51400 dbCompatible failed, {}", (Object)omadacId, (Object)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void cancelOldPortPoeScheduleTask(PortPoeSchedulePO portPoeSchedulePO) {
        this.scheduleCenter.deleteTask(TaskKey.of((String)POE_TASK_NAME, (String)portPoeSchedulePO.getId()));
    }

    private void handlePortStatusSchedule(String omadacId) {
        List portStatusSchedulePOS = this.serviceScheduleMaintMongoRepository.g(new c(omadacId));
        if (CollectionUtils.isEmpty((Collection)portStatusSchedulePOS)) {
            return;
        }
        portStatusSchedulePOS.forEach(portStatusSchedule -> this.scheduleCenter.deleteTask(TaskKey.of((String)PORT_TASK_NAME, (String)portStatusSchedule.getId())));
    }

    private void setParamAndRefreshScheduleTask(RebootSchedulePO rebootSchedulePO, DstInfoDTO dstInfoDTO) {
        TimeZone timeZone = TimeZone.getTimeZone(P.a((String)rebootSchedulePO.getSchedule().getTimezoneId()));
        if (dstInfoDTO != null && dstInfoDTO.getStatus().booleanValue()) {
            timeZone.setRawOffset(timeZone.getRawOffset() + dstInfoDTO.getOffset().intValue());
        }
        rebootSchedulePO.setParam(timeZone.getRawOffset() + "_" + rebootSchedulePO.getSchedule().getScheduleCron());
        int partitionIndex = Math.abs(rebootSchedulePO.getId().hashCode() % this.schedulerCustomProperties.getShardingSizeOf(REBOOT_TASK_NAME));
        rebootSchedulePO.setPartitionIndex(Integer.valueOf(partitionIndex));
        this.scheduleCenter.deleteTask(TaskKey.of((String)REBOOT_TASK_NAME, (String)rebootSchedulePO.getId()));
    }
}

