/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.osw.port;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.common.concurrent.thread.CommonExecutorProperties;
import com.tplink.smb.omada.common.constant.SwitchTypeEnum;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.d.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.tag.BasePortTagPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.tag.PortTagPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.tag.PortTagTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.BaseLanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.BaseLanProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.LanProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.LanProfileTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.AbstractOswPortSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.BaseOswPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.BaseOswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.BaseOswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.q;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51524TOV60000)
@b(a=e.V1000010024TOV1200000000)
public class OswPortCompatibleV51524TOV60000
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswPortCompatibleV51524TOV60000.class);
    private static final String DISABLE_PROFILE_NAME = "Disable";
    private static final String DEFAULT_PROFILE_NAME = "Default";
    private static final String ALL_PROFILE_NAME = "All";
    private static final Integer DEFAULT_PROFILE_FLAG = 0;
    private static final Integer NATIVE_PROFILE_FLAG = 1;
    private static final Integer CUSTOM_PROFILE_FLAG = 2;
    private static final Integer ALLOW_ALL = 0;
    private static final Integer BLOCK_ALL = 1;
    private static final Integer CUSTOM = 2;
    public static final int MIN_THREAD_NUM = 1;
    public static final double THREAD_USAGE_RATE = 0.75;
    public static final int MIN_PORT_BATCH_SIZE = 500;
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.e oswMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.e.a();
    private final q oswPortMaintMongoRepository = q.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.a oswLagMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.a.a();
    private final g siteMaintMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e lanProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b siteTemplateMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.sitetemplate.b.a();
    private static final OswPortCompatibleV51524TOV60000 instance = new OswPortCompatibleV51524TOV60000();
    private a portTagMaintMongoRepository = a.a();
    private final ExecutorService commonExecutor = (ExecutorService)com.tplink.smb.omada.common.spring.a.a((String)"commThreadPool");
    private final CommonExecutorProperties commonExecutorProperties = (CommonExecutorProperties)com.tplink.smb.omada.common.spring.a.b(CommonExecutorProperties.class);

    private OswPortCompatibleV51524TOV60000() {
    }

    public static OswPortCompatibleV51524TOV60000 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        this.handleSiteOswPort(omadacId);
        this.handleSiteTemplateOswPort(omadacId);
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleSiteOswPort(String omadacId) {
        n type = n.a;
        Set siteIds = this.siteMaintMongoRepository.b(new c(omadacId));
        if (CollectionUtils.isEmpty((Collection)siteIds)) {
            return;
        }
        Set esMacs = this.oswMaintMongoRepository.b(new c(omadacId), type);
        Map macPoePortNumMap = this.oswMaintMongoRepository.c(new c(omadacId), type);
        Map<String, List<LanNetworkPO>> siteIdLanNetworkPOMap = this.lanNetworkMaintMongoRepository.b(new c(omadacId)).stream().collect(Collectors.groupingBy(LanNetworkPO::getSiteId));
        this.handleBatchSiteOswPort(omadacId, siteIds, esMacs, macPoePortNumMap, siteIdLanNetworkPOMap);
    }

    private void handleSiteTemplateOswPort(String omadacId) {
        n type = n.b;
        Set siteTemplateIds = this.siteTemplateMaintMongoRepository.b(new c(omadacId));
        if (CollectionUtils.isEmpty((Collection)siteTemplateIds)) {
            return;
        }
        Set esMacs = this.oswMaintMongoRepository.b(new c(omadacId), type);
        Map macPoePortNumMap = this.oswMaintMongoRepository.c(new c(omadacId), type);
        Map<String, List<LanNetworkTemplatePO>> siteIdLanNetworkTemplatePOMap = this.lanNetworkMaintMongoRepository.c(new c(omadacId)).stream().collect(Collectors.groupingBy(LanNetworkTemplatePO::getSiteTemplateId));
        this.handleBatchSiteTemplateOswPort(omadacId, siteTemplateIds, esMacs, macPoePortNumMap, siteIdLanNetworkTemplatePOMap);
    }

    private void handleBatchSiteOswPort(String omadacId, Set<String> siteIds, Set<String> esMacs, Map<String, Integer> macPoePortNumMap, Map<String, List<LanNetworkPO>> siteIdLanNetworkPOMap) {
        n type = n.a;
        for (String siteId : siteIds) {
            boolean isEsSwitch;
            LanProfilePO lanProfilePO2;
            boolean existOsw = this.oswMaintMongoRepository.b(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId));
            if (!existOsw) continue;
            List oswPortPOS = this.oswPortMaintMongoRepository.d(omadacId, siteId);
            List oswLagPOS = this.oswLagMaintMongoRepository.e(omadacId, siteId);
            if (CollectionUtils.isEmpty((Collection)oswPortPOS) && CollectionUtils.isEmpty((Collection)oswLagPOS)) continue;
            HashSet useProfileIds = new HashSet();
            oswPortPOS.forEach(oswPortPO -> useProfileIds.add(oswPortPO.getLanProfileId()));
            oswLagPOS.forEach(oswLagPO -> useProfileIds.add(oswLagPO.getLanProfileId()));
            Map<String, LanProfilePO> lanProfilePOMap = this.lanProfileMaintMongoRepository.a(new c(omadacId), siteId, useProfileIds).stream().collect(Collectors.toMap(BaseLanProfilePO::getId, lanProfilePO -> lanProfilePO));
            LanNetworkPO primaryLanNetworkPO = siteIdLanNetworkPOMap.get(siteId).stream().findFirst().orElse(null);
            List<BasePortTagPO> portTagPOS = this.createPortTagInSite(omadacId, siteId, type);
            Map<String, String> tagNameIdMap = portTagPOS.stream().collect(Collectors.toMap(BasePortTagPO::getName, BasePortTagPO::getId));
            for (OswPortPO portPO : oswPortPOS) {
                lanProfilePO2 = lanProfilePOMap.get(portPO.getLanProfileId());
                isEsSwitch = false;
                Integer oswPoePortNum = null;
                if (portPO.getOswMac() != null) {
                    isEsSwitch = esMacs.contains(portPO.getOswMac());
                    oswPoePortNum = macPoePortNumMap.get(portPO.getOswMac());
                }
                this.fillNetworkInOswPortAndLagPO((AbstractOswPortSettingPO)portPO, (BaseLanProfilePO)lanProfilePO2, isEsSwitch, (BaseLanNetworkPO)primaryLanNetworkPO);
                this.fillPortTag((AbstractOswPortSettingPO)portPO, (BaseLanProfilePO)lanProfilePO2, tagNameIdMap);
                this.fillSupportPoeInOswPortPO((BaseOswPortPO)portPO, oswPoePortNum);
            }
            for (OswLagPO lagPO : oswLagPOS) {
                lanProfilePO2 = lanProfilePOMap.get(lagPO.getLanProfileId());
                isEsSwitch = false;
                if (lagPO.getStackId() == null && lagPO.getOswMac() != null) {
                    isEsSwitch = esMacs.contains(lagPO.getOswMac());
                }
                this.fillNetworkInOswPortAndLagPO((AbstractOswPortSettingPO)lagPO, (BaseLanProfilePO)lanProfilePO2, isEsSwitch, (BaseLanNetworkPO)primaryLanNetworkPO);
                this.fillPortTag((AbstractOswPortSettingPO)lagPO, (BaseLanProfilePO)lanProfilePO2, tagNameIdMap);
            }
            this.savePortAndLag(new ArrayList<BaseOswPortPO>(oswPortPOS), new ArrayList<BaseOswLagPO>(oswLagPOS), type);
        }
    }

    private void handleBatchSiteTemplateOswPort(String omadacId, Set<String> siteTemplateIds, Set<String> esMacs, Map<String, Integer> macPoePortNumMap, Map<String, List<LanNetworkTemplatePO>> siteIdLanNetworkTemplatePOMap) {
        n type = n.b;
        if (CollectionUtils.isEmpty(siteTemplateIds)) {
            return;
        }
        for (String siteTemplateId : siteTemplateIds) {
            boolean isEsSwitch;
            LanProfileTemplatePO lanProfilePO2;
            boolean existOsw = this.oswMaintMongoRepository.b(new c(omadacId), siteTemplateId);
            if (!existOsw) continue;
            List oswPortPOS = this.oswPortMaintMongoRepository.a(new c(omadacId), siteTemplateId);
            List oswLagPOS = this.oswLagMaintMongoRepository.a(new c(omadacId), siteTemplateId);
            if (CollectionUtils.isEmpty((Collection)oswPortPOS) && CollectionUtils.isEmpty((Collection)oswLagPOS)) continue;
            HashSet useProfileIds = new HashSet();
            oswPortPOS.forEach(oswPortPO -> useProfileIds.add(oswPortPO.getLanProfileId()));
            oswLagPOS.forEach(oswLagPO -> useProfileIds.add(oswLagPO.getLanProfileId()));
            Map<String, LanProfileTemplatePO> lanProfilePOMap = this.lanProfileMaintMongoRepository.b(new c(omadacId), siteTemplateId, useProfileIds).stream().collect(Collectors.toMap(BaseLanProfilePO::getId, lanProfilePO -> lanProfilePO));
            LanNetworkTemplatePO primaryLanNetworkPO = siteIdLanNetworkTemplatePOMap.get(siteTemplateId).stream().findFirst().orElse(null);
            List<BasePortTagPO> portTagPOS = this.createPortTagInSite(omadacId, siteTemplateId, type);
            Map<String, String> tagNameIdMap = portTagPOS.stream().collect(Collectors.toMap(BasePortTagPO::getName, BasePortTagPO::getId));
            for (OswPortTemplatePO portPO : oswPortPOS) {
                lanProfilePO2 = lanProfilePOMap.get(portPO.getLanProfileId());
                isEsSwitch = false;
                Integer oswPoePortNum = null;
                if (portPO.getOswMac() != null) {
                    isEsSwitch = esMacs.contains(portPO.getOswMac());
                    oswPoePortNum = macPoePortNumMap.get(portPO.getOswMac());
                }
                this.fillNetworkInOswPortAndLagPO((AbstractOswPortSettingPO)portPO, (BaseLanProfilePO)lanProfilePO2, isEsSwitch, (BaseLanNetworkPO)primaryLanNetworkPO);
                this.fillPortTag((AbstractOswPortSettingPO)portPO, (BaseLanProfilePO)lanProfilePO2, tagNameIdMap);
                this.fillSupportPoeInOswPortPO((BaseOswPortPO)portPO, oswPoePortNum);
            }
            for (OswLagTemplatePO lagPO : oswLagPOS) {
                lanProfilePO2 = lanProfilePOMap.get(lagPO.getLanProfileId());
                isEsSwitch = false;
                if (lagPO.getStackId() == null && lagPO.getOswMac() != null) {
                    isEsSwitch = esMacs.contains(lagPO.getOswMac());
                }
                this.fillNetworkInOswPortAndLagPO((AbstractOswPortSettingPO)lagPO, (BaseLanProfilePO)lanProfilePO2, isEsSwitch, (BaseLanNetworkPO)primaryLanNetworkPO);
                this.fillPortTag((AbstractOswPortSettingPO)lagPO, (BaseLanProfilePO)lanProfilePO2, tagNameIdMap);
            }
            this.savePortAndLag(new ArrayList<BaseOswPortPO>(oswPortPOS), new ArrayList<BaseOswLagPO>(oswLagPOS), type);
        }
    }

    private void savePortAndLag(@Nonnull List<BaseOswPortPO> allPortPOS, @Nonnull List<BaseOswLagPO> allLagPOS, n type) {
        int threadNum = (int)Math.max((double)this.commonExecutorProperties.getCommCoreThreads() * 0.75, 1.0);
        int batchSize = Math.max((allPortPOS.size() + allLagPOS.size()) / threadNum, 500);
        ArrayList<CompletableFuture<Void>> saveFutures = new ArrayList<CompletableFuture<Void>>();
        List oswPortPOBatches = Lists.partition((List)Lists.newArrayList(allPortPOS), (int)batchSize);
        List oswLagPOBatches = Lists.partition((List)Lists.newArrayList(allLagPOS), (int)batchSize);
        for (List oswPortPOBatch : oswPortPOBatches) {
            if (CollectionUtils.isEmpty((Collection)oswPortPOBatch)) continue;
            saveFutures.add(CompletableFuture.runAsync(() -> this.oswPortMaintMongoRepository.a((Collection)oswPortPOBatch, type), this.commonExecutor));
        }
        for (List oswLagPOBatch : oswLagPOBatches) {
            if (CollectionUtils.isEmpty((Collection)oswLagPOBatch)) continue;
            saveFutures.add(CompletableFuture.runAsync(() -> this.oswLagMaintMongoRepository.a(oswLagPOBatch, type), this.commonExecutor));
        }
        saveFutures.forEach(CompletableFuture::join);
    }

    private boolean BaseOswPOIsEsSwitch(BaseOswPO baseOswPO) {
        if (baseOswPO.getStackId() != null) {
            return false;
        }
        return Objects.equals(SwitchTypeEnum.b.b(), baseOswPO.getDeviceMisc().getCategory());
    }

    private void fillSupportPoeInOswPortPO(BaseOswPortPO baseOswPortPO, Integer oswPoePortNum) {
        if (baseOswPortPO.getPortCap() == null) {
            return;
        }
        if (baseOswPortPO.getPortCap().getSupportPoe() == null) {
            int port = baseOswPortPO.getPort();
            if (oswPoePortNum != null) {
                baseOswPortPO.getPortCap().setSupportPoe(Integer.valueOf(oswPoePortNum >= port ? 1 : 0));
            } else {
                baseOswPortPO.getPortCap().setSupportPoe(Integer.valueOf(0));
            }
        }
    }

    private void fillNetworkInOswPortAndLagPO(AbstractOswPortSettingPO portSettingPO, BaseLanProfilePO lanProfilePO, boolean isEsSwitch, BaseLanNetworkPO primaryLanNetworkPO) {
        List untagNetworkIds;
        if (portSettingPO == null || lanProfilePO == null) {
            return;
        }
        if (Objects.equals(DEFAULT_PROFILE_FLAG, lanProfilePO.getFlag())) {
            if (Objects.equals(ALL_PROFILE_NAME, lanProfilePO.getName())) {
                this.fillNativeNetworkInPortAndLagPO(portSettingPO, lanProfilePO, primaryLanNetworkPO);
                if (isEsSwitch && lanProfilePO.getEsEnableTaggedNetworkIds() != null && Boolean.TRUE.equals(lanProfilePO.getEsTaggedModified())) {
                    portSettingPO.setNetworkTagsSetting(CUSTOM);
                    portSettingPO.setTagNetworkIds((List)Optional.ofNullable(lanProfilePO.getEsEnableTaggedNetworkIds()).map(ArrayList::new).orElse(new ArrayList()));
                    portSettingPO.setTagBridgeVlanMap((Map)Optional.ofNullable(lanProfilePO.getEsEnableTagBridgeVlanMap()).map(HashMap::new).orElse(new HashMap()));
                    portSettingPO.setUntagNetworkIds(new ArrayList());
                    portSettingPO.setUntagBridgeVlanMap(new HashMap());
                } else {
                    portSettingPO.setNetworkTagsSetting(ALLOW_ALL);
                }
                this.fillVoiceNetworkInPortAndLagPO(portSettingPO, lanProfilePO, isEsSwitch);
            } else {
                this.fillNativeNetworkInPortAndLagPO(portSettingPO, lanProfilePO, primaryLanNetworkPO);
                portSettingPO.setNetworkTagsSetting(BLOCK_ALL);
                this.fillVoiceNetworkInPortAndLagPO(portSettingPO, lanProfilePO, isEsSwitch);
            }
        } else if (Objects.equals(NATIVE_PROFILE_FLAG, lanProfilePO.getFlag())) {
            this.fillNativeNetworkInPortAndLagPO(portSettingPO, lanProfilePO, primaryLanNetworkPO);
            portSettingPO.setNetworkTagsSetting(BLOCK_ALL);
            this.fillVoiceNetworkInPortAndLagPO(portSettingPO, lanProfilePO, isEsSwitch);
        } else {
            this.fillNativeNetworkInPortAndLagPO(portSettingPO, lanProfilePO, primaryLanNetworkPO);
            portSettingPO.setNetworkTagsSetting(CUSTOM);
            portSettingPO.setTagNetworkIds((List)Optional.ofNullable(lanProfilePO.getTagNetworkIds()).map(ArrayList::new).orElse(new ArrayList()));
            portSettingPO.setTagBridgeVlanMap((Map)Optional.ofNullable(lanProfilePO.getTagBridgeVlanMap()).map(HashMap::new).orElse(new HashMap()));
            portSettingPO.setUntagNetworkIds((List)Optional.ofNullable(lanProfilePO.getUntagNetworkIds()).map(ArrayList::new).orElse(new ArrayList()));
            portSettingPO.setUntagBridgeVlanMap((Map)Optional.ofNullable(lanProfilePO.getUntagBridgeVlanMap()).map(HashMap::new).orElse(new HashMap()));
            this.fillVoiceNetworkInPortAndLagPO(portSettingPO, lanProfilePO, isEsSwitch);
        }
        if (Objects.equals(portSettingPO.getNetworkTagsSetting(), CUSTOM) && portSettingPO.getNativeNetworkId() != null && !(untagNetworkIds = (List)Optional.ofNullable(portSettingPO.getUntagNetworkIds()).orElse(new ArrayList())).contains(portSettingPO.getNativeNetworkId())) {
            untagNetworkIds.add(portSettingPO.getNativeNetworkId());
            portSettingPO.setUntagNetworkIds(untagNetworkIds);
            if (portSettingPO.getNativeBridgeVlan() != null) {
                Map untagBridgeVlanMap = Optional.ofNullable(portSettingPO.getUntagBridgeVlanMap()).orElse(new HashMap());
                Set birdgeVlanSet = untagBridgeVlanMap.getOrDefault(portSettingPO.getNativeNetworkId(), new HashSet());
                birdgeVlanSet.add(portSettingPO.getNativeBridgeVlan());
                untagBridgeVlanMap.put(portSettingPO.getNativeNetworkId(), birdgeVlanSet);
                portSettingPO.setUntagBridgeVlanMap(untagBridgeVlanMap);
            }
        }
    }

    private void fillNativeNetworkInPortAndLagPO(AbstractOswPortSettingPO portSettingPO, BaseLanProfilePO lanProfilePO, BaseLanNetworkPO primaryLanNetworkPO) {
        if (lanProfilePO.getNativeNetworkId() != null) {
            portSettingPO.setNativeNetworkId(lanProfilePO.getNativeNetworkId());
            portSettingPO.setNativeBridgeVlan(lanProfilePO.getNativeBridgeVlan());
        } else if (primaryLanNetworkPO != null) {
            portSettingPO.setNativeNetworkId(primaryLanNetworkPO.getId());
            portSettingPO.setNativeBridgeVlan(null);
        }
    }

    private void fillVoiceNetworkInPortAndLagPO(AbstractOswPortSettingPO portSettingPO, BaseLanProfilePO lanProfilePO, Boolean isEsSwitch) {
        if (!Boolean.TRUE.equals(isEsSwitch) && lanProfilePO.getVoiceNetworkId() != null) {
            portSettingPO.setVoiceNetworkEnable(Boolean.valueOf(true));
            portSettingPO.setVoiceNetworkId(lanProfilePO.getVoiceNetworkId());
            portSettingPO.setVoiceBridgeVlan(lanProfilePO.getVoiceBridgeVlan());
        } else {
            portSettingPO.setVoiceNetworkEnable(Boolean.valueOf(false));
            portSettingPO.setVoiceNetworkId(null);
            portSettingPO.setVoiceBridgeVlan(null);
        }
    }

    private List<BasePortTagPO> createPortTagInSite(String omadacId, String siteId, n type) {
        ArrayList<Object> savePortTagPOS = new ArrayList<Object>();
        List lanProfilePOS = this.lanProfileMaintMongoRepository.a(new c(omadacId), siteId, type);
        List existPortTagPOS = this.portTagMaintMongoRepository.b(omadacId, siteId, type);
        Set existPortTagNames = existPortTagPOS.stream().map(BasePortTagPO::getName).collect(Collectors.toSet());
        for (BaseLanProfilePO lanProfilePO : lanProfilePOS) {
            if (!Objects.equals(lanProfilePO.getFlag(), CUSTOM_PROFILE_FLAG) || existPortTagNames.contains(lanProfilePO.getName())) continue;
            if (n.a.equals((Object)type)) {
                PortTagPO portTagPO = new PortTagPO();
                portTagPO.setId(this.portTagMaintMongoRepository.b());
                portTagPO.setOmadacId(omadacId);
                portTagPO.setSiteId(siteId);
                portTagPO.setName(lanProfilePO.getName());
                savePortTagPOS.add(portTagPO);
            } else {
                PortTagTemplatePO portTagTemplatePO = new PortTagTemplatePO();
                portTagTemplatePO.setId(this.portTagMaintMongoRepository.b());
                portTagTemplatePO.setOmadacId(omadacId);
                portTagTemplatePO.setSiteTemplateId(siteId);
                portTagTemplatePO.setName(lanProfilePO.getName());
                savePortTagPOS.add(portTagTemplatePO);
            }
            existPortTagNames.add(lanProfilePO.getName());
        }
        this.portTagMaintMongoRepository.a(savePortTagPOS, type);
        existPortTagPOS.addAll(savePortTagPOS);
        return existPortTagPOS;
    }

    private void fillPortTag(AbstractOswPortSettingPO portSettingPO, BaseLanProfilePO lanProfilePO, Map<String, String> tagNameIdMap) {
        if (portSettingPO == null || lanProfilePO == null) {
            return;
        }
        if (!Objects.equals(CUSTOM_PROFILE_FLAG, lanProfilePO.getFlag())) {
            return;
        }
        if (lanProfilePO.getName() == null) {
            return;
        }
        Set tagSet = Optional.ofNullable(portSettingPO.getTagSet()).orElse(new HashSet());
        String tagId = tagNameIdMap.get(lanProfilePO.getName());
        if (tagId != null) {
            tagSet.add(tagId);
            portSettingPO.setTagSet(tagSet);
        }
    }
}

