/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.auth.radiusprofile;

import com.tplink.smb.omada.client.port.mongo.omada.RadiusServerMaintRepository;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.system.b;
import com.tplink.smb.omada.identityaccess.port.mongo.g;
import com.tplink.smb.omada.identityaccess.port.mongo.omadac.OmadacPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.radiusserver.RadiusServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.embed.RadiusAuthServerPO;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51000TOV51100)
public class RadiusProfileCompatibleV51000TOV51100
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RadiusProfileCompatibleV51000TOV51100.class);
    private static final RadiusProfileCompatibleV51000TOV51100 instance = new RadiusProfileCompatibleV51000TOV51100();
    private final AuthenticationMaintRepository authenticationMaintRepository = AuthenticationMaintRepository.getInstance();
    private final RadiusServerMaintRepository radiusServerMaintRepository = RadiusServerMaintRepository.getInstance();
    private final g omadacMaintMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.configuration.api.internal.omadac.c radiusServerInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.omadac.c)a.b(com.tplink.smb.omada.manager.configuration.api.internal.omadac.c.class);
    private static final Integer DEFAULT_AUTH_PORT = 1812;
    private static final Integer DEFAULT_ACCT_PORT = 1813;
    private static final Integer DEFAULT_ACCT_INTERVAL = 600;
    private static final String DEFAULT_OMADAC_ID = "Default";
    private static final String DEFAULT_SITE_ID = "Default";

    private RadiusProfileCompatibleV51000TOV51100() {
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        Optional omadac = this.omadacMaintMongoRepository.a(new c(omadacId));
        if (!omadac.isPresent()) {
            return;
        }
        if (Objects.equals(((OmadacPO)omadac.get()).getPattern(), com.tplink.smb.omada.common.f.c.a.a())) {
            return;
        }
        if (Objects.equals(((OmadacPO)omadac.get()).getPattern(), com.tplink.smb.omada.common.f.c.b.a())) {
            this.handleMspOmadac((OmadacPO)omadac.get());
        } else {
            this.handleStandardOmadac(new c(omadacId));
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void handleMspOmadac(OmadacPO msp) {
        RadiusServerPO radiusServerPO = this.radiusServerMaintRepository.findByOmadacId(new c(msp.getId())).orElseGet(() -> {
            RadiusServerPO defaultServer = this.buildDefaultServer(new c(msp.getId()));
            this.radiusServerMaintRepository.save(defaultServer);
            return defaultServer;
        });
        if (this.authenticationMaintRepository.builtInProfileExist()) {
            return;
        }
        if (this.radiusServerInternalApiService.b()) {
            RadiusProfilePO radiusProfilePO = this.buildRadiusProfileFromRadiusServer(radiusServerPO);
            this.authenticationMaintRepository.save(radiusProfilePO);
        }
    }

    private void handleStandardOmadac(c omadacId) {
        RadiusServerPO radiusServerPO = this.radiusServerMaintRepository.findByOmadacId(omadacId).orElseGet(() -> {
            RadiusServerPO defaultServer = this.buildDefaultServer(omadacId);
            this.radiusServerMaintRepository.save(defaultServer);
            return defaultServer;
        });
        if (this.authenticationMaintRepository.builtInProfileExist()) {
            return;
        }
        RadiusProfilePO radiusProfilePO = this.buildRadiusProfileFromRadiusServer(radiusServerPO);
        this.authenticationMaintRepository.save(radiusProfilePO);
    }

    private RadiusProfilePO buildRadiusProfileFromRadiusServer(RadiusServerPO radiusServerPO) {
        List hosts;
        String hostIp = Objects.equals(radiusServerPO.getServerAddressType(), 1) ? radiusServerPO.getCustomAddress() : (CollectionUtils.isEmpty((Collection)(hosts = b.d())) ? "0.0.0.0" : (String)hosts.get(0));
        RadiusAuthServerPO radiusAuthServer = new RadiusAuthServerPO();
        radiusAuthServer.setRadiusPort(radiusServerPO.getAuthPort());
        radiusAuthServer.setRadiusPwd(radiusServerPO.getSecret());
        radiusAuthServer.setRadiusServerIp(hostIp);
        RadiusProfilePO radiusProfilePO = new RadiusProfilePO();
        radiusProfilePO.setOmadacId("Default");
        radiusProfilePO.setSiteId("Default");
        radiusProfilePO.setBuiltInServer(Boolean.valueOf(true));
        radiusProfilePO.setBuiltInServerSecret(radiusServerPO.getSecret());
        radiusProfilePO.setTunnelReplyEnable(radiusServerPO.getTunnelReplyEnable());
        radiusProfilePO.setWirelessVlanAssignment(radiusServerPO.getTunnelReplyEnable());
        radiusProfilePO.setServerEnable(Boolean.valueOf(Boolean.TRUE.equals(radiusServerPO.getEnable())));
        radiusProfilePO.setName("Built-in Radius Profile");
        radiusProfilePO.setAuthServer(Collections.singletonList(radiusAuthServer));
        radiusProfilePO.setRadiusAccountingEnable(Boolean.valueOf(false));
        radiusProfilePO.setInterimUpdateEnable(Boolean.valueOf(false));
        radiusProfilePO.setInterimUpdateInterval(null);
        radiusProfilePO.setAcctServer(null);
        radiusProfilePO.setCoaEnable(Boolean.valueOf(false));
        radiusProfilePO.setIpType(radiusServerPO.getServerAddressType());
        return radiusProfilePO;
    }

    private RadiusServerPO buildDefaultServer(@Nonnull c omadacId) {
        RadiusServerPO radiusServerPO = new RadiusServerPO();
        radiusServerPO.setOmadacId(omadacId.a());
        radiusServerPO.setEnable(Boolean.valueOf(false));
        radiusServerPO.setAuthPort(DEFAULT_AUTH_PORT);
        radiusServerPO.setTunnelReplyEnable(Boolean.valueOf(false));
        return radiusServerPO;
    }

    @Generated
    public static RadiusProfileCompatibleV51000TOV51100 getInstance() {
        return instance;
    }
}

