/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.auth.freeauthpolicy;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.maintenance.compatible.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.service.impl.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import com.tplink.smb.omada.portal.port.mongo.omada.freeauthpolicy.FreeAuthPolicyPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalMaintRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@c(a=f.V51200TOV51300)
public class FAPCompatibleV51200ToV51300
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FAPCompatibleV51200ToV51300.class);
    public static final int RETRY_GEN_ENTRY_ID_LIMIT = 5;
    private final a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private final PortalMaintRepository portalMaintRepository = PortalMaintRepository.getInstance();
    private final g siteMaintMongoRepository = g.a();
    private final DeviceMaintRepository deviceMaintRepository = DeviceMaintRepository.getInstance();
    private final b dbCompatibleCacheService = b.a();
    private static final int BATCH_SIZE = 1000;
    private static final FAPCompatibleV51200ToV51300 instance = new FAPCompatibleV51200ToV51300();

    private FAPCompatibleV51200ToV51300() {
    }

    public static FAPCompatibleV51200ToV51300 getInstance() {
        return instance;
    }

    public FreeAuthPolicyPO createFreeDestUrl(String omadacId, String siteId) throws Exception {
        int entryId = this.getEntryId(omadacId, siteId);
        return (FreeAuthPolicyPO)new FreeAuthPolicyPO().setSiteId(siteId).setOmadacId(omadacId).setType(Integer.valueOf(2)).setUrl("privacy.tp-link.com").setPolicyType(Integer.valueOf(1)).setEntryId(Integer.valueOf(entryId));
    }

    private int getEntryId(String omadacId, String siteId) throws Exception {
        for (int i2 = 1; i2 <= 5; ++i2) {
            try {
                return this.getSequenceNumService.a(omadacId, siteId, FreeAuthPolicyPO.class);
            }
            catch (com.tplink.smb.omada.common.h.c ex) {
                log.warn("Upgrade FAP: Failed to generate new entry id of omadac: {}, site: {}.", new Object[]{omadacId, siteId, ex});
                continue;
            }
        }
        throw new Exception("Upgrade FAP: Failed to generate new entry id after retried 5 times.");
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        if (operationType == d.b) {
            log.info("Skip FAP Compatible for restore.");
            return;
        }
        ArrayList poList = new ArrayList(1000);
        log.info("Upgrade FAP started: omadac {}", (Object)omadacId);
        this.siteMaintMongoRepository.a(omadacId, sitePO -> {
            FreeAuthPolicyPO freeDestUrl;
            try {
                freeDestUrl = this.createFreeDestUrl(omadacId, sitePO.getId());
            }
            catch (Exception ex) {
                log.warn("Upgrade FAP: Failed to create new FreeDestUrl to omadac: {}, site: {}", new Object[]{sitePO.getOmadacId(), sitePO.getId(), ex});
                return;
            }
            poList.add(freeDestUrl);
            if (poList.size() >= 1000) {
                this.portalMaintRepository.insertAllFreeAuthPolicies(poList);
                poList.clear();
            }
        });
        if (!poList.isEmpty()) {
            this.portalMaintRepository.insertAllFreeAuthPolicies(poList);
        }
        log.info("Upgrade FAP finished: omadac {}", (Object)omadacId);
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
        if (operationType == d.b) {
            log.info("Skip FAP Compatible for restore.");
            return;
        }
        List devicePOList = this.deviceMaintRepository.findByOmadacId(omadacId);
        if (CollectionUtils.isEmpty((Collection)devicePOList)) {
            return;
        }
        Set<String> devicesMac = devicePOList.stream().filter(devicePO -> DeviceTypeEnum.a.b().equals(devicePO.getType()) || DeviceTypeEnum.b.b().equals(devicePO.getType())).map(DevicePO::getMac).collect(Collectors.toSet());
        this.dbCompatibleCacheService.a(omadacId, devicesMac);
    }
}

