/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.schedule;

import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.P;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.config.SchedulerCustomProperties;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.scheduleupgrade.ScheduleUpgradePO;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51330TOV51400)
public class UpgradeScheduleTaskCompatibleV51300ToV51400
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpgradeScheduleTaskCompatibleV51300ToV51400.class);
    private static final UpgradeScheduleTaskCompatibleV51300ToV51400 instance = new UpgradeScheduleTaskCompatibleV51300ToV51400();
    private static final String SCHEDULE_UPGRADE_TASK_NAME = "manager_schedule_upgrade";
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a serviceScheduleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.a.a();
    private final ScheduleCenter scheduleCenter = (ScheduleCenter)a.b(ScheduleCenter.class);
    private final com.tplink.smb.omada.manager.configuration.api.internal.a dstInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.a)a.b(com.tplink.smb.omada.manager.configuration.api.internal.a.class);
    private final SchedulerCustomProperties schedulerCustomProperties = (SchedulerCustomProperties)a.b(SchedulerCustomProperties.class);
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm";

    public static UpgradeScheduleTaskCompatibleV51300ToV51400 getInstance() {
        return instance;
    }

    private UpgradeScheduleTaskCompatibleV51300ToV51400() {
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("dbCompatible v5.13 to v5.14 in {}", (Object)omadacId);
        try {
            this.restartScheduleTask(omadacId);
        }
        catch (Exception e2) {
            log.warn("catch exception when dbCompatible v5.13 to v5.14 in {}", (Object)omadacId, (Object)e2);
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void restartScheduleTask(String omadacId) {
        List upgrades = this.serviceScheduleMaintMongoRepository.e(new c(omadacId));
        if (CollectionUtils.isEmpty((Collection)upgrades)) {
            return;
        }
        int partitionIndex = 0;
        for (ScheduleUpgradePO task : upgrades) {
            TimeZone timeZone = TimeZone.getTimeZone(P.a((String)task.getSchedule().getTimezoneId()));
            QuerySiteDTO querySiteDTO = new QuerySiteDTO();
            querySiteDTO.setOmadacId(task.getOmadacId());
            querySiteDTO.setSiteId(task.getSiteId());
            OperationResponse dstInfoDTOResp = this.dstInternalApiService.a(querySiteDTO);
            DstInfoDTO dstInfoDTO = null;
            if (!dstInfoDTOResp.success()) {
                log.warn("Failed to get dst info, omadacId: {}, siteId: {}", (Object)task.getOmadacId(), (Object)task.getSiteId());
            } else {
                dstInfoDTO = (DstInfoDTO)dstInfoDTOResp.getResult();
            }
            task.setParam(this.getParamForTask(task, timeZone, dstInfoDTO));
            if (OmadacType.s()) {
                partitionIndex = Math.abs(task.getId().hashCode() % this.schedulerCustomProperties.getShardingSizeOf(SCHEDULE_UPGRADE_TASK_NAME));
            }
            task.setPartitionIndex(Integer.valueOf(partitionIndex));
            log.debug("handle task {} {} {} in {}", new Object[]{task.getId(), task.getName(), task.getParam(), omadacId});
        }
        for (ScheduleUpgradePO task : upgrades) {
            this.scheduleCenter.deleteTask(new TaskKey(SCHEDULE_UPGRADE_TASK_NAME, task.getId()));
        }
        this.serviceScheduleMaintMongoRepository.e(upgrades);
    }

    private String getParamForTask(ScheduleUpgradePO scheduleUpgrade, TimeZone timeZone, DstInfoDTO dstInfoDTO) {
        if (dstInfoDTO != null && dstInfoDTO.getStatus().booleanValue()) {
            timeZone.setRawOffset(timeZone.getRawOffset() + dstInfoDTO.getOffset().intValue());
        }
        if (scheduleUpgrade.getOccurrence() != null) {
            return timeZone.getRawOffset() + "_" + scheduleUpgrade.getSchedule().getScheduleCron();
        }
        return this.getTimeStamp(dstInfoDTO, timeZone.getID(), scheduleUpgrade.getExecuteDate()).toString();
    }

    private Long getTimeStamp(DstInfoDTO dstInfo, String timezoneId, String formatTime) {
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(TIME_FORMAT, Locale.ROOT);
        LocalDateTime localDateTime = LocalDateTime.parse(formatTime, timeFormatter);
        ZoneId zone = ZoneId.of(timezoneId);
        Instant instant = localDateTime.atZone(zone).toInstant();
        Long timeStamp = instant.toEpochMilli();
        if (dstInfo != null && dstInfo.getEnable().booleanValue() && dstInfo.getStartTime() <= timeStamp && dstInfo.getEndTime() > timeStamp) {
            timeStamp = timeStamp - dstInfo.getOffset();
        }
        return timeStamp;
    }
}

