/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.globalconfig.user;

import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.identityaccess.api.internal.dto.CloudUsersDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.port.mongo.j;
import com.tplink.smb.omada.identityaccess.port.mongo.k;
import com.tplink.smb.omada.identityaccess.port.mongo.tenant.TenantPO;
import com.tplink.smb.omada.identityaccess.port.mongo.user.ControllerPrivilegePO;
import com.tplink.smb.omada.identityaccess.port.mongo.user.MspPrivilegePO;
import com.tplink.smb.omada.identityaccess.port.mongo.user.RolePO;
import com.tplink.smb.omada.identityaccess.port.mongo.user.UserPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51434TOV51506)
@b(a=e.V1000009032TOV1000010000)
public class UserCompatibleV51434TOV51506
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserCompatibleV51434TOV51506.class);
    private static final UserCompatibleV51434TOV51506 instance = new UserCompatibleV51434TOV51506();
    private final com.tplink.smb.omada.identityaccess.port.mongo.h roleMaintMongoRepository = com.tplink.smb.omada.identityaccess.port.mongo.h.a();
    private final k userOperatorMaintMongoRepository = k.a();
    private final g identityAccessInternalApiService = (g)a.b(g.class);
    private final j tenantMaintMongoRepository = j.a();

    private UserCompatibleV51434TOV51506() {
    }

    public static UserCompatibleV51434TOV51506 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        List roleList = this.roleMaintMongoRepository.a(new c(omadacId));
        if (CollectionUtils.isEmpty((Collection)roleList)) {
            return;
        }
        Set roleIdSet = roleList.stream().map(RolePO::getId).collect(Collectors.toSet());
        log.info("UserCompatibleV51432TOV51506 start, omadacId:{}, update roleIds:{}", (Object)omadacId, roleIdSet);
        roleList.forEach(rolePO -> {
            ControllerPrivilegePO standardPrivilege = rolePO.getStandardPrivilege();
            ControllerPrivilegePO customerPrivilege = rolePO.getCustomerPrivilege();
            MspPrivilegePO mspPrivilege = rolePO.getMspPrivilege();
            if (standardPrivilege != null && standardPrivilege.getAddAdoptDevice() == null) {
                standardPrivilege.setAddAdoptDevice(this.getAddAdoptDevicePermission(standardPrivilege.getAddDevices(), standardPrivilege.getAdopt()));
            }
            if (customerPrivilege != null && customerPrivilege.getAddAdoptDevice() == null) {
                customerPrivilege.setAddAdoptDevice(this.getAddAdoptDevicePermission(customerPrivilege.getAddDevices(), customerPrivilege.getAdopt()));
            }
            if (mspPrivilege != null && mspPrivilege.getMspAddAdoptDevice() == null) {
                mspPrivilege.setMspAddAdoptDevice(this.getAddAdoptDevicePermission(mspPrivilege.getMspAddDevices(), mspPrivilege.getMspAdopt()));
            }
            this.roleMaintMongoRepository.a(rolePO);
        });
        if (OmadacType.s()) {
            log.info("handle cloud user. omadacId:{}.", (Object)omadacId);
            ArrayList cloudUsers = new ArrayList();
            List userPOList = this.userOperatorMaintMongoRepository.d(new c(omadacId));
            userPOList.forEach(userPO -> {
                if (StringUtils.isBlank((CharSequence)userPO.getTenantId())) {
                    return;
                }
                this.tenantMaintMongoRepository.g(userPO.getTenantId()).ifPresent(tenantPO -> {
                    UserDTO userDTO = this.buildUserDTOByUserPO((UserPO)userPO, (TenantPO)tenantPO);
                    if (userDTO != null) {
                        cloudUsers.add(userDTO);
                    }
                });
            });
            if (!cloudUsers.isEmpty()) {
                this.identityAccessInternalApiService.d(CloudUsersDTO.builder().omadacId(omadacId).cloudUserDTOS(cloudUsers).build());
            }
        }
        log.info("UserCompatibleV51432TOV51506 finished, omadacId:{}", (Object)omadacId);
    }

    private UserDTO buildUserDTOByUserPO(UserPO userPO, TenantPO tenantPO) {
        if (Objects.equals(UserTypeEnumDTO.EXTERNAL_USER.getValue(), userPO.getUserType()) || Objects.equals(UserTypeEnumDTO.LOCAL_USER.getValue(), userPO.getUserType())) {
            return null;
        }
        return UserDTO.builder().accountId(tenantPO.getAccountId()).email(tenantPO.getEmail()).omadacId(userPO.getOmadacId()).userType(userPO.getUserType()).userLevel(userPO.getUserLevel()).build();
    }

    private Integer getAddAdoptDevicePermission(Integer addDevicesPermission, Integer adoptPermission) {
        return Objects.equals(addDevicesPermission, 2) || Objects.equals(adoptPermission, 2) ? 2 : 0;
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }
}

