/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.globalconfig.log;

import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.internal.dto.ClearAlertCacheRequestDTO;
import com.tplink.smb.omada.logmanager.port.mongo.logsetting.omada.LogOmadaSettingMaintRepository;
import com.tplink.smb.omada.logmanager.port.mongo.notification.NotificationPO;
import com.tplink.smb.omada.logmanager.port.mongo.omadacsetting.LogOmadacSettingPO;
import com.tplink.smb.omada.logmanager.port.mongo.sitesetting.RemoteLogSettingPO;
import com.tplink.smb.omada.logmanager.port.mongo.webhook.WebhookConfigPO;
import com.tplink.smb.omada.maintenance.common.a.i;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.a.b;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.e;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51000TOV51100)
@b(a=e.V1000002000TOV1000003000)
public class LogOmadacSettingCompatibleV51000TOV51100
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogOmadacSettingCompatibleV51000TOV51100.class);
    private static final LogOmadacSettingCompatibleV51000TOV51100 instance = new LogOmadacSettingCompatibleV51000TOV51100();
    private final LogOmadaSettingMaintRepository logOmadaSettingMaintRepository = LogOmadaSettingMaintRepository.getInstance();
    private final com.tplink.smb.omada.logmanager.api.internal.e logManagerInternalApiService = (com.tplink.smb.omada.logmanager.api.internal.e)a.b(com.tplink.smb.omada.logmanager.api.internal.e.class);

    private LogOmadacSettingCompatibleV51000TOV51100() {
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.info("Upgrading LogOmadacSettingPO from lower to v5.11");
        Optional logOmadacSetting = this.logOmadaSettingMaintRepository.findByOmadacId(new c(omadacId));
        if (!logOmadacSetting.isPresent()) {
            log.warn("Failed to log omadac setting from v51000 to v51100, omadacId:{}", (Object)omadacId);
            return;
        }
        LogOmadacSettingPO logOmadacSettingPO = (LogOmadacSettingPO)logOmadacSetting.get();
        this.addWebhookConfig(logOmadacSettingPO);
        this.addWebhookToNotification(logOmadacSettingPO.getNotifications());
        this.addRemoteLog(logOmadacSettingPO);
        this.handleNotification(logOmadacSettingPO);
        this.logOmadaSettingMaintRepository.save(logOmadacSettingPO);
        this.logManagerInternalApiService.b(new ClearAlertCacheRequestDTO(omadacId, null));
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void addRemoteLog(LogOmadacSettingPO logOmadacSettingPO) {
        RemoteLogSettingPO remoteLogSetting = logOmadacSettingPO.getRemoteLogSetting();
        if (Objects.isNull(remoteLogSetting)) {
            logOmadacSettingPO.setRemoteLogSetting(RemoteLogSettingPO.builder().enable(Boolean.FALSE).port(i.aT).build());
        }
    }

    private void handleNotification(LogOmadacSettingPO logOmadacSettingPO) {
        List notifications = logOmadacSettingPO.getNotifications();
        if (CollectionUtils.isEmpty((Collection)notifications)) {
            return;
        }
        List<NotificationPO> notificationPOS = this.filterLicenseType(notifications);
        this.addNotification(notificationPOS);
        logOmadacSettingPO.setNotifications(notificationPOS);
    }

    private void addNotification(List<NotificationPO> notifications) {
        boolean needAddCloudLog;
        boolean bl = needAddCloudLog = CollectionUtils.isEmpty(notifications) || notifications.stream().noneMatch(notificationPO -> T.a((String)"CONNECTED_CLOUD_ACCESS_SUCCESS", (String)notificationPO.getKey()));
        if (needAddCloudLog && OmadacType.s()) {
            return;
        }
        if (!needAddCloudLog && OmadacType.s()) {
            notifications.removeIf(v2 -> T.a((String)"CONNECTED_CLOUD_ACCESS_SUCCESS", (String)v2.getKey()) || T.a((String)"CLOUD_ACCESS_HEARTBEAT_MISS", (String)v2.getKey()) || T.a((String)"CLOUD_ACCESS_CONNECTION_FAILED", (String)v2.getKey()) || T.a((String)"CLOSE_CLOUD_ACCESS_SUCCESS", (String)v2.getKey()));
            return;
        }
        if (needAddCloudLog) {
            notifications.add(new NotificationPO().setKey("CONNECTED_CLOUD_ACCESS_SUCCESS").setModule("System").setAlert(Boolean.valueOf(false)).setEvent(Boolean.valueOf(true)).setEmail(Boolean.valueOf(false)).setWebhook(Boolean.valueOf(false)));
            notifications.add(new NotificationPO().setKey("CLOUD_ACCESS_CONNECTION_FAILED").setModule("System").setAlert(Boolean.valueOf(false)).setEvent(Boolean.valueOf(true)).setEmail(Boolean.valueOf(false)).setWebhook(Boolean.valueOf(false)));
            notifications.add(new NotificationPO().setKey("CLOSE_CLOUD_ACCESS_SUCCESS").setModule("System").setAlert(Boolean.valueOf(false)).setEvent(Boolean.valueOf(true)).setEmail(Boolean.valueOf(false)).setWebhook(Boolean.valueOf(false)));
        }
    }

    private List<NotificationPO> filterLicenseType(List<NotificationPO> notifications) {
        if (CollectionUtils.isEmpty(notifications)) {
            return notifications;
        }
        return notifications.stream().filter(notification -> !T.a((String)"LICENSE_TYPE_CHANGED", (String)notification.getKey())).collect(Collectors.toList());
    }

    private void addWebhookConfig(LogOmadacSettingPO logOmadacSettingPO) {
        if (Objects.isNull(logOmadacSettingPO.getWebhook())) {
            logOmadacSettingPO.setWebhook(WebhookConfigPO.builder().webhookEnable(Boolean.FALSE).build());
        }
    }

    private void addWebhookToNotification(List<NotificationPO> notifications) {
        for (NotificationPO notificationPO : notifications) {
            if (!Objects.isNull(notificationPO.getWebhook())) continue;
            notificationPO.setWebhook(Boolean.FALSE);
        }
    }

    @Generated
    public static LogOmadacSettingCompatibleV51000TOV51100 getInstance() {
        return instance;
    }
}

