/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.dst;

import com.tplink.smb.omada.common.constant.P;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogKeyEnumDTO;
import com.tplink.smb.omada.logmanager.port.mongo.data.m;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaLogPO;
import com.tplink.smb.omada.logmanager.port.mongo.logsetting.omada.LogOmadaSettingMaintRepository;
import com.tplink.smb.omada.logmanager.port.mongo.notification.NotificationPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.service.impl.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.OmadacPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.BaseSitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.DstPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.DstTimePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.SitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51000TOV51100)
public class DstCompatibleV51000TOV51100
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DstCompatibleV51000TOV51100.class);
    private static final int LAST_DAY_OF_WEEK_IN_MONTH = 5;
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c omadacMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c.a();
    private final g siteMaintMongoRepository = g.a();
    private final m omadaLogMaintMongoRepository = m.a();
    private final LogOmadaSettingMaintRepository logOmadaSettingMaintRepository = LogOmadaSettingMaintRepository.getInstance();
    private final DeviceMaintRepository deviceMaintRepository = DeviceMaintRepository.getInstance();
    private final b dbCompatibleCacheService = b.a();
    private final Map<String, Set<String>> dealSiteDstMap = new HashMap<String, Set<String>>();
    private static final DstCompatibleV51000TOV51100 instance = new DstCompatibleV51000TOV51100();

    private DstCompatibleV51000TOV51100() {
    }

    public static DstCompatibleV51000TOV51100 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        log.debug("Dst dbCompatible V5.9 to V5.10 start.");
        this.omadacMongoRepository.c().forEach(omadacPO -> {
            boolean dealedForOmadaDst = this.dealForOmadaDst((OmadacPO)omadacPO);
            HashSet<String> dealSiteIds = new HashSet<String>();
            List sitePOS = this.siteMaintMongoRepository.a(new c(omadacPO.getId()));
            boolean dealedForSiteDst = false;
            for (SitePO sitePO : sitePOS) {
                if (!this.dealForSiteDst(sitePO)) continue;
                dealedForSiteDst = true;
                dealSiteIds.add(sitePO.getId());
            }
            this.dealSiteDstMap.put(omadacPO.getId(), dealSiteIds);
            if (dealedForOmadaDst || dealedForSiteDst) {
                this.addNotification(new c(omadacPO.getId()));
            }
        });
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
        if (CollectionUtils.isEmpty(this.dealSiteDstMap)) {
            return;
        }
        this.dealSiteDstMap.forEach((dealSiteDstOmadacId, siteIds) -> {
            if (CollectionUtils.isEmpty((Collection)siteIds)) {
                return;
            }
            HashSet<String> deviceMacs = new HashSet<String>();
            for (String siteId : siteIds) {
                List devicePOS = this.deviceMaintRepository.listBriefDeviceByOmadacIdAndSiteId(dealSiteDstOmadacId, siteId);
                if (CollectionUtils.isEmpty((Collection)devicePOS)) continue;
                Set temp = devicePOS.stream().map(DevicePO::getMac).collect(Collectors.toSet());
                deviceMacs.addAll(temp);
            }
            log.info("To fix abnormal dst data that has lasted for more than one year, sync all config to devices. omadacId:{}, deviceMac:{}, compatible version:V51000TOV51100", dealSiteDstOmadacId, deviceMacs);
            this.dbCompatibleCacheService.a((String)dealSiteDstOmadacId, (Set<String>)deviceMacs);
        });
    }

    private void addNotification(c omadacId) {
        this.logOmadaSettingMaintRepository.findByOmadacId(omadacId).ifPresent(logOmadacSettingPO -> {
            List notifications = logOmadacSettingPO.getNotifications();
            if (CollectionUtils.isEmpty((Collection)notifications)) {
                return;
            }
            notifications.add(new NotificationPO().setKey("DST_C_FAIL").setModule("System").setAlert(Boolean.valueOf(true)).setEvent(Boolean.valueOf(true)).setEmail(Boolean.valueOf(true)));
            this.logOmadaSettingMaintRepository.save(logOmadacSettingPO);
        });
    }

    private boolean dealForSiteDst(SitePO sitePO) {
        DstPO dstPO = sitePO.getDst();
        if (dstPO == null || !Boolean.TRUE.equals(dstPO.getEnable())) {
            return false;
        }
        this.dealDst(dstPO, sitePO.getTimeZone());
        if (!Boolean.TRUE.equals(dstPO.getEnable())) {
            log.info("Dst dbCompatible dealForSite:{}", (Object)sitePO.getId());
            this.saveOmadaLog(sitePO.getOmadacId(), sitePO.getName());
            this.siteMaintMongoRepository.a((BaseSitePO)sitePO);
            return true;
        }
        return false;
    }

    private void saveOmadaLog(String omadacId, String name) {
        OmadaLogPO omadaLogPO = new OmadaLogPO();
        omadaLogPO.setOmadacId(omadacId);
        omadaLogPO.setKey(OmadaLogKeyEnumDTO.DST_C_FAIL.name());
        omadaLogPO.setModule("System");
        omadaLogPO.setTime(Long.valueOf(System.currentTimeMillis()));
        omadaLogPO.setContent(name + " DST is disabled due to configuration error. Please configure it again.");
        omadaLogPO.setLevel("Error");
        omadaLogPO.setArchived(Boolean.valueOf(false));
        this.omadaLogMaintMongoRepository.a(new c(omadacId), omadaLogPO);
    }

    private boolean dealForOmadaDst(OmadacPO omadacPO) {
        DstPO dstPO = omadacPO.getDst();
        if (dstPO == null || !Boolean.TRUE.equals(dstPO.getEnable())) {
            return false;
        }
        this.dealDst(dstPO, omadacPO.getTimeZone());
        if (!Boolean.TRUE.equals(dstPO.getEnable())) {
            log.info("Dst dbCompatible dealForOmada:{}", (Object)omadacPO.getId());
            this.saveOmadaLog(omadacPO.getId(), omadacPO.getName());
            this.omadacMongoRepository.a(omadacPO);
            return true;
        }
        return false;
    }

    private void dealDst(DstPO dstPO, String timeZone) {
        long endTime;
        if (dstPO == null || !Boolean.TRUE.equals(dstPO.getEnable())) {
            return;
        }
        if (dstPO.getStart() == null || dstPO.getEnd() == null) {
            return;
        }
        if (Objects.equals(dstPO.getStart().getMonth(), dstPO.getEnd().getMonth())) {
            dstPO.setEnable(Boolean.valueOf(false));
            return;
        }
        long startTime = DstCompatibleV51000TOV51100.dst2TimeStamp(dstPO.getStart(), timeZone);
        if (startTime < (endTime = DstCompatibleV51000TOV51100.dst2TimeStamp(dstPO.getEnd(), timeZone)) && endTime - startTime <= TimeUnit.DAYS.toMillis(7L) + dstPO.getOffset()) {
            dstPO.setEnable(Boolean.valueOf(false));
        }
    }

    private static long dst2TimeStamp(DstTimePO dst, String timezoneId) {
        DayOfWeek dayOfWeek = DayOfWeek.of(dst.getDay());
        int serial = dst.getSerial();
        if (serial == 5) {
            serial = -1;
        }
        LocalDateTime localDateTime = LocalDateTime.of(Year.now().getValue(), dst.getMonth(), 1, (int)dst.getHour(), (int)dst.getMinute()).with(TemporalAdjusters.dayOfWeekInMonth(serial, dayOfWeek));
        return localDateTime.toInstant(ZoneOffset.of(P.b((String)timezoneId))).toEpochMilli();
    }
}

