/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.certificate;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.maintenance.compatible.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.system.port.mongo.SystemSettingPO;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@c(a=f.V51426TOV51430)
public class CertificateCompatibleV51426TOV51430
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateCompatibleV51426TOV51430.class);
    private static final CertificateCompatibleV51426TOV51430 instance = new CertificateCompatibleV51426TOV51430();
    private final FileRepository fileRepository = (FileRepository)a.b(FileRepository.class);
    private final com.tplink.smb.omada.system.port.mongo.d systemSettingMongoRepository = com.tplink.smb.omada.system.port.mongo.d.a();

    private CertificateCompatibleV51426TOV51430() {
    }

    public static CertificateCompatibleV51426TOV51430 getInstance() {
        return instance;
    }

    @Override
    public void dbCompatible(String omadacId, d operationType) {
        if (OmadacType.r()) {
            this.systemSettingMongoRepository.b().map(SystemSettingPO::getCertificateSetting).ifPresent(certificate -> {
                if (certificate.getCerId() != null) {
                    String eapHome = System.getProperty("eap.home");
                    OutputStreamWriter fileWriter = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(eapHome + "/data/keystore/user.jks");){
                        KeyStore keyStore = KeyStore.getInstance("JKS");
                        String password = certificate.getDecryptKeyPassword();
                        if (password != null) {
                            keyStore.load(this.fileRepository.readFile(certificate.getCerId()), password.toCharArray());
                            keyStore.store(fileOutputStream, password.toCharArray());
                            fileWriter = new FileWriter(eapHome + "/data/keystore/user");
                            fileWriter.write(b.b((String)certificate.getKeyPassword()));
                            fileWriter.flush();
                        } else {
                            log.warn("Error while decrypt user certificate key password when update");
                        }
                    }
                    catch (com.tplink.smb.omada.common.h.b | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e2) {
                        log.warn("Error while save user certificate key password when update: {}", (Object)e2.getMessage());
                    }
                    finally {
                        if (fileWriter != null) {
                            try {
                                fileWriter.close();
                            }
                            catch (IOException e3) {
                                log.warn("Error while save user certificate key password when update: {}", (Object)e3.getMessage());
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void configSyncDevices(String omadacId, d operationType) {
    }
}

