/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.service.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.facade.core.FacadeUtils;
import com.tplink.smb.facade.core.constant.MessageStyle;
import com.tplink.smb.facade.core.model.LaunchMessageTypeEnum;
import com.tplink.smb.facade.start.FacadeApplication;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacVO;
import com.tplink.smb.omada.identityaccess.port.mongo.g;
import com.tplink.smb.omada.identityaccess.port.mongo.omadac.OmadacPO;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.j;
import com.tplink.smb.omada.maintenance.compatible.service.impl.b;
import com.tplink.smb.omada.maintenance.compatible.service.impl.c;
import com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.client.ClientCompatibleV51426TOV51430;
import com.tplink.smb.omada.maintenance.domain.model.datatrack.InstallParamDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.dto.BatchDeleteSsidDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.dto.DeleteSsidInfoDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.radiusserver.BuiltInRadiusCheckResultPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.radiusserver.RadiusFunctionResultPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.OswSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.server.SslVpnServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.e;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalMaintRepository;
import jakarta.annotation.PostConstruct;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@KeepClassNameAndSetter
public class DbCompatibleServiceImpl
implements com.tplink.smb.omada.maintenance.compatible.service.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(DbCompatibleServiceImpl.class);
    @Autowired
    @Lazy
    private com.tplink.smb.omada.identityaccess.api.internal.a.c b;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.manager.device.api.internal.a c;
    private final g d = com.tplink.smb.omada.identityaccess.port.mongo.g.a();
    @Autowired
    @Lazy
    private EventCenter e;
    private final com.tplink.smb.omada.system.port.mongo.d f = com.tplink.smb.omada.system.port.mongo.d.a();
    @Autowired
    @Lazy
    private com.tplink.smb.omada.manager.configuration.api.internal.omadac.a g;
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c h = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c.a();
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.wireless.ssid.a i;
    private final com.tplink.smb.omada.client.port.mongo.omada.a j = com.tplink.smb.omada.client.port.mongo.omada.a.a();
    private final b k = com.tplink.smb.omada.maintenance.compatible.service.impl.b.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.d l = com.tplink.smb.omada.manager.port.mongo.device.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.olt.b m = com.tplink.smb.omada.manager.port.mongo.device.olt.b.a();
    private final e n = com.tplink.smb.omada.manager.port.mongo.device.osw.e.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osg.c o = com.tplink.smb.omada.manager.port.mongo.device.osg.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c p = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d q = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a r = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a.a();
    private final PortalMaintRepository s = PortalMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.e t = com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.e.a();
    private final AuthenticationMaintRepository u = AuthenticationMaintRepository.getInstance();
    private final com.tplink.smb.omada.judgement.a.e v = (com.tplink.smb.omada.judgement.a.e)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.judgement.a.e.class);

    @PostConstruct
    public void a() throws com.tplink.smb.omada.maintenance.compatible.b.a {
        com.tplink.smb.omada.maintenance.compatible.d.b.a();
        com.tplink.smb.omada.maintenance.compatible.d.b.b();
    }

    @Override
    public boolean a(String oldDbVersion) {
        com.tplink.smb.omada.common.f.b targetCategory;
        if (oldDbVersion == null) {
            a.error("Failed to find data version in DB");
            return false;
        }
        if (com.tplink.smb.omada.maintenance.compatible.d.b.a(oldDbVersion)) {
            a.error("Not support cross version {} install.", (Object)oldDbVersion);
            return false;
        }
        String category = this.g.a(System.getProperty("eap.omadac.id"));
        OperationResponse defaultOmadac = this.b.b();
        com.tplink.smb.omada.common.f.b sourceCategory = com.tplink.smb.omada.common.f.b.d;
        if (defaultOmadac.success() && defaultOmadac.getResult() != null && ((OmadacVO)defaultOmadac.getResult()).getId() != null) {
            sourceCategory = this.h.a(new com.tplink.smb.omada.maintenance.common.b.a.a.c(((OmadacVO)defaultOmadac.getResult()).getId())).map(com.tplink.smb.omada.manager.port.mongo.configuration.omadac.OmadacPO::getCategory).map(com.tplink.smb.omada.common.f.b::a).orElse(com.tplink.smb.omada.common.f.b.d);
        }
        return com.tplink.smb.omada.maintenance.compatible.d.b.a(oldDbVersion, (targetCategory = com.tplink.smb.omada.common.f.b.a((String)category)) == com.tplink.smb.omada.common.f.b.e ? "1200.1.0" : "6.1.0", sourceCategory, targetCategory);
    }

    @Override
    public String b(String oldDbVersion) {
        String nowCategory;
        com.tplink.smb.omada.common.f.b nowCategoryEnum;
        Optional omadacPO;
        com.tplink.smb.omada.common.f.b oldCategoryEnum = com.tplink.smb.omada.common.f.b.d;
        OperationResponse defaultOmadac = this.b.b();
        if (defaultOmadac.success() && defaultOmadac.getResult() != null && ((OmadacVO)defaultOmadac.getResult()).getId() != null && (omadacPO = this.h.a(new com.tplink.smb.omada.maintenance.common.b.a.a.c(((OmadacVO)defaultOmadac.getResult()).getId()))).isPresent() && ((com.tplink.smb.omada.manager.port.mongo.configuration.omadac.OmadacPO)omadacPO.get()).getCategory() != null) {
            oldCategoryEnum = com.tplink.smb.omada.common.f.b.a((String)((com.tplink.smb.omada.manager.port.mongo.configuration.omadac.OmadacPO)omadacPO.get()).getCategory());
        }
        if (Objects.equals(oldCategoryEnum, nowCategoryEnum = com.tplink.smb.omada.common.f.b.a((String)(nowCategory = this.g.a(System.getProperty("eap.omadac.id")))))) {
            String omadacId = this.a(oldDbVersion, com.tplink.smb.omada.common.f.b.e.equals((Object)nowCategoryEnum) ? "1200.1.0" : "6.1.0", nowCategoryEnum);
            if (omadacId == null) {
                return null;
            }
            this.e(omadacId);
            return omadacId;
        }
        if (com.tplink.smb.omada.common.f.b.e.equals((Object)nowCategoryEnum) && com.tplink.smb.omada.common.f.b.d.equals((Object)oldCategoryEnum)) {
            return this.c(oldDbVersion);
        }
        return null;
    }

    private String c(String oldDbVersion) {
        String omadacId = this.a(oldDbVersion, "6.1.0", com.tplink.smb.omada.common.f.b.d);
        if (omadacId == null) {
            return null;
        }
        if (this.a(omadacId, com.tplink.smb.omada.maintenance.compatible.d.a)) {
            this.e(omadacId);
            return omadacId;
        }
        a.warn("Faild exectue advanced to pro install compatible for omadac {}", (Object)omadacId);
        return null;
    }

    @Override
    public boolean a(String omadacId, String restoreDbVer, com.tplink.smb.omada.common.f.b dbCategory, com.tplink.smb.omada.common.f.b fileCategory) {
        if (Objects.equals(fileCategory, dbCategory)) {
            return this.b(omadacId, restoreDbVer, dbCategory);
        }
        if (com.tplink.smb.omada.common.f.b.e.equals((Object)dbCategory) && (com.tplink.smb.omada.common.f.b.d.equals((Object)fileCategory) || Objects.isNull(fileCategory))) {
            a.info("Restore form advance {} to pro on omadac {}.", (Object)restoreDbVer, (Object)omadacId);
            return this.a(omadacId, com.tplink.smb.omada.maintenance.compatible.d.b, restoreDbVer, "6.1.0");
        }
        if (Objects.equals(fileCategory.a(), com.tplink.smb.omada.common.f.b.a.a())) {
            a.info("Restore form free {} to advance on omadac {}.", (Object)restoreDbVer, (Object)omadacId);
            return this.b(omadacId, restoreDbVer, dbCategory);
        }
        a.warn("Restore form unexpected category {} to {} on omadac {}.", new Object[]{fileCategory, dbCategory, omadacId});
        return false;
    }

    private String a(String oldDbVersion, String targetDbVersion, com.tplink.smb.omada.common.f.b categoryEnum) {
        boolean dbCompatibled;
        if (Objects.equals(oldDbVersion, targetDbVersion)) {
            a.info("Do not need to install compatible for ver {}", (Object)oldDbVersion);
            return this.d.b().map(OmadacPO::getId).orElse(null);
        }
        if (com.tplink.smb.omada.maintenance.compatible.d.b.a(oldDbVersion)) {
            a.error("can not install v4 db. compatible failed.");
            return null;
        }
        OperationResponse omadacVORes = this.b.a(null);
        if (!omadacVORes.success() || omadacVORes.getResult() == null || ((OmadacVO)omadacVORes.getResult()).getId() == null) {
            a.error("can not create or get OmadacId. compatible failed.");
            return null;
        }
        String omadacId = ((OmadacVO)omadacVORes.getResult()).getId();
        a.info("Omadac {} install compatible begin. DB version from {} to {}", new Object[]{omadacId, oldDbVersion, targetDbVersion});
        a.info("Upgrading the database, please DO NOT close the controller during this process");
        if (!(Objects.equals(oldDbVersion, targetDbVersion) || OmadacType.s() || OmadacType.r())) {
            MessageStyle style = new MessageStyle();
            style.setBold(Boolean.valueOf(true));
            style.setForeground(new Color(255, 127, 0));
            FacadeUtils.sendMessage((LaunchMessageTypeEnum)LaunchMessageTypeEnum.MSG, (String)"Upgrading the database...", (MessageStyle)style);
            FacadeUtils.sendMessage((LaunchMessageTypeEnum)LaunchMessageTypeEnum.MSG, (String)"Please DO NOT close the controller during this process", (MessageStyle)style);
        }
        if (!(dbCompatibled = Objects.equals(com.tplink.smb.omada.common.f.c.b.a(), ((OmadacVO)omadacVORes.getResult()).getPattern()) ? this.a(((OmadacVO)omadacVORes.getResult()).getId(), com.tplink.smb.omada.maintenance.compatible.d.a, oldDbVersion, targetDbVersion, categoryEnum, categoryEnum) : this.b(omadacId, com.tplink.smb.omada.maintenance.compatible.d.a, oldDbVersion, targetDbVersion, categoryEnum, categoryEnum))) {
            a.error("compatible failed.");
            return null;
        }
        if (!Objects.equals(oldDbVersion, targetDbVersion) && !OmadacType.s()) {
            FacadeUtils.sendMessage((LaunchMessageTypeEnum)LaunchMessageTypeEnum.MSG, (String)"Database upgraded");
        }
        a.info("Database upgraded");
        if (!CollectionUtils.isEmpty(com.tplink.smb.omada.maintenance.compatible.service.impl.c.a)) {
            Set<DeleteSsidInfoDTO> ssidInfoDTOS = com.tplink.smb.omada.maintenance.compatible.service.impl.c.a;
            a.info("Do delete inCompatible ssid with built in ppsk {}", ssidInfoDTOS);
            Map<String, List<DeleteSsidInfoDTO>> omadacIdSsidInfoMap = ssidInfoDTOS.stream().collect(Collectors.groupingBy(DeleteSsidInfoDTO::getOmadacId));
            omadacIdSsidInfoMap.entrySet().forEach(entry -> {
                if (entry.getKey() == null || CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) {
                    return;
                }
                this.i.a(new BatchDeleteSsidDTO((String)entry.getKey(), (List)entry.getValue()));
            });
            com.tplink.smb.omada.maintenance.compatible.service.impl.c.a.clear();
        }
        if (Boolean.TRUE.equals(ClientCompatibleV51426TOV51430.NEED_UPDATE_CLIENT_INDEX.get())) {
            com.tplink.smb.omada.common.concurrent.thread.b.a(() -> {
                long start = System.currentTimeMillis();
                this.j.d();
                long end = System.currentTimeMillis();
                a.info("drop client usless indexes cost {} ms", (Object)(end - start));
            }, (long)3L, (TimeUnit)TimeUnit.SECONDS);
        }
        this.d(omadacId);
        a.info("Omadac {} install compatible end. DB version from {} to {}", new Object[]{omadacId, oldDbVersion, targetDbVersion});
        return omadacId;
    }

    private void d(String omadacId) {
        if (OmadacType.r()) {
            this.l.a(omadacId, DeviceTypeEnum.a.b());
            this.m.a(omadacId, DeviceTypeEnum.d.b());
            this.o.a(omadacId, DeviceTypeEnum.b.b());
            this.n.a(omadacId, DeviceTypeEnum.c.b());
        }
        if (this.v.a(omadacId, "delete_build_in_radius_oc200")) {
            this.a(new com.tplink.smb.omada.maintenance.common.b.a.a.c(omadacId));
        }
    }

    private void a(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        RadiusProfilePO builtInRadiusProfile = this.u.findBuiltInProfile();
        if (builtInRadiusProfile == null) {
            return;
        }
        builtInRadiusProfile.setServerEnable(Boolean.valueOf(false));
        this.u.save(builtInRadiusProfile);
        String builtInRadiusProfileId = builtInRadiusProfile.getId();
        BuiltInRadiusCheckResultPO builtInRadiusCheckResult = this.u.findBuiltInRadiusCheckResult();
        if (builtInRadiusCheckResult == null) {
            builtInRadiusCheckResult = BuiltInRadiusCheckResultPO.builder().result(new HashMap()).build();
        }
        if (builtInRadiusCheckResult.getResult() == null) {
            builtInRadiusCheckResult.setResult(new HashMap());
        }
        Map siteFunctionMap = builtInRadiusCheckResult.getResult().computeIfAbsent(omadacId.a(), v2 -> new HashMap());
        List ssids = this.p.a(omadacId, Integer.valueOf(2), com.tplink.smb.omada.manager.c.x.a.b());
        for (Object ssid : ssids) {
            if (ssid.getWpaSetting() == null || !Objects.equals(ssid.getWpaSetting().getRadiusProfileId(), builtInRadiusProfileId)) continue;
            RadiusFunctionResultPO functionResult = siteFunctionMap.computeIfAbsent(((SsidPO)ssid).getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            if (functionResult.getWpaeSsid() == null) {
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(ssid.getId());
                functionResult.setWpaeSsid(idSet);
                continue;
            }
            functionResult.getWpaeSsid().add(ssid.getId());
        }
        List apSiteSettings = this.q.a(omadacId);
        for (Object apSiteSetting : apSiteSettings) {
            RadiusFunctionResultPO functionResult;
            if (apSiteSetting.getMacAuth() != null && Boolean.TRUE.equals(apSiteSetting.getMacAuth().getEnable()) && Objects.equals(apSiteSetting.getMacAuth().getRadiusProfileId(), builtInRadiusProfileId)) {
                functionResult = siteFunctionMap.computeIfAbsent(apSiteSetting.getSiteId(), v2 -> new RadiusFunctionResultPO());
                functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
                functionResult.setMacAuthId(apSiteSetting.getId());
            }
            if (apSiteSetting.getApDot1x() == null || !Boolean.TRUE.equals(apSiteSetting.getApDot1x().getEnable()) || !Objects.equals(apSiteSetting.getApDot1x().getRadiusProfileId(), builtInRadiusProfileId)) continue;
            functionResult = siteFunctionMap.computeIfAbsent(apSiteSetting.getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            functionResult.setApDot1xId(apSiteSetting.getId());
        }
        List portals = this.s.findAllPortals(omadacId);
        for (Object portal : portals) {
            HashSet<String> idSet;
            RadiusFunctionResultPO functionResult;
            if (!Boolean.TRUE.equals(portal.getEnable())) continue;
            if (Objects.equals(portal.getAuthType(), 2) && portal.getExternalRadius() != null && Objects.equals(portal.getExternalRadius().getRadiusProfileId(), builtInRadiusProfileId)) {
                functionResult = siteFunctionMap.computeIfAbsent(portal.getSiteId(), v2 -> new RadiusFunctionResultPO());
                functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
                if (functionResult.getPortalId() == null) {
                    idSet = new HashSet<String>();
                    idSet.add(portal.getId());
                    functionResult.setPortalId(idSet);
                } else {
                    functionResult.getPortalId().add(portal.getId());
                }
            }
            if (!Objects.equals(portal.getAuthType(), 11) || portal.getHotspot() == null || portal.getHotspot().getEnabledTypes() == null || !portal.getHotspot().getEnabledTypes().contains(8) || portal.getHotspotRadius() == null || !Objects.equals(portal.getHotspotRadius().getRadiusProfileId(), builtInRadiusProfileId)) continue;
            functionResult = siteFunctionMap.computeIfAbsent(portal.getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            if (functionResult.getPortalId() == null) {
                idSet = new HashSet();
                idSet.add(portal.getId());
                functionResult.setPortalId(idSet);
                continue;
            }
            functionResult.getPortalId().add(portal.getId());
        }
        List oswSiteSettings = this.r.a(omadacId);
        for (OswSiteSettingPO oswSiteSetting : oswSiteSettings) {
            if (oswSiteSetting.getDot1x() == null || !Boolean.TRUE.equals(oswSiteSetting.getDot1x().getEnable()) || !Objects.equals(oswSiteSetting.getDot1x().getRadiusProfileId(), builtInRadiusProfileId)) continue;
            RadiusFunctionResultPO functionResult = siteFunctionMap.computeIfAbsent(oswSiteSetting.getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            functionResult.setOswDot1xId(oswSiteSetting.getId());
        }
        List sslVpnServers = this.t.a(omadacId);
        for (SslVpnServerPO sslVpnServer : sslVpnServers) {
            if (sslVpnServer.getRadiusSetting() == null || !Boolean.TRUE.equals(sslVpnServer.getStatus()) || !Objects.equals(sslVpnServer.getAuthType(), 1) || !Objects.equals(sslVpnServer.getRadiusSetting().getRadiusProfile(), builtInRadiusProfileId)) continue;
            RadiusFunctionResultPO functionResult = siteFunctionMap.computeIfAbsent(sslVpnServer.getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            functionResult.setSslVpnId(sslVpnServer.getId());
        }
        this.u.save(builtInRadiusCheckResult);
    }

    private boolean b(String omadacId, String restoreDbVer, com.tplink.smb.omada.common.f.b category) {
        boolean dbCompatibled;
        String targetDbVersion = com.tplink.smb.omada.common.f.b.e.equals((Object)category) ? "1200.1.0" : "6.1.0";
        a.info("Omadac {} restore compatible begin. DB version from {} to {}", new Object[]{omadacId, restoreDbVer, targetDbVersion});
        if (restoreDbVer == null) {
            restoreDbVer = targetDbVersion;
        }
        if (!(dbCompatibled = this.b(omadacId, com.tplink.smb.omada.maintenance.compatible.d.b, restoreDbVer, targetDbVersion, category, category))) {
            a.error("compatible failed.");
            return false;
        }
        a.info("Omadac {} restore compatible end. DB version from {} to {}", new Object[]{omadacId, restoreDbVer, targetDbVersion});
        return true;
    }

    private boolean a(String omadacId, d compatibleOperationType, String restoreDbVersion, String targetDbVersion) {
        boolean dbCompatibled = this.b(omadacId, com.tplink.smb.omada.maintenance.compatible.d.b, restoreDbVersion, targetDbVersion, com.tplink.smb.omada.common.f.b.d, com.tplink.smb.omada.common.f.b.d);
        if (!dbCompatibled) {
            return false;
        }
        return this.a(omadacId, compatibleOperationType);
    }

    @Override
    public boolean a(String omadacId, String siteId, String dbVer) {
        List<j> ccList = com.tplink.smb.omada.maintenance.compatible.d.b.a(this.b(), dbVer);
        if (CollectionUtils.isEmpty(ccList)) {
            a.info("do not need to siteImportCompatible, dbVersion {}", (Object)dbVer);
            return true;
        }
        try {
            for (j cc : ccList) {
                cc.a(omadacId, siteId);
            }
        }
        catch (Exception exception) {
            a.error(omadacId + " site import compatible error. db version: " + dbVer + " msg: " + exception.getMessage());
            return false;
        }
        a.info("siteImportCompatible complete, omdacId {} dbVersion {}", (Object)omadacId, (Object)dbVer);
        return true;
    }

    private boolean a(String omadacId, d compatibleOperationType) {
        List<h> ccList = com.tplink.smb.omada.maintenance.compatible.d.b.a(omadacId, this.b());
        if (!CollectionUtils.isEmpty(ccList)) {
            for (com.tplink.smb.omada.maintenance.compatible.b b2 : ccList) {
                if (!this.a(b2) || Boolean.TRUE.equals(this.a(b2, omadacId, "6.1.0", "1200.1.0", compatibleOperationType, new AtomicInteger(1), 1))) continue;
                a.info("Failed execute advance to pro on {} on omadac {} when {}.", new Object[]{b2.getClass().getSimpleName(), omadacId, compatibleOperationType.name()});
                return false;
            }
        }
        return true;
    }

    private boolean a(String mspId, d compatibleType, String oldVersion, String newVersion, com.tplink.smb.omada.common.f.b sourceCategory, com.tplink.smb.omada.common.f.b category) {
        Optional omadacPOOptional = this.d.a((com.tplink.smb.omada.maintenance.common.b.a.a.c)new com.tplink.smb.omada.maintenance.common.b.a.a.b(mspId));
        if (!omadacPOOptional.isPresent()) {
            return false;
        }
        boolean compatible = this.b(mspId, compatibleType, oldVersion, newVersion, sourceCategory, category);
        if (!compatible) {
            return compatible;
        }
        if (!CollectionUtils.isEmpty((Collection)((OmadacPO)omadacPOOptional.get()).getCustomers())) {
            for (String customerId : ((OmadacPO)omadacPOOptional.get()).getCustomers()) {
                compatible = this.b(customerId, compatibleType, oldVersion, newVersion, sourceCategory, category);
                if (compatible) continue;
                return compatible;
            }
        }
        return true;
    }

    private boolean b(String omadacId, d compatibleType, String oldVersion, String newVersion, com.tplink.smb.omada.common.f.b sourceCategory, com.tplink.smb.omada.common.f.b category) {
        List<com.tplink.smb.omada.maintenance.compatible.b> ccList = com.tplink.smb.omada.maintenance.compatible.d.b.a(compatibleType, this.b(), oldVersion, newVersion, sourceCategory, category);
        if (!CollectionUtils.isEmpty(ccList)) {
            AtomicInteger current = new AtomicInteger(1);
            int total = ccList.size();
            for (com.tplink.smb.omada.maintenance.compatible.b cc : ccList) {
                if (!this.a(cc) || Boolean.TRUE.equals(this.a(cc, omadacId, oldVersion, newVersion, compatibleType, current, total))) continue;
                return false;
            }
            if (!OmadacType.s()) {
                this.f.b().ifPresent(systemSettingPO -> {
                    if (Boolean.TRUE.equals(systemSettingPO.getControllerUpdateNotification())) {
                        systemSettingPO.setControllerUpdateNotification(Boolean.valueOf(false));
                        this.f.a(systemSettingPO);
                    }
                });
            }
            return true;
        }
        a.info("no need to compatible db.");
        return true;
    }

    private void e(String omadacId) {
        Set<String> configSyncDevices = this.k.a(omadacId);
        if (!CollectionUtils.isEmpty(configSyncDevices)) {
            a.info("refresh config version for macs {}", configSyncDevices);
            configSyncDevices.forEach(deviceMac -> this.c.a(omadacId, deviceMac));
        }
    }

    protected OmadacType.OmadacTypeEnum b() {
        return OmadacType.b();
    }

    private boolean a(com.tplink.smb.omada.maintenance.compatible.b cc) {
        return cc instanceof h || cc instanceof j;
    }

    private Boolean a(com.tplink.smb.omada.maintenance.compatible.b cc, String omadacId, String oldVersion, String targetVersion, d compatibleType, AtomicInteger current, int total) {
        try {
            long begin = System.currentTimeMillis();
            if (cc instanceof h) {
                ((h)cc).dbCompatible(omadacId, compatibleType);
                ((h)cc).configSyncDevices(omadacId, compatibleType);
            } else if (cc instanceof j) {
                ((j)cc).a(omadacId);
            }
            this.a(current, total);
            a.info("compatible class {} finish, cost time: {}", cc.getClass(), (Object)(System.currentTimeMillis() - begin));
        }
        catch (Exception e2) {
            a.error("{} compatible error. old dbVersion : {}. class: {}", new Object[]{omadacId, oldVersion, cc.getClass(), e2});
            InstallParamDTO installParamDTO = new InstallParamDTO();
            installParamDTO.setKey(cc.getClass().getSimpleName());
            installParamDTO.setException(e2.toString());
            installParamDTO.setOldver(oldVersion);
            installParamDTO.setNewver(targetVersion);
            this.e.send("omada.monitor.datatrack.event", ((Event.EventBuilder)((Event.EventBuilder)((Event.EventBuilder)Event.builder().filterKey(com.tplink.smb.omada.maintenance.compatible.d.a.equals((Object)compatibleType) ? "installException" : "restoreException")).message((Object)x.a((Object)installParamDTO))).timeStamp(System.currentTimeMillis())).build());
            return false;
        }
        return true;
    }

    private void a(AtomicInteger current, int total) {
        if (current.get() == total) {
            return;
        }
        int progress = 50 + 40 * current.getAndIncrement() / total;
        int nextProgress = 50 + 40 * current.get() / total;
        this.a(progress, nextProgress);
    }

    private void a(int progress, int nextProgress) {
        if (OmadacType.o()) {
            FacadeApplication.setProgressValue((int)progress);
        } else if (OmadacType.r()) {
            System.setProperty("hardware.startup.progress", Integer.toString(progress));
            System.setProperty("hardware.startup.next.progress", Integer.toString(nextProgress));
        }
    }

    private static ThreadPoolExecutor c() {
        return com.tplink.smb.omada.maintenance.compatible.service.impl.DbCompatibleServiceImpl$a.a;
    }

    private static class a {
        private static ThreadPoolExecutor a;

        private a() {
        }

        static {
            int coreSize = 1;
            if (OmadacType.z()) {
                coreSize = 3;
            } else if (OmadacType.r()) {
                coreSize = 2;
            }
            a.debug(" use core size: {}", (Object)coreSize);
            a = new ThreadPoolExecutor(coreSize, coreSize, 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new ThreadFactoryBuilder().setNameFormat("maintenance-compatible-group-%d").build());
            a.allowCoreThreadTimeOut(true);
        }
    }
}

