/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.common.mongo.utils;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Utils {
    private static final Logger log = LoggerFactory.getLogger(MD5Utils.class);

    private MD5Utils() {
    }

    public static String md5(byte[] inputBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(inputBytes);
            byte[] b = md.digest();
            StringBuilder buf = new StringBuilder();
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.warn(e.toString(), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String md5(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int length;
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((length = fileInputStream.read(buffer)) != -1) {
                MD5.update(buffer, 0, length);
            }
            String string = new String(Hex.encodeHex((byte[])MD5.digest()));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

