/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.common.mongo.impl;

import com.tplink.smb.component.upgradefilecache.common.mongo.UpgradeFileInfoCrudRepository;
import com.tplink.smb.component.upgradefilecache.common.mongo.UpgradeFileInfoRepository;
import com.tplink.smb.component.upgradefilecache.common.mongo.po.UpgradeFileInfoPO;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class UpgradeFileInfoRepositoryImpl
implements UpgradeFileInfoRepository {
    private MongoTemplate mongoTemplate;
    private UpgradeFileInfoCrudRepository upgradeFileInfoCrudRepository;

    @Override
    public void save(UpgradeFileInfoPO upgradeFileInfoPO) {
        this.upgradeFileInfoCrudRepository.save(upgradeFileInfoPO);
    }

    @Override
    public void delete(String fileKey) {
        this.upgradeFileInfoCrudRepository.deleteById(fileKey);
    }

    @Override
    public List<UpgradeFileInfoPO> findAll() {
        return this.upgradeFileInfoCrudRepository.findAll();
    }

    @Override
    public long getRecordFileTotalSize() {
        return this.findAll().stream().mapToLong(UpgradeFileInfoPO::getFileSize).sum();
    }

    @Override
    public List<UpgradeFileInfoPO> findAllSortByLastUseTimeAsc() {
        return this.upgradeFileInfoCrudRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"last_use_time"}));
    }

    @Override
    public Optional<UpgradeFileInfoPO> findByFileKey(String fileKey) {
        return this.upgradeFileInfoCrudRepository.findById(fileKey);
    }

    @Override
    public UpgradeFileInfoPO findAndUpdateLastUseTime(String fileKey, long lastUseTime) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)fileKey));
        return (UpgradeFileInfoPO)this.mongoTemplate.findAndModify(query, (UpdateDefinition)Update.update((String)"last_use_time", (Object)lastUseTime), new FindAndModifyOptions().returnNew(true), UpgradeFileInfoPO.class);
    }

    @Override
    public List<UpgradeFileInfoPO> deleteByLastUseTime(long lastUseTime) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"last_use_time").lte((Object)lastUseTime));
        return this.mongoTemplate.findAllAndRemove(query, UpgradeFileInfoPO.class);
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void setUpgradeFileInfoCrudRepository(UpgradeFileInfoCrudRepository upgradeFileInfoCrudRepository) {
        this.upgradeFileInfoCrudRepository = upgradeFileInfoCrudRepository;
    }
}

