/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.log.port.audit.aspect;

import com.tplink.smb.omada.common.access.AuditLogReturnDTO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.d;
import com.tplink.smb.omada.common.auditlog.BuildAuditLogParamsDTO;
import com.tplink.smb.omada.common.auditlog.GetCurrentInfoRequestDTO;
import com.tplink.smb.omada.common.auditlog.GetCurrentInfoResponseDTO;
import com.tplink.smb.omada.common.auditlog.GetOrgTypeRequestDTO;
import com.tplink.smb.omada.common.auditlog.GetOrgTypeResponseDTO;
import com.tplink.smb.omada.common.constant.AuditLogSettingTypeEnum;
import com.tplink.smb.omada.common.constant.w;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.Z;
import com.tplink.smb.omada.common.util.g;
import com.tplink.smb.omada.dispatcher.common.util.AccessTokenUtils;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.log.port.audit.a.a;
import com.tplink.smb.omada.log.port.audit.a.b;
import com.tplink.smb.omada.log.port.audit.annotation.AuditLog;
import com.tplink.smb.omada.log.port.audit.common.AuditLogResourceEnum;
import com.tplink.smb.omada.log.port.audit.common.OperateResultEnum;
import io.reactivex.Single;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Aspect
@KeepClass
public class AuditLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditLogAspect.class);
    private final b auditLogApiService;
    private final a identityAccessInternalApiService;

    @Autowired
    public AuditLogAspect(b auditLogApiService, a identityAccessApiService) {
        this.auditLogApiService = auditLogApiService;
        this.identityAccessInternalApiService = identityAccessApiService;
    }

    @Pointcut(value="@annotation(com.tplink.smb.omada.log.port.audit.annotation.AuditLog)")
    public void logPointCut() {
    }

    @PostConstruct
    public void init() {
        log.info("AuditLogAspect init");
    }

    @AfterReturning(pointcut="logPointCut()", returning="response")
    public void after(JoinPoint joinPoint, Object response) {
        this.a(joinPoint, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(JoinPoint joinPoint, Object response) {
        try {
            log.debug("start to handle logPointCut");
            this.b(joinPoint, response);
        }
        catch (Exception e) {
            log.warn("exception occur while handle logPointCut, message : {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            com.tplink.smb.omada.log.port.audit.common.a.b();
        }
    }

    private void b(JoinPoint joinPoint, Object response) {
        log.debug("start to handle logPointCut -- send auditLog");
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        AuditLog auditLog = signature.getMethod().getAnnotation(AuditLog.class);
        String sessionId = SessionUtils.getSessionId();
        String ip = UserIpUtils.getLocalUserIp().orElse("");
        if (Objects.isNull(response)) {
            log.warn("Cannot send audit for response if null");
            return;
        }
        if (response instanceof OperationResponse) {
            OperationResponse operationResponse = (OperationResponse)response;
            this.a(ip, sessionId, auditLog, operationResponse);
        } else if (response instanceof Single) {
            Single single = (Single)response;
            single.subscribe(resp -> this.a(ip, sessionId, auditLog, (OperationResponse)resp));
        } else {
            log.warn("Unknown response type : {} ", response.getClass());
        }
    }

    private void a(String ip, String sessionId, AuditLog auditLog, OperationResponse operationResponse) {
        List<AuditLogReturnDTO> auditLogCompleteInfo;
        List<AuditLogReturnDTO> auditLogReturnList = operationResponse.getAuditLogReturnList();
        operationResponse.setAuditLogReturnList(null);
        AuditLogReturnDTO auditLogReturn = operationResponse.getAuditLogReturn();
        operationResponse.setAuditLogReturn(null);
        if (Objects.nonNull(auditLogReturn) && !g.f().booleanValue()) {
            auditLogReturn.setOldValue(null);
            auditLogReturn.setNewValue(null);
        }
        if (!CollectionUtils.isEmpty(auditLogCompleteInfo = com.tplink.smb.omada.log.port.audit.common.a.a())) {
            if (CollectionUtils.isEmpty((Collection)auditLogReturnList)) {
                auditLogCompleteInfo.add(0, auditLogReturn);
                auditLogReturnList = auditLogCompleteInfo;
            } else {
                auditLogReturnList.addAll(auditLogCompleteInfo);
            }
        }
        if (CollectionUtils.isEmpty((Collection)auditLogReturnList)) {
            this.a(ip, sessionId, auditLog, operationResponse, auditLogReturn);
        } else {
            for (AuditLogReturnDTO auditLogReturnDTO : auditLogReturnList) {
                this.a(ip, sessionId, auditLog, operationResponse, auditLogReturnDTO);
            }
        }
    }

    private void a(String ip, String sessionId, AuditLog auditLog, OperationResponse operationResponse, AuditLogReturnDTO auditLogReturn) {
        String realAuditLogKey = auditLog.auditLogKey().name();
        if (Objects.isNull(auditLogReturn)) {
            log.debug("fail to handle auditLogKey : {} , for auditLogReturn is null", (Object)realAuditLogKey);
            return;
        }
        String mspId = auditLogReturn.getMspId();
        String omadacId = auditLogReturn.getOmadacId();
        String siteId = auditLogReturn.getSiteId();
        boolean isMspLevel = Objects.equals((Object)auditLog.auditLogLevel(), (Object)AuditLog.AuditLogLevel.a);
        boolean isGlobalLevel = Objects.equals((Object)auditLog.auditLogLevel(), (Object)AuditLog.AuditLogLevel.b);
        boolean isSiteTemplate = Objects.equals(auditLog.settingType(), AuditLogSettingTypeEnum.b);
        String queryUserOmadacId = isMspLevel ? mspId : omadacId;
        String accessToken = Objects.equals((Object)auditLog.resource(), (Object)AuditLog.AuditLogResource.a) ? null : AccessTokenUtils.getAccessToken();
        boolean openApiRequest = !StringUtils.isEmpty((CharSequence)accessToken);
        AuditLogResourceEnum realResource = openApiRequest ? AuditLogResourceEnum.b : AuditLogResourceEnum.a;
        OperationResponse<GetCurrentInfoResponseDTO> user = this.identityAccessInternalApiService.a(new GetCurrentInfoRequestDTO(sessionId, queryUserOmadacId, accessToken));
        if (Objects.nonNull(auditLogReturn.getRealAuditLogKey())) {
            realAuditLogKey = auditLogReturn.getRealAuditLogKey().name();
        }
        String realLabel = realResource == AuditLogResourceEnum.a ? Optional.ofNullable(auditLogReturn.getRealAuditLogConfigPageCard()).orElse(auditLog.configPageCard()).a() : Z.b().orElse("");
        Integer orgType = null;
        if (isGlobalLevel && d.e.contains(realAuditLogKey)) {
            OperationResponse<GetOrgTypeResponseDTO> orgTypeResp = this.identityAccessInternalApiService.a(new GetOrgTypeRequestDTO(omadacId));
            if (!orgTypeResp.success() || Objects.isNull(orgTypeResp.getResult())) {
                log.warn("Failed to get org type, omadacId: {}", (Object)omadacId);
                orgType = w.b.a();
            } else {
                orgType = ((GetOrgTypeResponseDTO)orgTypeResp.getResult()).getOrgType();
            }
        }
        Integer resultCode = this.a(operationResponse.success(), operationResponse.getErrorCode(), realAuditLogKey);
        BuildAuditLogParamsDTO buildAuditLogParams = new BuildAuditLogParamsDTO();
        buildAuditLogParams.setResCode(resultCode);
        buildAuditLogParams.setLabel(realLabel);
        buildAuditLogParams.setOldValue(auditLogReturn.getOldValue());
        buildAuditLogParams.setNewValue(auditLogReturn.getNewValue());
        buildAuditLogParams.setParams((List)Optional.ofNullable(auditLogReturn.getParams()).orElse(new ArrayList()));
        buildAuditLogParams.setSettingType(Integer.valueOf(auditLog.settingType().a()));
        buildAuditLogParams.setOrgType(orgType);
        buildAuditLogParams.setClientParamMap((Map)Optional.ofNullable(auditLogReturn.getClientParamMap()).map(HashMap::new).orElse(null));
        if (isMspLevel) {
            this.a(mspId, realAuditLogKey, (GetCurrentInfoResponseDTO)user.orElse(null), ip, realResource.a(), buildAuditLogParams);
        } else {
            String finalSiteId = isGlobalLevel && !isSiteTemplate ? null : siteId;
            this.a(omadacId, finalSiteId, realAuditLogKey, (GetCurrentInfoResponseDTO)user.orElse(null), ip, realResource.a(), buildAuditLogParams);
        }
    }

    private void a(String omadacId, String siteId, String auditLogKey, GetCurrentInfoResponseDTO currentUser, String ip, int resourceCode, @Nonnull BuildAuditLogParamsDTO paramsDTO) {
        if (Objects.isNull(currentUser) || Objects.isNull(ip)) {
            log.warn("Cannot getLocalUserIp or user, omadacId {}, logkey: {}", (Object)omadacId, (Object)auditLogKey);
            return;
        }
        String operator = currentUser.getUsernameOrCloudAccount().orElse("");
        if (!this.a(omadacId, auditLogKey, operator, ip)) {
            return;
        }
        if (Objects.isNull((Object)AuditLogResourceEnum.a(resourceCode))) {
            log.warn("invalid auditLog resource code : {} of omadacId : {} auditLogKey : {}", new Object[]{resourceCode, omadacId, auditLogKey});
            return;
        }
        log.debug("start to send omadac/site auditLog , omadacId : {} , siteId : {} , auditLogKey : {}", new Object[]{omadacId, siteId, auditLogKey});
        this.auditLogApiService.a(omadacId, siteId, auditLogKey, operator, resourceCode, ip, System.currentTimeMillis(), paramsDTO);
    }

    private void a(String mspId, String auditLogKey, GetCurrentInfoResponseDTO currentUser, String ip, int resourceCode, @Nonnull BuildAuditLogParamsDTO paramsDTO) {
        if (Objects.isNull(currentUser) || Objects.isNull(ip)) {
            log.warn("Cannot getLocalUserIp or user, mspId {}, logkey: {}", (Object)mspId, (Object)auditLogKey);
            return;
        }
        String operator = currentUser.getUsernameOrCloudAccount().orElse("");
        if (!this.a(mspId, auditLogKey, operator, ip)) {
            return;
        }
        if (Objects.isNull((Object)AuditLogResourceEnum.a(resourceCode))) {
            log.warn("invalid auditLog resource code : {} of mspId : {} auditLogKey : {}", new Object[]{resourceCode, mspId, auditLogKey});
            return;
        }
        log.info("start to send msp auditLog , mspId : {} , auditLogKey : {}", (Object)mspId, (Object)auditLogKey);
        this.auditLogApiService.a(mspId, auditLogKey, operator, resourceCode, ip, System.currentTimeMillis(), paramsDTO);
    }

    private boolean a(String omadacId, String auditLogKey, String operator, String ip) {
        if (StringUtils.isEmpty((CharSequence)omadacId) || StringUtils.isEmpty((CharSequence)auditLogKey) || StringUtils.isEmpty((CharSequence)operator) || StringUtils.isEmpty((CharSequence)ip)) {
            log.warn("Audit Log send failed Error.OmadacId {}, auditLogKey {}, operator {}, ip {}", new Object[]{omadacId, auditLogKey, operator, com.tplink.smb.omada.common.util.e.a.c((String)ip)});
            return false;
        }
        return true;
    }

    private Integer a(boolean success, Integer resErrCode, String auditLogKey) {
        if (success) {
            return OperateResultEnum.a.a();
        }
        if (!d.d.containsKey(auditLogKey)) {
            return OperateResultEnum.b.a();
        }
        Set errCodes = (Set)d.d.get(auditLogKey);
        return errCodes.contains(resErrCode) ? OperateResultEnum.a.a() : OperateResultEnum.b.a();
    }
}

