/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.sso.internal.c;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.identityaccess.api.internal.dto.SsoAssertionDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.SsoSubjectInfoDTO;
import com.tplink.smb.omada.identityaccess.port.common.config.SsoProps;
import com.tplink.smb.omada.identityaccess.sso.internal.c.a;
import com.tplink.smb.omada.identityaccess.sso.internal.c.b;
import com.tplink.smb.omada.identityaccess.sso.internal.c.c;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class d {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(d.class);
    @Autowired
    private SsoProps b;
    @Autowired
    private com.tplink.smb.omada.identityaccess.domain.model.sso.config.a c;
    @Autowired
    private CacheService d;
    @Autowired
    private com.tplink.smb.omada.identityaccess.central.a.c e;
    private static final String f = "username";
    private static final String g = "usergroup_name";
    private static final String h = "resource_attribute";
    private static final String i = "omada_attribute";
    private static final String j = "x";
    private static final String k = "/login?accessToken=";

    @PostConstruct
    public void a() throws InitializationException, ComponentInitializationException {
        InitializationService.initialize();
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        if (registry == null) {
            a.warn("GlobalParserPoolInitializer init failed,cannot find XMLObjectProviderRegistry");
            return;
        }
        BasicParserPool parserPool = new BasicParserPool();
        Map builderFeatures = parserPool.getBuilderFeatures();
        builderFeatures.put("http://apache.org/xml/features/dom/defer-node-expansion", false);
        parserPool.setMaxPoolSize(this.b.getJaxpPoolMaxSize().intValue());
        parserPool.initialize();
        registry.setParserPool((ParserPool)parserPool);
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public OperationResponse<SsoSubjectInfoDTO> a(SsoAssertionDTO ssoAssertionDTO) {
        Response samlResponse;
        String samlResponseStr = ssoAssertionDTO.getSamlResponse();
        String relayState = ssoAssertionDTO.getRelayState();
        try {
            samlResponse = this.a(samlResponseStr, relayState);
        }
        catch (Exception e2) {
            a.error("Failed to get saml response {} {}.", new Object[]{samlResponseStr, relayState, e2});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        c relayStateInfo = com.tplink.smb.omada.identityaccess.sso.internal.c.c.a(relayState);
        if (relayStateInfo == null) {
            a.warn("RelayStateInfo is null");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OperationResponse<SsoSubjectInfoDTO> subjectInfoOps = this.a(samlResponse, relayStateInfo);
        if (!subjectInfoOps.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        SsoSubjectInfoDTO subjectInfo = (SsoSubjectInfoDTO)subjectInfoOps.getResult();
        String controllerId = subjectInfo.getControllerId();
        String redirectUrl = this.c.e() + controllerId + k;
        subjectInfo.setRedirectUrl(redirectUrl);
        a.info("subjectInfo: {}", (Object)subjectInfo);
        return OperationResponse.success((Object)subjectInfo);
    }

    private OperationResponse<SsoSubjectInfoDTO> a(Response samlResponse, c relayStateInfo) {
        String controllerId = relayStateInfo.b();
        String resourceId = relayStateInfo.a();
        OperationResponse validateSamlVersionOps = this.a(samlResponse);
        if (!validateSamlVersionOps.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OperationResponse validateStatusCodeOps = this.b(samlResponse);
        if (!validateStatusCodeOps.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OperationResponse detail = this.e.b(controllerId, resourceId);
        if (!detail.success()) {
            a.error("cannot find idp config, controllerId: {}, idpId: {}", (Object)controllerId, (Object)resourceId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        com.tplink.smb.omada.identityaccess.sso.internal.b.c idpMetadata = (com.tplink.smb.omada.identityaccess.sso.internal.b.c)detail.getResult();
        if (!Objects.isNull(idpMetadata.h().a()) && !Objects.isNull(idpMetadata.i().a())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        Assertion assertion = (Assertion)samlResponse.getAssertions().get(0);
        OperationResponse verifyAssertionSignatureOps = this.a(assertion, idpMetadata.f().a());
        if (!verifyAssertionSignatureOps.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OperationResponse validateAssertionOps = this.a(assertion);
        if (!validateAssertionOps.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        SsoSubjectInfoDTO subjectInfo = new SsoSubjectInfoDTO();
        subjectInfo.setControllerId(controllerId);
        subjectInfo.setResourceId(resourceId);
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements.isEmpty()) {
            a.error("Fail.getSubjectInfoFromSamlResponse. attribute is empty. [controllerId={}, resourceId={}]", (Object)controllerId, (Object)resourceId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        for (Attribute attribute : ((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes()) {
            if (f.equals(attribute.getName())) {
                if (CollectionUtils.isEmpty((Collection)attribute.getAttributeValues())) continue;
                if (attribute.getAttributeValues().get(0) instanceof XSStringImpl) {
                    subjectInfo.setUsername(((XSString)attribute.getAttributeValues().get(0)).getValue());
                } else {
                    subjectInfo.setUsername(((XSAny)attribute.getAttributeValues().get(0)).getTextContent());
                }
            }
            if (!g.equals(attribute.getName()) || CollectionUtils.isEmpty((Collection)attribute.getAttributeValues())) continue;
            if (attribute.getAttributeValues().get(0) instanceof XSStringImpl) {
                subjectInfo.setUserGroupName(((XSString)attribute.getAttributeValues().get(0)).getValue());
                continue;
            }
            subjectInfo.setUserGroupName(((XSAny)attribute.getAttributeValues().get(0)).getTextContent());
        }
        if (T.a((String)subjectInfo.getUsername()) || T.a((String)subjectInfo.getUserGroupName())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        return OperationResponse.success((Object)subjectInfo);
    }

    private OperationResponse a(Response samlResponse) {
        if (!SAMLVersion.VERSION_20.equals(samlResponse.getVersion())) {
            a.warn("Invalid SAML Version {}", (Object)samlResponse.getVersion().toString());
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse b(Response samlResponse) {
        String statusCode = samlResponse.getStatus().getStatusCode().getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
            a.warn("Invalid Response Status: {}", (Object)statusCode);
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse a(Assertion assertion) {
        Instant instant = assertion.getIssueInstant();
        DateTime issueInstant = new DateTime(instant.toEpochMilli());
        if (issueInstant == null) {
            a.warn("issue instant not present in assertion");
            return OperationResponse.PARAM_ERROR;
        }
        SubjectConfirmationData subjectConfirmationData = ((SubjectConfirmation)assertion.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData();
        DateTime now = new DateTime(DateTimeZone.UTC);
        DateTime latestValid = now.plus((long)this.b.getClockSkewMs().intValue());
        DateTime expiration = this.a(issueInstant, subjectConfirmationData);
        if (issueInstant.isAfter((ReadableInstant)latestValid)) {
            a.warn("Message was not yet valid: message time was {}, latest valid is: {}", (Object)issueInstant, (Object)latestValid);
            return OperationResponse.PARAM_ERROR;
        }
        if (expiration.isBefore((ReadableInstant)now)) {
            a.warn("Message was expired: message time was '{}', message expired at: '{}', current time: '{}'", new Object[]{issueInstant, expiration, now});
            return OperationResponse.PARAM_ERROR;
        }
        return this.a(assertion, expiration);
    }

    private DateTime a(DateTime issueInstant, SubjectConfirmationData subjectConfirmationData) {
        Instant instant = subjectConfirmationData.getNotOnOrAfter();
        DateTime expiration = new DateTime(instant.toEpochMilli());
        DateTime customExpiration = issueInstant.plus((long)this.b.getMessageLifetimeMs().intValue());
        if (expiration == null || expiration.isAfter((ReadableInstant)customExpiration)) {
            expiration = customExpiration;
            a.error("SubjectConfirmationData might be invalid: {}", (Object)com.tplink.smb.omada.identityaccess.sso.internal.c.b.a((XMLObject)subjectConfirmationData));
        }
        expiration = expiration.plus((long)this.b.getClockSkewMs().intValue());
        return expiration;
    }

    private OperationResponse a(Assertion assertion, DateTime expiration) {
        if (T.a((String)assertion.getID())) {
            a.warn("Assertion ID cannot be empty");
            return OperationResponse.PARAM_ERROR;
        }
        if (!Objects.isNull(this.d.get("identityaccess:sso:assertion", com.tplink.smb.omada.identityaccess.domain.model.e.b.a((String[])new String[]{assertion.getID()}), String.class))) {
            a.warn("Replay detected of message ID '{}' from issuer '{}'", (Object)assertion.getID(), (Object)assertion.getIssuer().getValue());
            return OperationResponse.PARAM_ERROR;
        }
        long expires = expiration.getMillis() - System.currentTimeMillis();
        if (expires <= 0L) {
            return OperationResponse.PARAM_ERROR;
        }
        this.d.set("identityaccess:sso:assertion", com.tplink.smb.omada.identityaccess.domain.model.e.b.a((String[])new String[]{assertion.getID()}), (Object)j, expires, TimeUnit.MILLISECONDS);
        return OperationResponse.SUCCESS;
    }

    private OperationResponse a(Assertion assertion, String x509Certificate) {
        if (!assertion.isSigned() || assertion.getSignature() == null) {
            a.warn("The SAML Assertion was not signed");
            return OperationResponse.PARAM_ERROR;
        }
        try {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            profileValidator.validate(assertion.getSignature());
            SignatureValidator.validate((Signature)assertion.getSignature(), (Credential)com.tplink.smb.omada.identityaccess.sso.internal.c.a.a(x509Certificate));
        }
        catch (CertificateException | SignatureException e2) {
            a.error("validate signature failed,assertion: {}", (Object)com.tplink.smb.omada.identityaccess.sso.internal.c.b.a((XMLObject)assertion), (Object)e2);
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse<Assertion> a(Response samlResponse, Credential credential) {
        Assertion assertion;
        if (samlResponse.getEncryptedAssertions() == null || samlResponse.getEncryptedAssertions().size() != 1) {
            a.warn("Invalid EncryptedAssertions");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        EncryptedAssertion encryptedAssertion = (EncryptedAssertion)samlResponse.getEncryptedAssertions().get(0);
        StaticKeyInfoCredentialResolver keyInfoCredentialResolver = new StaticKeyInfoCredentialResolver(credential);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyInfoCredentialResolver, (EncryptedKeyResolver)new InlineEncryptedKeyResolver());
        decrypter.setRootInNewDocument(true);
        try {
            assertion = decrypter.decrypt(encryptedAssertion);
        }
        catch (DecryptionException e2) {
            a.error("cannot decrypt encryptedAssertion: {}", (Object)com.tplink.smb.omada.identityaccess.sso.internal.c.b.a((XMLObject)encryptedAssertion), (Object)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        return OperationResponse.success((Object)assertion);
    }

    private Response a(String samlResponseStr, String relayState) throws UnmarshallingException, XMLParserException, DecodingException {
        MessageContext messageContext = new MessageContext();
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)relayState);
        byte[] decodedBytes = Base64Support.decode((String)samlResponseStr);
        ByteArrayInputStream base64DecodedMessage = new ByteArrayInputStream(decodedBytes);
        ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();
        SAMLObject inboundMessage = (SAMLObject)XMLObjectSupport.unmarshallFromInputStream((ParserPool)parserPool, (InputStream)base64DecodedMessage);
        messageContext.setMessage((Object)inboundMessage);
        return (Response)messageContext.getMessage();
    }
}

