/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.storage.mongo.file;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.tplink.smb.component.storage.api.repository.FileRepository;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;

public class FileMongoRepositoryImpl
implements FileRepository {
    private static final Logger log = LoggerFactory.getLogger(FileMongoRepositoryImpl.class);
    private final GridFsTemplate gridFsTemplate;
    private final MongoTemplate mongoTemplate;

    public FileMongoRepositoryImpl(GridFsTemplate gridFsTemplate, MongoTemplate mongoTemplate) {
        this.gridFsTemplate = gridFsTemplate;
        this.mongoTemplate = mongoTemplate;
    }

    public String saveFile(String prefix, Map<String, String> metadata, String fileName, @Nonnull InputStream in) {
        if (metadata == null) {
            metadata = new HashMap<String, String>();
        }
        metadata.putIfAbsent("prefix", prefix);
        ObjectId fileId = this.gridFsTemplate.store(in, fileName, metadata);
        return fileId.toString();
    }

    public String saveGlobalFile(String prefix, @Nullable Map<String, String> metadata, String fileName, @Nonnull InputStream in, @Nullable Integer day) {
        if (metadata == null) {
            metadata = new HashMap<String, String>();
        }
        metadata.putIfAbsent("prefix", prefix);
        ObjectId fileId = this.gridFsTemplate.store(in, fileName, metadata);
        return fileId.toString();
    }

    @Nullable
    public String saveGlobalFile(String prefix, @Nullable Map<String, String> metadata, String fileName, @Nonnull InputStream in, @Nullable Integer day, @Nullable Long contentLength) {
        return this.saveGlobalFile(prefix, metadata, fileName, in, day);
    }

    public String saveFile(String prefix, @Nullable Map<String, String> metadata, String fileName, @Nonnull InputStream in, int day) {
        if (metadata == null) {
            metadata = new HashMap<String, String>();
        }
        metadata.putIfAbsent("prefix", prefix);
        ObjectId fileId = this.gridFsTemplate.store(in, fileName, metadata);
        return fileId.toString();
    }

    @Nullable
    public String saveFile(String prefix, @Nullable Map<String, String> metadata, String fileName, @Nonnull InputStream in, @Nullable Integer day, @Nullable Long contentLength) {
        return this.saveFile(prefix, metadata, fileName, in);
    }

    @Nullable
    @Deprecated
    public InputStream readFile(@Nonnull String fileId) {
        try {
            GridFsResource gridFsResource = this.loadGridFSFileById(fileId);
            if (gridFsResource == null) {
                return null;
            }
            return gridFsResource.getInputStream();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public boolean readFile(@Nonnull String fileId, Consumer<InputStream> consumer) {
        try {
            GridFsResource gridFsResource = this.loadGridFSFileById(fileId);
            if (gridFsResource == null) {
                return false;
            }
            try (InputStream inputStream = gridFsResource.getInputStream();){
                consumer.accept(inputStream);
            }
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <R> R readFile(@Nonnull String fileId, Function<InputStream, R> function) {
        try {
            GridFsResource gridFsResource = this.loadGridFSFileById(fileId);
            if (gridFsResource == null) {
                return null;
            }
            try (InputStream inputStream = gridFsResource.getInputStream();){
                R r = function.apply(inputStream);
                return r;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean readFile(@Nonnull String fileId, OutputStream outputStream) {
        try {
            GridFsResource gridFsResource = this.loadGridFSFileById(fileId);
            if (gridFsResource == null) {
                return false;
            }
            try (InputStream inputStream = gridFsResource.getInputStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getDownloadURL(@Nonnull String fileId, Function<String, String> urlBuilder) {
        return urlBuilder.apply(fileId);
    }

    public boolean deleteFile(@Nonnull String fileId) {
        this.gridFsTemplate.delete(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)fileId)));
        return this.gridFsTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)fileId))) == null;
    }

    public List<String> deleteMultiFiles(@Nonnull List<String> fileIds) {
        this.gridFsTemplate.delete(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(fileIds)));
        return fileIds;
    }

    public long getSize(List<String> keys) {
        try {
            long size = 0L;
            for (String key : keys) {
                GridFSFile fsFile = this.gridFsTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(new Object[]{key})));
                if (fsFile == null) {
                    log.error("File {} does not exist", (Object)key);
                    continue;
                }
                size += fsFile.getLength();
            }
            return size;
        }
        catch (MongoException e) {
            log.debug("MongoException", (Throwable)e);
            return 0L;
        }
    }

    @Nullable
    private GridFsResource loadGridFSFileById(String fileId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)fileId));
        GridFSFile gridFSFile = this.gridFsTemplate.findOne(query);
        if (gridFSFile == null) {
            log.debug("file {} does not exist", (Object)fileId);
            return null;
        }
        return this.gridFsTemplate.getResource(gridFSFile);
    }

    public String findOneByPrefixAndFileName(String prefix, String fileName) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"filename").is((Object)fileName));
        GridFSFile gridFSFile = this.gridFsTemplate.findOne(query);
        if (gridFSFile == null) {
            log.debug("file {} does not exist", (Object)fileName);
            return null;
        }
        return gridFSFile.getObjectId().toString();
    }

    public String getFileName(String key) {
        GridFSFile gridFSFile = this.gridFsTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)key)));
        if (gridFSFile == null) {
            log.debug("file {} does not exist", (Object)key);
            return null;
        }
        return gridFSFile.getFilename();
    }

    public long getSizeSummary(String key, String value) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"metadata").elemMatch(Criteria.where((String)key).regex(value)));
        GridFSFindIterable gridFSFiles = this.gridFsTemplate.find(query);
        MongoCursor gridFSFileIterator = gridFSFiles.iterator();
        long sum = 0L;
        while (gridFSFileIterator.hasNext()) {
            sum += ((GridFSFile)gridFSFileIterator.next()).getLength();
        }
        return sum;
    }

    public long getGridFsSize() {
        try {
            MongoDatabase mongoDatabase = this.mongoTemplate.getDb();
            Document result = mongoDatabase.runCommand((Bson)new Document("collStats", (Object)"fs.chunks"));
            return result.getInteger((Object)"size", 0);
        }
        catch (MongoException e) {
            log.debug("MongoException", (Throwable)e);
            return 0L;
        }
    }

    public int releaseFileSpace() {
        try {
            if (!this.collectionExists("fs.chunks")) {
                log.warn("Collection {} is not exists", (Object)"fs.chunks");
                return 0;
            }
            MongoDatabase mongoDatabase = this.mongoTemplate.getDb();
            Document result = mongoDatabase.runCommand((Bson)new Document("collStats", (Object)"fs.chunks"));
            mongoDatabase.runCommand((Bson)new Document("compact", (Object)"fs.chunks"));
            return result.getInteger((Object)"wiredTiger.block-manager.file bytes available for reuse", 0);
        }
        catch (MongoException e) {
            log.error("MongoException", (Throwable)e);
            return 0;
        }
    }

    private boolean collectionExists(String collectionName) {
        Set collectionNames = this.mongoTemplate.getCollectionNames();
        for (String name : collectionNames) {
            if (!name.equalsIgnoreCase(collectionName)) continue;
            return true;
        }
        return false;
    }
}

