/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.pii.utils;

import com.tplink.nbu.common.pii.strategy.AESStrategy;
import com.tplink.nbu.common.pii.strategy.SHA256Strategy;
import java.text.NumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PIIMaskUtil {
    private static final Logger log = LoggerFactory.getLogger(PIIMaskUtil.class);
    private static final char HIDDEN_CHAR = '*';
    private static final String MASK_STR = "******";

    public static String mask() {
        return MASK_STR;
    }

    public static String partMask(String info, int showHeadLength, int showTailLength) {
        if (showHeadLength < 0 || showTailLength < 0) {
            throw new IllegalArgumentException("Length should not be minus.");
        }
        int infoLength = info.length();
        if (infoLength < showHeadLength + showTailLength) {
            throw new IllegalArgumentException("show length is longer than info's length.");
        }
        StringBuilder stringBuilder = new StringBuilder(info);
        for (int i = showHeadLength; i < infoLength - showTailLength; ++i) {
            stringBuilder.setCharAt(i, '*');
        }
        return stringBuilder.toString();
    }

    public static String encrypt(String info) {
        AESStrategy strategy = AESStrategy.getInstance();
        return strategy.serialize(info);
    }

    public static String decrypt(String secret) {
        AESStrategy strategy = AESStrategy.getInstance();
        return strategy.deserialize(secret);
    }

    public static String hash(String info) {
        SHA256Strategy strategy = SHA256Strategy.getInstance();
        return strategy.serialize(info);
    }

    public static double trunc(double info, int truncDigitNumber) {
        if (truncDigitNumber > 0) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMaximumFractionDigits(truncDigitNumber);
            return Double.parseDouble(numberFormat.format(info));
        }
        double digits = Math.pow(10.0, -truncDigitNumber);
        return (double)Math.round(info / digits) * digits;
    }

    private PIIMaskUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

