/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.pii.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.nbu.common.pii.jackson.PIIObjectMapper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PIIJacksonUtil {
    private static final Logger log = LoggerFactory.getLogger(PIIJacksonUtil.class);
    private static final ObjectMapper objectMapper = PIIObjectMapper.getInstance();

    public static String parseToStr(Object data) {
        if (data == null) {
            return null;
        }
        if (!objectMapper.canSerialize(data.getClass())) {
            log.warn("class {} can not be converted.", (Object)data.getClass().getName());
            return null;
        }
        try {
            return objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            log.error("data can not parse to string {} of class.", data.getClass(), (Object)e);
            return null;
        }
    }

    public static String maskPIIStr(String jsonStr, Map<String, PIIMaskStrategy> strategyMap) {
        if (StringUtils.isEmpty((CharSequence)jsonStr) || strategyMap == null || strategyMap.isEmpty()) {
            return jsonStr;
        }
        DocumentContext context = JsonPath.parse((String)jsonStr);
        for (Map.Entry<String, PIIMaskStrategy> entry : strategyMap.entrySet()) {
            try {
                JsonPath path = JsonPath.compile((String)entry.getKey(), (Predicate[])new Predicate[0]);
                context.map(path, (o, configuration) -> ((PIIMaskStrategy)((Object)((Object)entry.getValue()))).desensitise(o));
            }
            catch (PathNotFoundException e) {
                log.debug("Path not found {}", (Object)e.getMessage());
            }
            catch (InvalidPathException e) {
                log.error("Invalid json path: {}", (Object)entry.getKey(), (Object)e);
            }
        }
        return context.jsonString();
    }

    private PIIJacksonUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

