/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.pii.utils;

import com.tplink.nbu.common.annotation.Experimental;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public final class PIIDesObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(PIIDesObjectUtil.class);
    private static final String SERIAL_VERSION_UID_FIELD_NAME = "serialVersionUID";
    private static final String JAVAX_PREFIX = "javax.";
    private static final String JAVA_PREFIX = "java.";

    public static <T> T getDesObject(T piiObject) {
        if (null != piiObject) {
            try {
                if (piiObject.getClass().isInterface()) {
                    return piiObject;
                }
                HashSet<Integer> referenceCounter = new HashSet<Integer>();
                T clone = PIIDesObjectUtil.replace(PIIDesObjectUtil.getAllFields(piiObject), piiObject, referenceCounter);
                referenceCounter.clear();
                return clone;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Desensitise failed. ", (Throwable)e);
            }
        }
        return null;
    }

    private static <T> T replace(Field[] fields, T javaBean, Set<Integer> referenceCounter) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Object clone = javaBean.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (null != fields && fields.length > 0) {
            for (Field field : fields) {
                Object value = field.get(javaBean);
                if (null == value) continue;
                Class<?> type = value.getClass();
                if (type.isArray()) {
                    PIIDesObjectUtil.setArrayValueForField(clone, field, value, type, referenceCounter);
                    continue;
                }
                if (value instanceof Collection) {
                    PIIDesObjectUtil.setCollectionValueForField(clone, field, (Collection)value, referenceCounter);
                    continue;
                }
                if (value instanceof Map) {
                    PIIDesObjectUtil.setMapValueForField(clone, field, (Map)value, referenceCounter);
                    continue;
                }
                if (PIIDesObjectUtil.isNotGeneralType(type, value, referenceCounter)) {
                    field.set(clone, PIIDesObjectUtil.replace(PIIDesObjectUtil.getAllFields(value), value, referenceCounter));
                    continue;
                }
                PIIDesObjectUtil.setNewValueForField(clone, field, value);
            }
        }
        return (T)clone;
    }

    private static boolean isNotGeneralType(Class<?> clazz, Object value, Set<Integer> referenceCounter) {
        return !clazz.isPrimitive() && clazz.getPackage() != null && !clazz.isEnum() && !StringUtils.startsWith((CharSequence)clazz.getPackage().getName(), (CharSequence)JAVAX_PREFIX) && !StringUtils.startsWith((CharSequence)clazz.getPackage().getName(), (CharSequence)JAVA_PREFIX) && !StringUtils.startsWith((CharSequence)clazz.getName(), (CharSequence)JAVAX_PREFIX) && !StringUtils.startsWith((CharSequence)clazz.getName(), (CharSequence)JAVA_PREFIX) && referenceCounter.add(value.hashCode());
    }

    private static <T> void setCollectionValueForField(T clone, Field field, Collection<?> value, Set<Integer> referenceCounter) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Collection newCollection = (Collection)value.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        PII annotation = field.getAnnotation(PII.class);
        if (PIIDesObjectUtil.isSensitive(annotation)) {
            PIIMaskStrategy strategy = annotation.strategy();
            for (Object collectionObj : value) {
                if (PIIDesObjectUtil.isNotGeneralType(collectionObj.getClass(), collectionObj, referenceCounter)) {
                    newCollection.add(PIIDesObjectUtil.replace(PIIDesObjectUtil.getAllFields(collectionObj), collectionObj, referenceCounter));
                    continue;
                }
                newCollection.add(strategy.serialize(collectionObj));
            }
        } else {
            for (Object collectionObj : value) {
                if (PIIDesObjectUtil.isNotGeneralType(collectionObj.getClass(), collectionObj, referenceCounter)) {
                    newCollection.add(PIIDesObjectUtil.replace(PIIDesObjectUtil.getAllFields(collectionObj), collectionObj, referenceCounter));
                    continue;
                }
                newCollection.add(collectionObj);
            }
        }
        field.set(clone, newCollection);
    }

    private static void setArrayValueForField(Object clone, Field field, Object value, Class<?> type, Set<Integer> referenceCounter) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        int len = Array.getLength(value);
        Object newArray = Array.newInstance(type.getComponentType(), len);
        PII annotation = field.getAnnotation(PII.class);
        if (PIIDesObjectUtil.isSensitive(annotation)) {
            PIIMaskStrategy strategy = annotation.strategy();
            for (int i = 0; i < len; ++i) {
                Object arrayObject = Array.get(value, i);
                if (PIIDesObjectUtil.isNotGeneralType(arrayObject.getClass(), arrayObject, referenceCounter)) {
                    Array.set(newArray, i, PIIDesObjectUtil.replace(PIIDesObjectUtil.getAllFields(arrayObject), arrayObject, referenceCounter));
                    continue;
                }
                Array.set(newArray, i, strategy.serialize(arrayObject));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                Object arrayObject = Array.get(value, i);
                if (PIIDesObjectUtil.isNotGeneralType(arrayObject.getClass(), arrayObject, referenceCounter)) {
                    Array.set(newArray, i, PIIDesObjectUtil.replace(PIIDesObjectUtil.getAllFields(arrayObject), arrayObject, referenceCounter));
                    continue;
                }
                Array.set(newArray, i, arrayObject);
            }
        }
        field.set(clone, newArray);
    }

    private static void setMapValueForField(Object clone, Field field, Map<?, ?> value, Set<Integer> referenceCounter) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Set<Map.Entry<?, ?>> set = value.entrySet();
        Map newMap = (Map)value.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        PII annotation = field.getAnnotation(PII.class);
        if (PIIDesObjectUtil.isSensitive(annotation)) {
            PIIMaskStrategy strategy = annotation.strategy();
            Iterator<Map.Entry<?, ?>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<?, ?> entrySet;
                Map.Entry<?, ?> entry = entrySet = iterator.next();
                Object mapKey = entry.getKey();
                Object mapVal = entry.getValue();
                if (PIIDesObjectUtil.isNotGeneralType(mapVal.getClass(), mapVal, referenceCounter)) {
                    newMap.put(mapKey, PIIDesObjectUtil.replace(PIIDesObjectUtil.getAllFields(mapVal), mapVal, referenceCounter));
                    continue;
                }
                newMap.put(mapKey, strategy.serialize(mapVal));
            }
        } else {
            Iterator<Map.Entry<?, ?>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<?, ?> entrySet;
                Map.Entry<?, ?> entry = entrySet = iterator.next();
                Object mapKey = entry.getKey();
                Object mapVal = entry.getValue();
                if (PIIDesObjectUtil.isNotGeneralType(mapVal.getClass(), mapVal, referenceCounter)) {
                    newMap.put(mapKey, PIIDesObjectUtil.replace(PIIDesObjectUtil.getAllFields(mapVal), mapVal, referenceCounter));
                    continue;
                }
                newMap.put(mapKey, mapVal);
            }
        }
        field.set(clone, newMap);
    }

    private static void setNewValueForField(Object clone, Field field, Object value) throws IllegalAccessException {
        PII annotation = field.getAnnotation(PII.class);
        if (PIIDesObjectUtil.isSensitive(annotation)) {
            PIIMaskStrategy strategy = annotation.strategy();
            field.set(clone, strategy.serialize(value));
        } else {
            field.set(clone, value);
        }
    }

    private static boolean isSensitive(PII annotation) {
        return null != annotation && !annotation.isExclude();
    }

    private static Field[] getAllFields(Object objSource) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> tempClass = objSource.getClass();
        while (tempClass.getSuperclass() != null) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            tempClass = tempClass.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        Iterator iterator = fieldList.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            String fieldName = field.getName();
            if (!SERIAL_VERSION_UID_FIELD_NAME.equals(fieldName)) {
                field.setAccessible(true);
                fields[index] = field;
            }
            ++index;
        }
        return fields;
    }

    private PIIDesObjectUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

