/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.pii.strategy;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.encoders.Hex;

public class SHA256Strategy {
    private static volatile SHA256Strategy instance;
    private final String salt;

    private SHA256Strategy(String salt) {
        this.salt = salt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SHA256Strategy initInstance(String salt) {
        if (instance != null) return instance;
        Class<SHA256Strategy> clazz = SHA256Strategy.class;
        synchronized (SHA256Strategy.class) {
            if (instance != null) return instance;
            instance = new SHA256Strategy(salt);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static SHA256Strategy getInstance() {
        if (instance == null) {
            throw new IllegalStateException("No SHA256Strategy instance has been inited.");
        }
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public String serialize(String secret) {
        SHA256Digest digest = new SHA256Digest();
        byte[] secretWithSalt = (this.salt == null ? secret : secret + this.salt).getBytes(StandardCharsets.UTF_8);
        digest.update(secretWithSalt, 0, secretWithSalt.length);
        byte[] sha256Bytes = new byte[digest.getDigestSize()];
        digest.doFinal(sha256Bytes, 0);
        return Hex.toHexString((byte[])sha256Bytes);
    }
}

