/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.pii.strategy;

import com.tplink.nbu.common.pii.exception.PIIMaskException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESStrategy {
    private static final Logger log = LoggerFactory.getLogger(AESStrategy.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int AES_KEY_LENGTH = 16;
    private static final int AES_IV_LENGTH = 16;
    private static volatile AESStrategy instance;
    private final byte[] secretKey;
    private final byte[] secretIV;
    private final SecretKeySpec secretKeySpec;
    private final IvParameterSpec iv;
    private final BouncyCastleProvider bc = new BouncyCastleProvider();

    private AESStrategy(byte[] secretKey, byte[] secretIV) {
        this.secretKey = secretKey;
        this.secretIV = secretIV;
        this.secretKeySpec = new SecretKeySpec(secretKey, KEY_ALGORITHM);
        this.iv = new IvParameterSpec(secretIV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initInstance(String secretKey, String secretIV) {
        if (instance != null) return;
        Class<AESStrategy> clazz = AESStrategy.class;
        synchronized (AESStrategy.class) {
            if (instance != null) return;
            if (secretKey == null || secretKey.length() != 16) {
                log.error("Key length is not 16");
                throw new IllegalArgumentException();
            }
            if (secretIV == null || secretIV.length() != 16) {
                log.error("IV length is not 16");
                throw new IllegalArgumentException();
            }
            instance = new AESStrategy(secretKey.getBytes(StandardCharsets.UTF_8), secretIV.getBytes(StandardCharsets.UTF_8));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static AESStrategy getInstance() {
        if (instance == null) {
            throw new IllegalStateException("No AESStrategy instance has been inited.");
        }
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public String deserialize(String secret) {
        try {
            Cipher aesDecryptCipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM, (Provider)this.bc);
            aesDecryptCipher.init(2, (Key)this.secretKeySpec, this.iv);
            byte[] decrypted = aesDecryptCipher.doFinal(Base64.decode((String)secret));
            return new String(decrypted);
        }
        catch (Exception e) {
            log.error("Decrypt secret fail:", (Throwable)e);
            throw new PIIMaskException("Decrypt Fail");
        }
    }

    public String serialize(String plain) {
        try {
            Cipher aesEncryptCipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM, (Provider)this.bc);
            aesEncryptCipher.init(1, (Key)this.secretKeySpec, this.iv);
            byte[] encrypted = aesEncryptCipher.doFinal(plain.getBytes(StandardCharsets.UTF_8));
            return Base64.toBase64String((byte[])encrypted);
        }
        catch (Exception e) {
            log.error("Encrypt secret fail:", (Throwable)e);
            throw new PIIMaskException("Encrypt Fail");
        }
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public byte[] getSecretIV() {
        return this.secretIV;
    }
}

