/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.pii.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.tplink.nbu.common.pii.jackson.handler.AnnotationHandler;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PIIJsonSerializer
extends JsonSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(PIIJsonSerializer.class);
    private final Annotation annotation;
    private final String name;
    private final AnnotationHandler handler;

    public PIIJsonSerializer(String name, Annotation annotation, AnnotationHandler handler) {
        this.name = name;
        this.annotation = annotation;
        this.handler = handler;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this.handler == null) {
            gen.writeObject(value);
            return;
        }
        Object result = this.handler.handle(this.annotation, this.name, value);
        gen.writeObject(result);
    }
}

