/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.pii.jackson.introspector;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.tplink.nbu.common.pii.jackson.handler.AnnotationHandler;
import com.tplink.nbu.common.pii.jackson.serializer.PIIJsonSerializer;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PIIAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private static final Logger log = LoggerFactory.getLogger(PIIAnnotationIntrospector.class);
    private static final long serialVersionUID = 5467427309980167371L;
    private Map<String, AnnotationHandler> annotationHandlerMap;

    public boolean isAnnotationBundle(Annotation ann) {
        if (ann.annotationType().equals(JsonSerialize.class)) {
            return false;
        }
        return super.isAnnotationBundle(ann);
    }

    public Object findSerializer(Annotated annotatedField) {
        if (this.annotationHandlerMap == null || this.annotationHandlerMap.isEmpty()) {
            return super.findSerializer(annotatedField);
        }
        for (Map.Entry<String, AnnotationHandler> entry : this.annotationHandlerMap.entrySet()) {
            Annotation annotation = this.getAnnotation(annotatedField, entry.getKey());
            if (annotation == null) continue;
            String fieldName = annotatedField.getName();
            if (fieldName.startsWith("get")) {
                String first = String.valueOf(fieldName.charAt(3)).toLowerCase();
                fieldName = first + fieldName.substring(4);
            }
            return new PIIJsonSerializer(fieldName, annotation, entry.getValue());
        }
        return super.findSerializer(annotatedField);
    }

    private Annotation getAnnotation(Annotated am, String clsName) {
        try {
            Class<?> cls = Class.forName(clsName);
            return am.getAnnotation(cls);
        }
        catch (Exception e) {
            log.error("getAnnotation error.", (Throwable)e);
            return null;
        }
    }

    public void addAnnotationHandler(Class<? extends Annotation> cls, AnnotationHandler annotationHandler) {
        if (this.annotationHandlerMap == null) {
            this.annotationHandlerMap = new HashMap<String, AnnotationHandler>();
        }
        this.annotationHandlerMap.put(cls.getName(), annotationHandler);
    }
}

