/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.pii.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.tplink.nbu.common.global.CustomObjectMapper;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.jackson.handler.PIIAnnotationHandler;
import com.tplink.nbu.common.pii.jackson.introspector.PIIAnnotationIntrospector;
import org.json.JSONObject;

public class PIIObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 4166500467243448054L;

    private PIIObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(JSONObject.class, (JsonDeserializer)new CustomObjectMapper.JSONObjectDeserializer());
        module.addSerializer(JSONObject.class, (JsonSerializer)new CustomObjectMapper.JSONObjectSerializer());
        this.registerModule((Module)module);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        PIIAnnotationIntrospector introspector = new PIIAnnotationIntrospector();
        PIIAnnotationHandler handler = new PIIAnnotationHandler();
        introspector.addAnnotationHandler(PII.class, handler);
        this.setAnnotationIntrospector((AnnotationIntrospector)introspector);
    }

    public static PIIObjectMapper getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final PIIObjectMapper INSTANCE = new PIIObjectMapper();

        private SingletonHolder() {
        }
    }
}

