/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.pii.constant;

import com.tplink.nbu.common.pii.strategy.AESStrategy;
import com.tplink.nbu.common.pii.strategy.SHA256Strategy;
import com.tplink.nbu.common.pii.utils.PIIMaskUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PIIMaskStrategy {
    HASH{

        @Override
        public Object serialize(Object pii) {
            if (pii instanceof String) {
                return SHA256Strategy.getInstance().serialize((String)pii);
            }
            return pii;
        }
    }
    ,
    ENCRYPT{

        @Override
        public Object serialize(Object pii) {
            if (pii instanceof String) {
                return AESStrategy.getInstance().serialize((String)pii);
            }
            return pii;
        }
    }
    ,
    TRUNC_2{

        @Override
        public Object serialize(Object pii) {
            if (pii instanceof Double) {
                return PIIMaskUtil.trunc((Double)pii, 2);
            }
            if (pii instanceof String) {
                try {
                    Double piiDouble = new Double((String)pii);
                    return PIIMaskUtil.trunc(piiDouble, 2);
                }
                catch (NumberFormatException e) {
                    log.debug("Failed to cast {} to double!", pii);
                }
            }
            return pii;
        }
    }
    ,
    TRUNC_INT_2{

        @Override
        public Object serialize(Object pii) {
            if (pii instanceof Number) {
                return ((Number)PIIMaskUtil.trunc(((Number)pii).doubleValue(), -2)).longValue();
            }
            if (pii instanceof String) {
                try {
                    Double piiDouble = Double.parseDouble((String)pii);
                    return ((Number)PIIMaskUtil.trunc(piiDouble, -2)).longValue();
                }
                catch (NumberFormatException e) {
                    log.debug("Failed to cast {} to double!", pii);
                }
            }
            return pii;
        }
    }
    ,
    MASK{

        @Override
        public Object serialize(Object pii) {
            if (pii instanceof String) {
                return PIIMaskUtil.mask();
            }
            return pii;
        }
    }
    ,
    NONE;

    private static final Logger log;

    public Object desensitise(Object pii) {
        if (pii instanceof Object[]) {
            Object[] piis = (Object[])pii;
            int arrayLength = piis.length;
            Object[] desensitiseInfos = new Object[arrayLength];
            for (int index = 0; index < arrayLength; ++index) {
                desensitiseInfos[index] = this.desensitise(piis[index]);
            }
            return desensitiseInfos;
        }
        if (pii instanceof Map) {
            Map sensitiveMap = (Map)pii;
            Set set = sensitiveMap.entrySet();
            HashMap desensitiseInfoMap = new HashMap(sensitiveMap.size());
            Iterator index = set.iterator();
            while (index.hasNext()) {
                Map.Entry entrySet;
                Map.Entry entry = entrySet = index.next();
                Object mapKey = entry.getKey();
                Object mapVal = entry.getValue();
                desensitiseInfoMap.put(mapKey, this.desensitise(mapVal));
            }
            return desensitiseInfoMap;
        }
        if (pii instanceof Collection) {
            Collection piiCollection = (Collection)pii;
            ArrayList<Object> desensitiseInfoList = new ArrayList<Object>(piiCollection.size());
            for (Object sensitive : piiCollection) {
                desensitiseInfoList.add(this.desensitise(sensitive));
            }
            return desensitiseInfoList;
        }
        return this.serialize(pii);
    }

    public Object serialize(Object pii) {
        return pii;
    }

    static {
        log = LoggerFactory.getLogger(PIIMaskStrategy.class);
    }
}

