/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.port.mongo.omada.vouchergroup;

import com.tplink.smb.omada.common.util.c.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.file.voucher.VoucherLogoPicturePO;
import com.tplink.smb.omada.portal.port.mongo.omada.voucher.VoucherGroupPO;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class VoucherGroupMaintRepository {
    private final MongoTemplate mongoTemplate = (MongoTemplate)com.tplink.smb.omada.common.spring.a.a((String)"clientMongoTemplate");
    private static final VoucherGroupMaintRepository instance = new VoucherGroupMaintRepository();

    public static VoucherGroupMaintRepository getInstance() {
        return instance;
    }

    private VoucherGroupMaintRepository() {
    }

    public void deleteAllByOmadacId(c omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        this.mongoTemplate.remove(query, VoucherGroupPO.class);
    }

    public List<VoucherGroupPO> findByOmadacIdAndSiteIdExcludeOmadacId(c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
        query.fields().exclude("omadac_id");
        return this.mongoTemplate.find(query, VoucherGroupPO.class);
    }

    public Optional<VoucherLogoPicturePO> findVoucherLogoPicture(c omadacId, d siteId, String voucherLogoPictureId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("_id").is((Object)voucherLogoPictureId));
        VoucherLogoPicturePO picturePO = (VoucherLogoPicturePO)this.mongoTemplate.findOne(query, VoucherLogoPicturePO.class);
        return Optional.ofNullable(picturePO);
    }

    public VoucherLogoPicturePO insertVoucherLogo(VoucherLogoPicturePO po) {
        return (VoucherLogoPicturePO)this.mongoTemplate.insert((Object)po);
    }

    public void iterateWithoutOmadacId(@NonNull c omadacId, @NonNull d siteId, @NonNull a<VoucherGroupPO> consumer) {
        if (omadacId == null) {
            throw new NullPointerException("omadacId is marked non-null but is null");
        }
        if (siteId == null) {
            throw new NullPointerException("siteId is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a())).cursorBatchSize(5000);
        query.fields().exclude("omadac_id");
        try (Stream stream = this.mongoTemplate.stream(query, VoucherGroupPO.class);){
            stream.forEach(arg_0 -> consumer.a(arg_0));
        }
    }

    public VoucherGroupPO save(VoucherGroupPO po) {
        return (VoucherGroupPO)this.mongoTemplate.save((Object)po);
    }

    public Collection<VoucherGroupPO> insertAll(List<VoucherGroupPO> groupList) {
        return this.mongoTemplate.insertAll(groupList);
    }

    public String nextId() {
        return ObjectId.get().toString();
    }
}

