/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.port.mongo.omada.portal;

import com.google.common.collect.ImmutableList;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.portal.port.mongo.omada.access.PortalAccessControlPO;
import com.tplink.smb.omada.portal.port.mongo.omada.freeauthpolicy.FreeAuthPolicyPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.BasePortalPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.file.BasePortalFilePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.file.page.PortalPagePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.file.page.PortalPageTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.file.pic.PortalPicturePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.file.pic.PortalPictureTemplatePO;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.CollectionUtils;

public class PortalMaintRepository {
    private static final PortalMaintRepository instance = new PortalMaintRepository();
    public static final ImmutableList<Integer> FACEBOOK_FAP_TYPES = ImmutableList.of((Object)2, (Object)3);
    private final MongoTemplate mongoTemplate = (MongoTemplate)a.a((String)"clientMongoTemplate");

    private PortalMaintRepository() {
    }

    public static PortalMaintRepository getInstance() {
        return instance;
    }

    public List<PortalPO> findPortals(c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
        return this.mongoTemplate.find(query, PortalPO.class);
    }

    public List<PortalPO> findAllPortals(c omadacId) {
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a())), PortalPO.class);
    }

    public Optional<PortalPO> findPortalByOmadacIdAndId(c omadacId, String portalId) {
        return Optional.ofNullable((PortalPO)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("_id").is((Object)portalId)), PortalPO.class));
    }

    public Optional<PortalPagePO> findPortalPage(c omadacId, d siteId, String portalPageId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("_id").is((Object)portalPageId));
        PortalPagePO pagePO = (PortalPagePO)this.mongoTemplate.findOne(query, PortalPagePO.class);
        return Optional.ofNullable(pagePO);
    }

    public Optional<PortalPagePO> findPortalPageById(String portalPageId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)portalPageId));
        PortalPagePO pagePO = (PortalPagePO)this.mongoTemplate.findOne(query, PortalPagePO.class);
        return Optional.ofNullable(pagePO);
    }

    public List<PortalPicturePO> findPortalPicturesByIdIn(Collection<String> portalPicIds) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(portalPicIds));
        return this.mongoTemplate.find(query, PortalPicturePO.class);
    }

    public Optional<PortalPicturePO> findPortalPicture(c omadacId, d siteId, String portalPicId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("_id").is((Object)portalPicId));
        PortalPicturePO picturePO = (PortalPicturePO)this.mongoTemplate.findOne(query, PortalPicturePO.class);
        return Optional.ofNullable(picturePO);
    }

    public Optional<PortalAccessControlPO> findAccessControl(c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
        return Optional.ofNullable((PortalAccessControlPO)this.mongoTemplate.findOne(query, PortalAccessControlPO.class));
    }

    public List<FreeAuthPolicyPO> findFreeAuthPolicies(c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
        return this.mongoTemplate.find(query, FreeAuthPolicyPO.class);
    }

    public void clearAllByOmadacId(c omadacId) {
        Query omadacQuery = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        this.mongoTemplate.remove(omadacQuery, PortalPO.class);
        this.mongoTemplate.remove(omadacQuery, FreeAuthPolicyPO.class);
        Query accessControlQuery = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("key").is((Object)"portalAccessControl"));
        this.mongoTemplate.remove(accessControlQuery, PortalAccessControlPO.class);
    }

    public void clearAllByOmadacIdAndSiteId(c omadacId, d siteId) {
        Query omadacQuery = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
        this.mongoTemplate.remove(omadacQuery, PortalPO.class);
        this.mongoTemplate.remove(omadacQuery, FreeAuthPolicyPO.class);
        Query accessControlQuery = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("key").is((Object)"portalAccessControl"));
        this.mongoTemplate.remove(accessControlQuery, PortalAccessControlPO.class);
    }

    public PortalPO insertPortal(PortalPO portal) {
        portal.setId(null);
        return (PortalPO)this.mongoTemplate.insert((Object)portal);
    }

    public void insertAccessControl(PortalAccessControlPO po) {
        if (po == null) {
            return;
        }
        po.setId(null);
        this.mongoTemplate.insert((Object)po);
    }

    public void saveAccessControl(PortalAccessControlPO po) {
        if (po == null) {
            return;
        }
        this.mongoTemplate.save((Object)po);
    }

    public FreeAuthPolicyPO insertFreeAuthPolicy(FreeAuthPolicyPO freeAuthPolicy) {
        freeAuthPolicy.setId(null);
        return (FreeAuthPolicyPO)this.mongoTemplate.insert((Object)freeAuthPolicy);
    }

    public List<FreeAuthPolicyPO> insertAllFreeAuthPolicies(List<FreeAuthPolicyPO> freeAuthPolicies) {
        return new ArrayList<FreeAuthPolicyPO>(this.mongoTemplate.insertAll(freeAuthPolicies));
    }

    public PortalPicturePO insertPic(PortalPicturePO po) {
        po.setId(null);
        return (PortalPicturePO)this.mongoTemplate.insert((Object)po);
    }

    public PortalPictureTemplatePO insertPicTemplate(PortalPictureTemplatePO po) {
        po.setId(null);
        return (PortalPictureTemplatePO)this.mongoTemplate.insert((Object)po);
    }

    public PortalPagePO insertPage(PortalPagePO po) {
        po.setId(null);
        return (PortalPagePO)this.mongoTemplate.insert((Object)po);
    }

    public PortalPageTemplatePO insertPageTemplate(PortalPageTemplatePO po) {
        po.setId(null);
        return (PortalPageTemplatePO)this.mongoTemplate.insert((Object)po);
    }

    public void saveAll(List<PortalPO> portalSettings) {
        portalSettings.forEach(arg_0 -> ((MongoTemplate)this.mongoTemplate).save(arg_0));
    }

    public void updatePortalFormAuthId(c omadacId, d siteId, String oldId, String newId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("form_auth.form_id").is((Object)oldId));
        Update update = Update.update((String)"form_auth.form_id", (Object)newId);
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, PortalPO.class);
    }

    public long sumPicSizeByOmadacId(String omadacId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.fields().include("file_size");
        return this.mongoTemplate.find(query, PortalPicturePO.class).stream().mapToLong(BasePortalFilePO::getFileSize).sum();
    }

    public long sumPageSizeByOmadacId(String omadacId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.fields().include("file_size");
        return this.mongoTemplate.find(query, PortalPagePO.class).stream().mapToLong(BasePortalFilePO::getFileSize).sum();
    }

    public void deleteFacebookWiFiFAPs(String omadacId) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("policy_type").in(FACEBOOK_FAP_TYPES)), FreeAuthPolicyPO.class);
    }

    public void savePic(@Nonnull PortalPicturePO portalPicturePO) {
        this.mongoTemplate.save((Object)portalPicturePO);
    }

    public void savePage(@Nonnull PortalPagePO portalPagePO) {
        this.mongoTemplate.save((Object)portalPagePO);
    }

    public List<PortalPO> findFacebookPortalsByOmadacId(String omadacId) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("auth_type").is((Object)7)), PortalPO.class);
    }

    public void removeFacebookFreeAuthPortalId() {
        this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)Criteria.where((String)"policy_type").is((Object)2)), (UpdateDefinition)new Update().unset("portal_id"), FreeAuthPolicyPO.class);
    }

    public void deletePortalByOmadacIdAndSiteIdAndId(c omadacId, d siteId, String portalId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("_id").is((Object)portalId));
        this.mongoTemplate.remove(query, PortalPO.class);
    }

    public void deleteFreeAuthPolicyByOmadacIdAndSiteIdAndId(c omadacId, d siteId, String policyId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("_id").is((Object)policyId));
        this.mongoTemplate.remove(query, FreeAuthPolicyPO.class);
    }

    public void deleteAllCustom(c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("template_id").isNull());
        this.mongoTemplate.remove(query, PortalPO.class);
    }

    public void deletePortals(List<PortalPO> pos) {
        if (CollectionUtils.isEmpty(pos)) {
            return;
        }
        Map<String, List<PortalPO>> grouped = pos.stream().collect(Collectors.groupingBy(BasePortalPO::getOmadacId));
        grouped.forEach((omadacId, list) -> {
            Query idsQuery = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is(omadacId).and("_id").in((Collection)list.stream().map(BasePortalPO::getId).collect(Collectors.toList())));
            this.mongoTemplate.remove(idsQuery, PortalPO.class);
        });
    }
}

