/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.port.mongo.data.statistic;

import com.tplink.smb.omada.client.port.mongo.data.f;
import com.tplink.smb.omada.client.port.mongo.data.statistic.a;
import com.tplink.smb.omada.common.gridquery.d;
import com.tplink.smb.omada.common.mongo.repository.s;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.portal.port.mongo.data.statistic.HotspotStatPO;
import jakarta.annotation.Nonnull;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class HotspotStatMaintRepository
extends s<HotspotStatPO>
implements f<HotspotStatPO> {
    private static final HotspotStatMaintRepository instance = new HotspotStatMaintRepository();
    private final MongoTemplate mongoTemplate = (MongoTemplate)com.tplink.smb.omada.common.spring.a.a((String)"dataClientMongoTemplate");
    private a<HotspotStatPO> clientDailyStatSliceStrategy = (a)com.tplink.smb.omada.common.spring.a.b(a.class);

    public static HotspotStatMaintRepository getInstance() {
        return instance;
    }

    private HotspotStatMaintRepository() {
    }

    public void deleteAllByOmadacId(c omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        this.iteratorCollections(collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public void insertAll(List<HotspotStatPO> list, String collectionName) {
        if (CollectionUtils.isEmpty(list) || !collectionName.startsWith(this.getCollectionNameOrPrefixIfSliced())) {
            return;
        }
        if (this.getCollectionNames().stream().noneMatch(c2 -> c2.a().equals(collectionName))) {
            this.ensureCollection(collectionName);
        }
        BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
        bulkOperations.insert(list);
        bulkOperations.execute();
    }

    public void saveAll(List<HotspotStatPO> list, String collectionName) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (list.stream().allMatch(po -> po.getId() == null)) {
            this.insertAll(list, collectionName);
        } else {
            list.forEach(po -> this.mongoTemplate.save(po, this.getCollectionNameForSave(po)));
        }
    }

    public void saveAllToOldCollection(List<HotspotStatPO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (list.stream().allMatch(po -> po.getId() == null)) {
            this.mongoTemplate.insertAll(list);
        } else {
            list.forEach(arg_0 -> ((MongoTemplate)this.mongoTemplate).save(arg_0));
        }
    }

    public long countByOmadacId(c omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollections(collectionName -> {
            long count = this.mongoTemplate.count(query, collectionName);
            total.addAndGet(count);
        });
        return total.get();
    }

    public long countByOmadacIdAndSiteId(c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollections(collectionName -> {
            long count = this.mongoTemplate.count(query, collectionName);
            total.addAndGet(count);
        });
        return total.get();
    }

    public List<HotspotStatPO> findByOmadacIdAndSiteIdAndStartBetweenWithPage(c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId, long start, long end, d queryPage) {
        if (start > end) {
            long tmp = start;
            start = end;
            end = tmp;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("time").gte((Object)start).lte((Object)end));
        query.fields().exclude("_id");
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"time")}));
        LinkedList<HotspotStatPO> result = new LinkedList<HotspotStatPO>();
        this.iteratorCollectionsByTimeAscWithSkip(start, end, query, (collectionName, decoratedQuery) -> result.addAll(this.mongoTemplate.find(decoratedQuery, this.getPOClass(), collectionName)));
        return result;
    }

    protected u<HotspotStatPO> getStrategy() {
        return this.clientDailyStatSliceStrategy;
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return HotspotStatPO.INDEX_DEFINITIONS;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "hotspotstat";
    }

    protected Class<HotspotStatPO> getPOClass() {
        return HotspotStatPO.class;
    }

    @Override
    public List<HotspotStatPO> findWithPageForBackup(@Nonnull String collectionName, c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId, long start, long end, d page) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("time").gte((Object)Math.min(start, end)).lte((Object)Math.max(start, end)));
        query.with((Pageable)PageRequest.of((int)page.a(), (int)page.b(), (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"time"}));
        query.fields().exclude("_id");
        return this.mongoTemplate.find(query, this.getPOClass(), collectionName);
    }

    @Override
    public List<String> getCollectionNameList() {
        return this.listCollectionNamesFromDB();
    }
}

