/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.port.mongo.data.authrecord;

import com.mongodb.client.MongoIterable;
import com.tplink.smb.omada.common.gridquery.b;
import com.tplink.smb.omada.common.gridquery.d;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.c.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.portal.port.mongo.data.authrecord.AuthRecordPO;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class AuthRecordMaintRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthRecordMaintRepository.class);
    private final MongoTemplate mongoTemplate = (MongoTemplate)com.tplink.smb.omada.common.spring.a.a((String)"dataClientMongoTemplate");
    private static final AuthRecordMaintRepository instance = new AuthRecordMaintRepository();
    public static final String AUTH_RECORD_CLIENT_MAC = "client_mac";
    public static final String AUTH_RECORD_CLIENT_NAME = "client_name";

    private AuthRecordMaintRepository() {
    }

    public static AuthRecordMaintRepository getInstance() {
        return instance;
    }

    public void deleteAllByOmadacId(c omadacId) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a())), AuthRecordPO.class);
    }

    public void insertAll(Collection<AuthRecordPO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(po -> po.setId(null));
        this.mongoTemplate.insertAll(list);
    }

    public void saveAll(List<AuthRecordPO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (list.stream().allMatch(po -> po.getId() == null)) {
            this.mongoTemplate.insertAll(list);
        } else {
            list.forEach(arg_0 -> ((MongoTemplate)this.mongoTemplate).save(arg_0));
        }
    }

    public long countByOmadacId(c omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        return this.mongoTemplate.count(query, AuthRecordPO.class);
    }

    public long countByOmadacIdAndSiteId(c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId.a()));
        return this.mongoTemplate.count(query, AuthRecordPO.class);
    }

    public List<AuthRecordPO> findByOmadacIdAndSiteIdAndStartBetweenWithPage(c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId, long start, long end, d queryPage) {
        if (start > end) {
            long tmp = start;
            start = end;
            end = tmp;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId.a()).and("start").gte((Object)start).lte((Object)end));
        query.fields().exclude("_id");
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"start")}));
        return this.mongoTemplate.find(query, AuthRecordPO.class);
    }

    public List<AuthRecordPO> findByOmadacIdWithPage(c omadacId, d queryPage) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"start")}));
        return this.mongoTemplate.find(query, AuthRecordPO.class);
    }

    public void queryForExport(c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId, b queryData, @Nonnull a<AuthRecordPO> consumer) {
        Map filterMap = queryData.f();
        Long timeStart = Optional.ofNullable(filterMap).map(filters -> filters.get("timeStart")).map(obj -> ((Number)obj).longValue()).orElse(null);
        Long timeEnd = Optional.ofNullable(filterMap).map(filters -> filters.get("timeEnd")).map(obj -> ((Number)obj).longValue()).orElse(null);
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId.a());
        ArrayList<Criteria> andCriteria = new ArrayList<Criteria>();
        if (Objects.nonNull(siteId)) {
            andCriteria.add(Criteria.where((String)"site").is((Object)siteId.a()));
        }
        if (timeStart != null || timeEnd != null) {
            Criteria timeCriteria = Criteria.where((String)"start");
            if (timeStart != null) {
                timeCriteria.gte((Object)timeStart);
            }
            if (timeEnd != null) {
                timeCriteria.lte((Object)timeEnd);
            }
            andCriteria.add(timeCriteria);
        }
        Query query = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{this.fillQueryData(andCriteria, queryData.f(), queryData), criteria}));
        String collectionName = this.mongoTemplate.getCollectionName(AuthRecordPO.class);
        MongoIterable iterable = this.mongoTemplate.getCollection(collectionName).find((Bson)query.getQueryObject()).batchSize(1000).sort((Bson)query.getSortObject()).map(src -> (AuthRecordPO)this.mongoTemplate.getConverter().read(AuthRecordPO.class, src));
        for (AuthRecordPO po : iterable) {
            consumer.a((Object)po);
        }
    }

    private Criteria fillQueryData(List<Criteria> andCriteria, Map<String, Object> filterMap, b queryData) {
        Criteria criteria = new Criteria();
        if (!CollectionUtils.isEmpty(filterMap)) {
            for (Map.Entry<String, Object> entry : filterMap.entrySet()) {
                this.handleAuthClientQuery(andCriteria, entry, queryData);
            }
        }
        if (andCriteria.size() > 0) {
            criteria.andOperator(andCriteria.toArray(new Criteria[0]));
        }
        ArrayList<Criteria> orCriteria = new ArrayList<Criteria>();
        if (Objects.nonNull(queryData.e())) {
            orCriteria.add(new Criteria(AUTH_RECORD_CLIENT_MAC).regex(T.g((String)queryData.e()), "i"));
            orCriteria.add(new Criteria(AUTH_RECORD_CLIENT_NAME).regex(T.g((String)queryData.e()), "i"));
            orCriteria.add(new Criteria("ssid_name").regex(T.g((String)queryData.e()), "i"));
            orCriteria.add(new Criteria("network_name").regex(T.g((String)queryData.e()), "i"));
            orCriteria.add(new Criteria("auth_admin").regex(T.g((String)queryData.e()), "i"));
            orCriteria.add(new Criteria("voucher.code").regex(T.g((String)queryData.e()), "i"));
            orCriteria.add(new Criteria("local_user.user_name").regex(T.g((String)queryData.e()), "i"));
            orCriteria.add(new Criteria("form_name").regex(T.g((String)queryData.e()), "i"));
            orCriteria.add(new Criteria("radius_client_info.username").is((Object)com.tplink.smb.omada.common.util.b.b.c((String)queryData.e())));
            for (com.tplink.smb.omada.maintenance.common.a authType : com.tplink.smb.omada.maintenance.common.a.values()) {
                String authTypeName = authType.x.toLowerCase(Locale.ROOT);
                if (authTypeName.contains(queryData.e().toLowerCase(Locale.ROOT))) {
                    orCriteria.add(new Criteria("auth_type").is((Object)authType.w));
                    continue;
                }
                this.tryAddAdditionalSearch(orCriteria, queryData.e(), authType, authTypeName);
            }
        }
        if (orCriteria.size() > 0) {
            criteria.orOperator(orCriteria.toArray(new Criteria[0]));
        }
        return criteria;
    }

    private void tryAddAdditionalSearch(List<Criteria> orCriteria, String searchKey, com.tplink.smb.omada.maintenance.common.a authType, String authTypeName) {
        int indexOf = searchKey.indexOf(45);
        if (indexOf <= 0 || indexOf >= searchKey.length()) {
            return;
        }
        String authTypeNameSearch = searchKey.substring(0, indexOf).trim();
        String additionSearch = searchKey.substring(indexOf + 1).trim();
        if (!authTypeName.contains(authTypeNameSearch.toLowerCase(Locale.ROOT))) {
            return;
        }
        String determineFieldName = this.determineAdditionalFieldName(authType);
        if (determineFieldName == null) {
            return;
        }
        if ("radius_client_info.username".equals(determineFieldName)) {
            additionSearch = com.tplink.smb.omada.common.util.b.b.c((String)additionSearch);
        }
        Criteria leftCriteria = new Criteria("auth_type").is((Object)authType.w);
        Criteria rightCriteria = new Criteria(determineFieldName).regex(T.g((String)additionSearch), "i");
        orCriteria.add(new Criteria().andOperator(new Criteria[]{leftCriteria, rightCriteria}));
    }

    private String determineAdditionalFieldName(com.tplink.smb.omada.maintenance.common.a authType) {
        switch (authType) {
            case c: 
            case i: {
                return "radius_client_info.username";
            }
            case d: {
                return "voucher.code";
            }
            case f: {
                return "local_user.user_name";
            }
            case m: {
                return "form_name";
            }
        }
        return null;
    }

    private void handleAuthClientQuery(List<Criteria> andCriteria, Map.Entry<String, Object> entry, b queryData) {
        if (Objects.equals(entry.getKey(), "timeStart") || Objects.equals(entry.getKey(), "timeEnd")) {
            return;
        }
        String dbKey = (String)com.tplink.smb.omada.maintenance.common.b.ap.get(entry.getKey());
        if (T.a((String)dbKey)) {
            log.warn("invalid search key {} in auth client data export.", (Object)entry.getKey());
            return;
        }
        andCriteria.add(Criteria.where((String)dbKey).is(entry.getValue()));
    }
}

