/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.port.mongo.device.configsync;

import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Sorts;
import com.tplink.smb.omada.client.port.mongo.data.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.DeviceComponentConfigMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.DeviceComponentConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.DeviceConfigHistoryPO;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.ItemEntryPO;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.k;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.util.CollectionUtils;

public class DeviceConfigHistoryMaintRepository
extends q<DeviceConfigHistoryPO, c>
implements g<DeviceConfigHistoryPO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceConfigHistoryMaintRepository.class);
    private final String DEVICE_CONFIG_HISTORY = "deviceconfighistory";
    private final int BATCH_SIZE = 400;
    private final String OSW_CLI_CONFIG = "osw_cli_config";
    private final DeviceComponentConfigMaintRepository deviceComponentConfigMaintRepository = DeviceComponentConfigMaintRepository.getInstance();
    private final MongoTemplate mongoTemplate = (MongoTemplate)a.a((String)"dataManagerMongoTemplate");
    private final k deviceConfigSliceStrategy = (k)a.b(k.class);
    private static final DeviceConfigHistoryMaintRepository instance = new DeviceConfigHistoryMaintRepository();

    private DeviceConfigHistoryMaintRepository() {
    }

    public static DeviceConfigHistoryMaintRepository getInstance() {
        return instance;
    }

    public Set<String> getCollectionName() {
        HashSet<String> collectionSet = new HashSet<String>();
        try {
            long end = System.currentTimeMillis() / 1000L;
            long start = end - 2592000L;
            this.iteratorCollectionsByTime(Sort.Direction.DESC, start, end, collectionSet::add);
        }
        catch (Exception e2) {
            log.warn("get deviceconfighisoty collection name error", (Throwable)e2);
        }
        log.info("config history data upgrade, collection set is {}", collectionSet.toArray());
        return collectionSet;
    }

    public void findDeviceConfigHistoryByPage(String srcCollection, String dstCollection) {
        try {
            log.info("config history old data move: srcCollection is {}, dstCollection is {}", (Object)srcCollection, (Object)dstCollection);
            Bson bson = Sorts.orderBy((Bson[])new Bson[]{Sorts.ascending((String[])new String[]{"site_id"}), Sorts.ascending((String[])new String[]{"mac"})});
            MongoCursor cursor = this.mongoTemplate.getCollection(srcCollection).find().sort(bson).batchSize(400).iterator();
            if (!cursor.hasNext()) {
                return;
            }
            Document configHistory = (Document)cursor.next();
            String mac = configHistory.getString((Object)"mac");
            String siteId = configHistory.getString((Object)"site_id");
            ArrayList<Document> deviceConfigHistoryDocumentList = new ArrayList<Document>();
            deviceConfigHistoryDocumentList.add(configHistory);
            log.debug("config history old data upgrade first mac {}, site {}, size is {} ", new Object[]{mac, siteId, deviceConfigHistoryDocumentList.size()});
            while (cursor.hasNext()) {
                Document document = (Document)cursor.next();
                if (document.getString((Object)"site_id").equals(siteId) && document.getString((Object)"mac").equals(mac)) {
                    deviceConfigHistoryDocumentList.add(document);
                    continue;
                }
                siteId = document.getString((Object)"site_id");
                mac = document.getString((Object)"mac");
                log.debug("config history old data upgrade next mac {}, site {}, size is {} ", new Object[]{mac, siteId, deviceConfigHistoryDocumentList.size()});
                List<DeviceConfigHistoryPO> deviceConfigHistoryPOList = deviceConfigHistoryDocumentList.stream().map(src -> (DeviceConfigHistoryPO)this.mongoTemplate.getConverter().read(DeviceConfigHistoryPO.class, src)).toList();
                this.mergeDeviceConfigHistoryAndBatchInsert(deviceConfigHistoryPOList);
                deviceConfigHistoryDocumentList.clear();
                deviceConfigHistoryDocumentList.add(document);
            }
            if (!CollectionUtils.isEmpty(deviceConfigHistoryDocumentList)) {
                log.debug("config history old data upgrade last mac {}, site {}, size is {} ", new Object[]{mac, siteId, deviceConfigHistoryDocumentList.size()});
                List<DeviceConfigHistoryPO> deviceConfigHistoryPOList = deviceConfigHistoryDocumentList.stream().map(src -> (DeviceConfigHistoryPO)this.mongoTemplate.getConverter().read(DeviceConfigHistoryPO.class, src)).toList();
                this.mergeDeviceConfigHistoryAndBatchInsert(deviceConfigHistoryPOList);
            }
        }
        catch (Exception e2) {
            log.warn("data update error from deviceconfighistory to devicecomponentconfig", (Throwable)e2);
        }
    }

    public void mergeDeviceConfigHistoryAndBatchInsert(List<DeviceConfigHistoryPO> deviceConfigHistoryList) {
        Map<String, List<DeviceConfigHistoryPO>> componentAndHistoryMap = deviceConfigHistoryList.stream().collect(Collectors.groupingBy(DeviceConfigHistoryPO::getComponent));
        ArrayList<DeviceComponentConfigPO> finalUpdateDeviceComponentConfig = new ArrayList<DeviceComponentConfigPO>();
        for (Map.Entry<String, List<DeviceConfigHistoryPO>> entry : componentAndHistoryMap.entrySet()) {
            List<DeviceConfigHistoryPO> configHistoryWithSameComponent = entry.getValue();
            HashSet<Integer> statusSet = new HashSet<Integer>();
            HashMap<String, ItemEntryPO> itemEntryMap = new HashMap<String, ItemEntryPO>();
            for (DeviceConfigHistoryPO deviceConfigHistoryPO : configHistoryWithSameComponent) {
                ItemEntryPO innerItem;
                if (!"osw_cli_config".equals(deviceConfigHistoryPO.getComponent()) && Objects.isNull(deviceConfigHistoryPO.getItemEntryId()) || !Objects.nonNull((innerItem = this.transDeviceConfigHistoryToItemEntry(deviceConfigHistoryPO, statusSet)).getItemEntryId())) continue;
                itemEntryMap.put(this.transConfigItemIdWithoutDot(innerItem.getItemEntryId()), innerItem);
            }
            if (CollectionUtils.isEmpty(itemEntryMap)) continue;
            int initialStatus = 0;
            block7: for (Integer status : statusSet) {
                switch (status) {
                    case 3: {
                        ++initialStatus;
                        continue block7;
                    }
                    case 2: {
                        initialStatus += 4;
                        continue block7;
                    }
                    case 5: {
                        initialStatus += 2;
                        continue block7;
                    }
                }
                initialStatus += 0;
            }
            DeviceComponentConfigPO deviceComponentConfigPO = DeviceComponentConfigPO.builder().omadacId(configHistoryWithSameComponent.get(0).getOmadacId()).siteId(configHistoryWithSameComponent.get(0).getSiteId()).mac(configHistoryWithSameComponent.get(0).getMac()).component(configHistoryWithSameComponent.get(0).getComponent()).itemEntryList(itemEntryMap).createTime(Long.valueOf(System.currentTimeMillis())).time(Long.valueOf(System.currentTimeMillis())).status(Integer.valueOf(initialStatus)).build();
            finalUpdateDeviceComponentConfig.add(deviceComponentConfigPO);
        }
        this.deviceComponentConfigMaintRepository.insetAll(finalUpdateDeviceComponentConfig);
    }

    private ItemEntryPO transDeviceConfigHistoryToItemEntry(DeviceConfigHistoryPO deviceConfigHistory, Set<Integer> statusSet) {
        ItemEntryPO innerItem = new ItemEntryPO();
        if ("osw_cli_config".equals(deviceConfigHistory.getComponent())) {
            innerItem.setId(Objects.nonNull(deviceConfigHistory.getId()) ? deviceConfigHistory.getId() : this.nextId());
            if (Objects.nonNull(deviceConfigHistory.getName()) && Objects.nonNull(deviceConfigHistory.getCliType())) {
                innerItem.setItemEntryId(deviceConfigHistory.getName() + deviceConfigHistory.getCliType());
            }
        } else if (!"osw_cli_config".equals(deviceConfigHistory.getComponent())) {
            innerItem.setItemEntryId(deviceConfigHistory.getItemEntryId());
        }
        if (Objects.nonNull(deviceConfigHistory.getModel())) {
            innerItem.setModel(deviceConfigHistory.getModel());
        }
        if (Objects.nonNull(deviceConfigHistory.getCliType())) {
            innerItem.setCliType(deviceConfigHistory.getCliType());
        }
        if (Objects.nonNull(deviceConfigHistory.getName())) {
            innerItem.setName(deviceConfigHistory.getName());
        }
        if (Objects.nonNull(deviceConfigHistory.getOperation())) {
            innerItem.setOperation(deviceConfigHistory.getOperation());
        }
        if (Objects.nonNull(deviceConfigHistory.getTime())) {
            innerItem.setTime(deviceConfigHistory.getTime());
        }
        if (Objects.nonNull(deviceConfigHistory.getStatus())) {
            innerItem.setStatus(deviceConfigHistory.getStatus());
            statusSet.add(deviceConfigHistory.getStatus());
        }
        if (Objects.nonNull(deviceConfigHistory.getErrorCode())) {
            innerItem.setErrorCode(deviceConfigHistory.getErrorCode());
        }
        if (Objects.nonNull(deviceConfigHistory.getUiErrorCode())) {
            innerItem.setUiErrorCode(deviceConfigHistory.getUiErrorCode());
        }
        if (Objects.nonNull(deviceConfigHistory.getErrLineNum())) {
            innerItem.setErrLineNum(deviceConfigHistory.getErrLineNum());
        }
        if (Objects.nonNull(deviceConfigHistory.getErrCMD())) {
            innerItem.setErrCMD(deviceConfigHistory.getErrCMD());
        }
        if (Objects.nonNull(deviceConfigHistory.getPosition())) {
            innerItem.setPosition(deviceConfigHistory.getPosition());
        }
        if (Objects.nonNull(deviceConfigHistory.getIgnore())) {
            innerItem.setIgnore(deviceConfigHistory.getIgnore());
        }
        if (Objects.nonNull(deviceConfigHistory.getFeature())) {
            innerItem.setFeature(deviceConfigHistory.getFeature());
        }
        if (Objects.nonNull(deviceConfigHistory.getNotSupportInfo())) {
            innerItem.setNotSupportInfo(deviceConfigHistory.getNotSupportInfo());
        }
        if (Objects.nonNull(deviceConfigHistory.getNotSupportInfoList())) {
            innerItem.setNotSupportInfoKeyList(deviceConfigHistory.getNotSupportInfoList());
        }
        if (Objects.nonNull(deviceConfigHistory.getInfoType())) {
            innerItem.setInfoType(deviceConfigHistory.getInfoType());
        }
        if (Objects.nonNull(deviceConfigHistory.getUiErrorMsg())) {
            innerItem.setUiErrorMsg(deviceConfigHistory.getUiErrorMsg());
        }
        if (Objects.nonNull(deviceConfigHistory.getCreateTime())) {
            innerItem.setCreateTime(deviceConfigHistory.getCreateTime());
        }
        return innerItem;
    }

    public String transConfigItemIdWithoutDot(String configItemId) {
        if (!configItemId.contains(".")) {
            return configItemId;
        }
        return configItemId.replace(".", "__");
    }

    private String nextId() {
        return ObjectId.get().toString();
    }

    @Override
    public Iterable<DeviceConfigHistoryPO> findForBackup(String collectionName, c omadacId, d siteId, long startTimeSec, long endTimeSec) {
        return null;
    }

    @Override
    public List<String> getCollectionNameList() {
        return this.listCollectionNamesFromDB();
    }

    protected int hashCodeOfKey(c key) {
        return Optional.ofNullable(key).map(c::a).map(String::hashCode).orElse(0);
    }

    protected p<DeviceConfigHistoryPO> getStrategy() {
        return this.deviceConfigSliceStrategy;
    }

    protected IndexDefinition[] getIndexDefinitions() {
        return DeviceConfigHistoryPO.INDEX_DEFINITIONS;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    protected String getCollectionNameOrPrefixIfSliced() {
        return "deviceconfighistory";
    }

    protected Class<DeviceConfigHistoryPO> getPOClass() {
        return DeviceConfigHistoryPO.class;
    }
}

