/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.port.mongo.device.configsync;

import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.DeviceComponentConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.configsync.e;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.util.CollectionUtils;

public class DeviceComponentConfigMaintRepository
extends q<DeviceComponentConfigPO, c> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceComponentConfigMaintRepository.class);
    private static final String DEVICE_COMPONENT_CONFIG = "devicecomponentconfig";
    private static final int BATCH_SIZE = 400;
    private final MongoTemplate mongoTemplate = (MongoTemplate)a.a((String)"dataManagerMongoTemplate");
    private final e deviceComponentConfigSliceStrategy = (e)a.b(e.class);
    private static final DeviceComponentConfigMaintRepository instance = new DeviceComponentConfigMaintRepository();

    private DeviceComponentConfigMaintRepository() {
    }

    public static DeviceComponentConfigMaintRepository getInstance() {
        return instance;
    }

    public void insetAll(List<DeviceComponentConfigPO> deviceComponentConfigs) {
        if (CollectionUtils.isEmpty(deviceComponentConfigs)) {
            return;
        }
        Map<String, List<DeviceComponentConfigPO>> collectionNameMap = deviceComponentConfigs.stream().collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameMap.forEach((collectionName, poList) -> {
            int totalSize = poList.size();
            if (totalSize > 400) {
                List batchPoList = com.tplink.smb.omada.common.util.e.a((List)poList, (int)totalSize, (int)400);
                batchPoList.forEach(batchPos -> this.batchInsert((String)collectionName, (List<DeviceComponentConfigPO>)batchPos));
            } else {
                this.batchInsert((String)collectionName, (List<DeviceComponentConfigPO>)poList);
            }
            log.debug("mongo.insertAll device component config list, collection name: {}, size: {}", collectionName, (Object)totalSize);
        });
    }

    private void batchInsert(String collectionName, List<DeviceComponentConfigPO> eachPoList) {
        if (CollectionUtils.isEmpty(eachPoList)) {
            return;
        }
        try {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, this.getPOClass(), collectionName);
            bulkOperations.insert(eachPoList);
            bulkOperations.execute();
        }
        catch (Exception e2) {
            log.warn("data upgrade for collection {} batch insert devicecomponentconfig exception: {}", new Object[]{collectionName, e2.getMessage(), e2});
        }
    }

    protected int hashCodeOfKey(c key) {
        return Optional.ofNullable(key).map(c::a).map(String::hashCode).orElse(0);
    }

    protected p<DeviceComponentConfigPO> getStrategy() {
        return this.deviceComponentConfigSliceStrategy;
    }

    protected IndexDefinition[] getIndexDefinitions() {
        return DeviceComponentConfigPO.INDEX_DEFINITIONS;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    protected String getCollectionNameOrPrefixIfSliced() {
        return DEVICE_COMPONENT_CONFIG;
    }

    protected Class<DeviceComponentConfigPO> getPOClass() {
        return DeviceComponentConfigPO.class;
    }
}

